--
--             This file is part of the New World OS project
--                    Copyright (C) 2009  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: song_list.e,v $
-- Revision 1.1  2009/07/21 18:15:55  jsedwards
-- New class created from code taken from play_music.e.
--

class SONG_LIST

creation with_capacity

feature

   list: FIXED_ARRAY[STRING]

   with_capacity(capacity: INTEGER) is
      do
         !!list.with_capacity(capacity)
      end

   has(name: STRING): BOOLEAN is
      do
         Result := list.has(name)
      end

   add_last(name: STRING) is
      do
         list.add_last(name)
      end

   last: STRING is
      do
         Result := list.last
      end

   remove_last is
      do
         list.remove_last
      end

   read_list(path: STRING): BOOLEAN is
      local
         played_list_file: TEXT_FILE_READ
         temp: STRING
      do
         !!played_list_file.connect_to(path)

         if played_list_file.is_connected then
            from
               played_list_file.read_line
            until
               played_list_file.end_of_input
            loop
               !!temp.copy(played_list_file.last_line)
               list.add_last(temp)
               played_list_file.read_line
            end

            played_list_file.disconnect

            Result := True
         end
      end

   write_list(path: STRING): BOOLEAN is
      local
         played_list_file: TEXT_FILE_WRITE
         i: INTEGER
      do
         !!played_list_file.connect_to(path)

         if played_list_file.is_connected then
            from
               i := list.lower
            until
               i > list.upper
            loop
               played_list_file.put_line(list.item(i))
               i := i + 1
            end

            played_list_file.disconnect

            Result := True
         end
      end

end

