/*
--             This file is part of the New World OS project
--                 Copyright (C) 2004-2009  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: objectify.c,v $
-- Revision 1.202  2009/06/30 11:14:45  jsedwards
-- Added include of new header.h file and moved nwos_archive_version function
-- from the disk_io.c file.
--
-- Revision 1.201  2009/06/13 15:31:45  jsedwards
-- Added include of disk_io.h to define stuff to write empty chunk for create
-- root when archive is a file, needed for add_password.
--
-- Revision 1.200  2009/06/13 12:53:14  jsedwards
-- Merged changes from Alpha_29.10 branch (version Alpha_29.11).
--
-- Revision 1.195.2.4  2009/06/07 15:08:16  jsedwards
-- Fix Bug #2802374 - change to allocate a new chunk if the archive is a file.
--
-- Revision 1.195.2.3  2009/06/06 14:41:40  jsedwards
-- Moved nwos_ask_yes_or_no function to new dialog.c file.
--
-- Revision 1.195.2.2  2009/05/23 03:45:46  jsedwards
-- Removed ifndef public mode around call to nwos_terminate_objectify because
-- it needs to be called in public mode too.
--
-- Revision 1.195.2.1  2009/05/18 12:38:49  jsedwards
-- Changed so nwos_remove_object is not compiled in public mode.  (Note: in the
-- main trunk nwos_remove_object was moved to the objects.c file, so this change
-- was made there in the main trunk.)
--
-- Revision 1.199  2009/04/19 14:20:05  jsedwards
-- Added include of chunk_info.h file to define nwos_hash_ref.
--
-- Revision 1.198  2009/04/14 11:51:10  jsedwards
-- Moved external declarations for update file functions to objects.c file.
--
-- Revision 1.197  2009/04/13 13:37:47  jsedwards
-- Moved object related functions to new objects.c file.
--
-- Revision 1.196  2009/04/10 14:20:58  jsedwards
-- Added nwos_flush_to_disk function that flushes any dirty reference lists
-- and then flushes the disk io.
--
-- Revision 1.195  2009/04/01 14:44:59  jsedwards
-- Added call to check blocks available in create root so that last_ref is set.
--
-- Revision 1.194  2009/03/19 11:38:21  jsedwards
-- Wrapped call to nwos_set_security_level with ifdef CHANGE_SECURITY_TO_DENSITY
-- because what was called security level stuff is temporarily disabled.
--
-- Revision 1.193  2009/03/14 22:53:18  jsedwards
-- Moved external declarations for nwos_update_file_001_object_to_current and
-- nwos_update_file_002_object_to_current from the disk_io.h file.
--
-- Revision 1.192  2009/03/14 18:58:36  jsedwards
-- Moved security related variables and functions to security.c and changed
-- to call them there.
--
-- Revision 1.191  2009/03/14 14:35:55  jsedwards
-- Deleted block_contains_object and nwos_object_exists functions, no longer
-- needed.
--
-- Revision 1.190  2009/03/14 03:19:59  jsedwards
-- Added includes for bit_map.h and objectify.h files.
--
-- Revision 1.189  2009/03/13 12:49:17  jsedwards
-- Renamed old nwos_remove_object function that was in disk_io.c to
-- nwos_erase_block and added nwos_remove_object function, that calls
-- nwos_erase_block, to this file.
--
-- Revision 1.188  2009/03/11 12:28:40  jsedwards
-- Moved nwos_malloc, nwos_realloc, and nwos_free functions to new mem_alloc.c
-- file.
--
-- Revision 1.187  2009/03/08 19:53:46  jsedwards
-- Fixed to compile correctly in PUBLIC_MODE again.
--
-- Revision 1.186  2009/03/08 06:34:10  jsedwards
-- Changed include objectify_private.h to disk_io.h and added include of new
-- class_definition.h file.  Moved global class reference variables to
-- class_definition.c file.  Added new nwos_is_ready and nwos_is_writable
-- functions.
--
-- Revision 1.185  2009/03/01 14:58:40  jsedwards
-- Added nwos_realloc function.
--
-- Revision 1.184  2009/02/23 15:05:47  jsedwards
-- Moved security_level, nwos_set_security_level, and nwos_generate_new_id to
-- new gen_id.c file.
--
-- Revision 1.183  2009/02/17 01:51:35  jsedwards
-- Fixed to compile correctly in PUBLIC_MODE.
--
-- Revision 1.182  2009/01/31 12:30:20  jsedwards
-- Moved functions to deal with various file class definitions to
-- class_definition.c file.
--
-- Revision 1.181  2008/10/31 13:00:57  jsedwards
-- Moved nwos_reference_type and is_valid_private_reference functions to
-- disk_io.c and renamed the latter to nwos_is_private_reference.
--
-- Revision 1.180  2008/10/28 10:28:55  jsedwards
-- Changed so that skip_backwards parameter to set_allocation_parameters is a
-- positive (unsigned) value.
--
-- Revision 1.179  2008/10/20 13:19:17  jsedwards
-- Changed root transformations to use a simple add to the uppermost bits of
-- the reference number instead of multiplying by a prime number.  The multiply
-- did not distribute the numbers evenly over the entire space, the ended up
-- being clustered together.  Also fixed nwos_create_root to randomize the
-- transform so that the root object is not always in the same place.  This
-- also takes care of root object references that ended up in the public or
-- temporary space.
--
-- Revision 1.178  2008/10/20 11:45:13  jsedwards
-- Added 0x00000001 to root_transform_primes (done on 2008/10/03 forgot to
-- check in).
--
-- Revision 1.177  2008/10/03 12:05:58  jsedwards
-- Change to multiply reference by one of 16 prime numbers to transform it,
-- instead of rotating, inverting and reversing.  One problem with the
-- rotating, inverting and reversing was that some references didn't transform
-- well, the same values were repeated, for example: 0x55555555.
--
-- Revision 1.176  2008/09/30 13:28:00  jsedwards
-- First attempt at transforming root object references.  Incomplete, do not use!
--
-- Revision 1.175  2008/09/01 18:22:17  jsedwards
-- Moved most of the code from add_password.c and prep_disk.c that prepared
-- to create the root object into nwos_create_root.  Also fixed it to read
-- the password twice and verify they are the same before creating it.
--
-- Revision 1.174  2008/09/01 12:50:14  jsedwards
-- Extracted new function "setup_from_big_key" from nwos_initialize_objectify
-- to create the sequence table from the big_key.
--
-- Revision 1.173  2008/09/01 03:06:06  jsedwards
-- Changed so that nwos_initialize_objectify calls nwos_set_root and allows
-- up to three tries for entering the correct password.
--
-- Revision 1.172  2008/08/31 18:00:14  jsedwards
-- Add assert around call to nwos_read_object_from_disk because it now returns
-- false when it fails, whereas before it would assert itself.
--
-- Revision 1.171  2008/08/31 10:49:57  jsedwards
-- Changed nwos_read_variable_sized_object_from_disk to return bool (success
-- or failure) instead of asserting on failure.
--
-- Revision 1.170  2008/08/31 10:38:04  jsedwards
-- Change nwos_read_object_from_disk to return success or failure instead of
-- asserting when a failure occurs.
--
-- Revision 1.169  2008/08/31 10:19:17  jsedwards
-- Change check_object_data to return true or false instead of exiting.
--
-- Revision 1.168  2008/08/30 12:53:53  jsedwards
-- Corrected previous log entry (accidentally checked in with the incorrect
-- message).  NO code changes.
--
-- Revision 1.167  2008/08/30 12:46:15  jsedwards
-- Changed nwos_initialize_objectify to get the pass phrase instead of
-- passing in the key parameters.  It now returns the private root object
-- reference.
--
-- Revision 1.166  2008/08/01 13:42:20  jsedwards
-- Added setting header to point to object back in read object from disk
-- functions, so if object is larger than one block it reads the correct data
-- checksum.  It was changed to point to extra block when checking for old
-- encryption in previous check in.
--
-- Revision 1.165  2008/07/31 14:40:25  jsedwards
-- Changed to try old decryption algorithm if checksum fails after reading
-- with new decryption algorithm.
--
-- Revision 1.164  2008/07/31 14:16:52  jsedwards
-- Fixed bug in check_object_header where it was or'ing together the checksum
-- comparison instead of and'ing them, so if any one byte matched it considered
-- it correct, instead of testing each and every byte.
--
-- Revision 1.163  2008/07/31 11:19:57  jsedwards
-- Changed the order of the blowfish encryption and the reordering of the bytes
-- to make it harder to decrypt the data.  Originally it reordered the bytes
-- first and then applied the encryption.  The problem with that was that if
-- the encryption was broken it would be more trivial to reorder the data
-- because the data itself would give hints as to the correct position of the
-- data (zeros could be picked out for example).  Now the encryption is applied
-- first and then the data is scrambled.  This way the descrambling has to be
-- done first while the data is hidden, when there aren't any clues as to it's
-- position.
--
-- Revision 1.162  2008/07/30 14:19:21  jsedwards
-- Eliminated 'ptrobj' variable in encrypt and decrypt functions, changed to
-- use memcpy instead of for loop, and eliminated copying the first 8 bytes
-- twice.
--
-- Revision 1.161  2008/07/30 14:06:02  jsedwards
-- Changed 'buffer1' and 'buffer2' in the decrypt and encrypt functions to
-- 'scrambled' and 'encrypted' respectively, to make it easier to follow the
-- flow of the data.
--
-- Revision 1.160  2008/07/30 13:48:19  jsedwards
-- Removed old DEBUG_ENCRYPTION code, it is just cluttering up the place.
--
-- Revision 1.159  2008/07/19 14:40:55  jsedwards
-- Added a hack to allow the root object to have a public class definition and
-- write_object_to_disk to not assert.
--
-- Revision 1.158  2008/07/19 13:40:57  jsedwards
-- Added code in get_file_class_reference to check to see if the latest file
-- class revision has been added if it didn't exist when first called.
--
-- Revision 1.157  2008/07/17 13:12:03  jsedwards
-- Fix nwos_write_object_to_disk and nwos_overwrite_object_to_disk to verify
-- the class_definition of the object is of the correct type, public or
-- private.
--
-- Revision 1.156  2008/07/16 02:32:24  jsedwards
-- Fix Bug #2016420 - "After expanding a compressed 0026 file, bad checksum
-- error".  The get_file_002_reference did not return the correct reference
-- when there was no private file_001 reference.  Replaced code in the
-- get_file_00X_reference functions with a call to the new get_file_references
-- that finds all of the old file references correctly.
--
-- Revision 1.155  2008/07/15 19:10:41  jsedwards
-- Added asserts in old get_00x_file_reference functions to verify that the
-- one put in the table by get_file_references function matches.
--
-- Revision 1.154  2008/07/15 14:41:46  jsedwards
-- Fixed get_file_references function to get private references now.
--
-- Revision 1.153  2008/07/15 14:08:11  jsedwards
-- Added new get_file_references function that for now just reads the public
-- file class definitions.
--
-- Revision 1.152  2008/05/24 11:01:49  jsedwards
-- Changed file_XXX_referenc variables to file_references[] array.
--
-- Revision 1.151  2008/05/24 10:46:30  jsedwards
-- Moved get_file_class_reference function after the get_file_XXX_reference
-- functions.  NO code changes!
--
-- Revision 1.150  2008/05/24 10:44:06  jsedwards
-- Moved 'result' variables out of the get_file_XXX_reference functions and
-- made static variables (global to this file) for them.
--
-- Revision 1.149  2008/05/06 13:31:03  jsedwards
-- Changed return type of nwos_read_object_from_disk_and_decrypt to bool
-- instead of void and changed it to return false if the block read fails.
-- Added assert around calls to nwos_read_object_from_disk_and_decrypt.
--
-- Revision 1.148  2008/03/20 13:13:50  jsedwards
-- Added nwos_in_public_mode function.
--
-- Revision 1.147  2008/03/15 17:10:15  jsedwards
-- Added 'nwos_get_object_class_without_update' function that gets an object's
-- class without attempting to update it to the latest revision.  This avoids
-- any nasty recursion problems.
--
-- Revision 1.146  2008/03/14 12:33:25  jsedwards
-- Added get_file_002_reference function and modified nwos_get_object_class
-- and nwos_read_object_from_disk to check for revision 002 FILE objects.
--
-- Revision 1.145  2008/02/27 05:48:32  jsedwards
-- Change so that if no blowfish, linear, and serial values are specified
-- (as is the case for expand_sparse) it doesn't try to initialize the
-- security stuff.
--
-- Revision 1.144  2008/02/15 15:23:57  jsedwards
-- Fix to compile correctly in PUBLIC_MODE without blowfish_key,
-- linear_after_first, and serial_after_first.  They were wrapped in
-- #ifndef PUBLIC_MODE to eliminate warnings in revision 1.141.
--
-- Revision 1.143  2008/02/11 04:09:40  jsedwards
-- Changed to handle new PUBLIC AccessType to only open Public Objects.
--
-- Revision 1.142  2008/02/03 02:14:42  jsedwards
-- Change parameter to initialize_objectify to AccessType instead of StorgeType
-- and add 'const' to path parameter.
--
-- Revision 1.141  2008/02/03 02:13:00  jsedwards
-- Fixed to compile in PUBLIC_MODE without warnings.
--
-- Revision 1.140  2008/01/18 03:22:32  jsedwards
-- Rearranged code in nwos_create_root to not see if the block has been
-- written already, instead test the bit map.
--
-- Revision 1.139  2007/12/25 14:26:18  jsedwards
-- Added #ifndef PUBLIC_MODE around code to upgrade file object, it is not
-- needed in PUBLIC_MODE and this way there is no need to include file.o.
--
-- Revision 1.138  2007/11/24 16:59:42  jsedwards
-- Fixed to compile correctly when compiled with PUBLIC_MODE defined.
--
-- Revision 1.137  2007/10/25 03:22:20  jsedwards
-- Move 'last_ref' to disk_io.c.
--
-- Revision 1.136  2007/10/24 14:30:04  jsedwards
-- Eliminate push and pop security levels.  They are no longer used and to
-- simplify moving last_ref to disk_io.c.
--
-- Revision 1.135  2007/10/19 03:52:55  jsedwards
-- Halved the range for the medium and high security levels because they are
-- plus and minus.
--
-- Revision 1.134  2007/10/19 03:43:40  jsedwards
-- Changed the density values for the very low to high security levels, to
-- spread them out more.
--
-- Revision 1.133  2007/10/19 02:11:37  jsedwards
-- Added defines for 1_in_N security levels and new set_security_level function
-- that is called by the other security level functions, which sets the chunk
-- allocation parameters in disk_io.c.
--
-- Revision 1.132  2007/10/07 16:35:32  jsedwards
-- Moved 'last_ref' outside of generate_new_id function so it is global and
-- can be cleared by the new 'restart_id_generation' function.  Also added
-- calls to the new 'restart_id_generation' function when security level is
-- changed.
--
-- Revision 1.131  2007/08/12 20:45:00  jsedwards
-- Change all of the "Encryption Level" stuff to "Security Level" because it
-- doesn't really change the encryption at all, all it does is change the
-- randomization of where objects are stored.
--
-- Revision 1.130  2007/08/06 02:22:01  jsedwards
-- Changed values passed to 1_in_N function to 7 for very-low, 19 for low,
-- 43 for medium, and 113 for high (1_in_N functionality is different now).
--
-- Revision 1.129  2007/08/03 01:04:53  jsedwards
-- Change to allow "High" encryption level to be used and changed low and
-- medium to skip 32 and 128 instead of 64 and 512.  Made high skip 512.
--
-- Revision 1.128  2007/07/30 18:35:02  jsedwards
-- Added code to save the old file class in case an updated private class
-- definition has not been created yet.
--
-- Revision 1.127  2007/07/29 21:47:08  jsedwards
-- Fixed bug in assert that is not used anymore (just in case it is ever
-- active again).
--
-- Revision 1.126  2007/07/29 19:43:09  jsedwards
-- Removed variable that is now unused because of eliminating assert in
-- previous revision.
--
-- Revision 1.125  2007/07/29 19:39:24  jsedwards
-- Bug #1754741 - ifdef'd out assert to check that block was zero before
-- writing to it.  This was before the bit map was used and now we assume
-- the bit map is correct and we can write the block even if it is non-zero.
--
-- Revision 1.124  2007/07/29 18:25:54  jsedwards
-- Added boolean variable to get_file_001_reference so that if it was called
-- recursively it would simply return instead of overflowing the stack.
--
-- Revision 1.123  2007/07/29 03:48:17  jsedwards
-- Add get_file_class_reference function to get the most up to date File class
-- reference and make sure get_object_class returns it if the object is an
-- older file object.
--
-- Revision 1.122  2007/07/28 15:20:47  jsedwards
-- Fixed the case in finding the File 001 class where no private File objects
-- have been created and a private file class doesn't exist.  Also fixed the
-- order saving the reference in the loop so it saved it before reading next.
--
-- Revision 1.121  2007/07/28 04:23:31  jsedwards
-- Add code to check for old File object and update it to new if found.
--
-- Revision 1.120  2007/07/06 15:02:34  jsedwards
-- Moved nwos_next_public_ref and nwos_generate_new_public_id to disk_io.c.
--
-- Revision 1.119  2007/07/01 19:44:12  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.118  2007/06/26 14:17:25  jsedwards
-- Move generation of random id functions to disk_io.c.
--
-- Revision 1.117  2007/06/25 02:37:32  jsedwards
-- Moved all disk i/o related variables, functions, and code to new disk_io.c
-- file.
--
-- Revision 1.116  2007/06/24 17:31:58  jsedwards
-- Removed variable and functions that are no longer used and #if 0'd out.
--
-- Revision 1.115  2007/06/24 14:11:46  jsedwards
-- Removed out of date comment about how objects are stored and end_of_time
-- variable which isn't used anymore.
--
-- Revision 1.114  2007/06/23 14:28:40  jsedwards
-- Added code to close the public file in nwos_terminate.
--
-- Revision 1.113  2007/06/22 22:06:31  jsedwards
-- Fix so it will compile correctly in PUBLIC_MODE.
--
-- Revision 1.112  2007/06/22 15:04:15  jsedwards
-- Added testing public object file header for correct version, etc.
--
-- Revision 1.111  2007/06/22 14:16:04  jsedwards
-- Changed location of public object file to a define in config.h.
--
-- Revision 1.110  2007/06/21 22:37:28  jsedwards
-- Added temporary code to verify new get_object_size function returns the
-- same value as the class specific function passed into read_variable_sized.
--
-- Revision 1.109  2007/06/20 03:46:43  jsedwards
-- Added special function to set the total_private_blocks for expand_sparse.
--
-- Revision 1.108  2007/06/19 18:48:32  jsedwards
-- Changed to use separate public objects file instead of having it part of
-- private storage.
--
-- Revision 1.107  2007/05/10 14:42:48  jsedwards
-- Add conditionals for compiling export_c_structs (NO_INDEX_FILE).  Fix
-- to free malloc'd path name.
--
-- Revision 1.106  2007/05/10 13:48:23  jsedwards
-- Fix problems with storing index file.
--
-- Revision 1.105  2007/05/10 12:36:15  jsedwards
-- Add code to save index into file and use it if possible.
--
-- Revision 1.104  2007/04/19 12:01:54  jsedwards
-- Move test for bad open right after open.
--
-- Revision 1.103  2007/04/19 11:55:16  jsedwards
-- Split two lines that somehow got concatenated into one line. NO code changes!
--
-- Revision 1.102  2007/04/15 16:18:54  jsedwards
-- Change generate random id to try longer to find a free block.
--
-- Revision 1.101  2007/04/14 12:30:32  jsedwards
-- Remove hack that forced it to not use IDs in the first pass of the storage
-- device, which was intended to balance out old archives that only allocated
-- IDs in the disk range.
--
-- Revision 1.100  2007/04/14 12:28:10  jsedwards
-- Change to allow sparse (regular) file.
--
-- Revision 1.99  2007/04/05 01:45:18  jsedwards
-- Changed 'hash_ref' to 'nwos_hash_ref' so it could be external.
--
-- Revision 1.98  2007/03/27 11:41:11  jsedwards
-- Made total and used, public and private block counts global so that
-- expand_sparse can access them.
--
-- Revision 1.97  2007/03/26 12:32:39  jsedwards
-- Separate last change time into public and private.
--
-- Revision 1.96  2007/03/24 02:22:51  jsedwards
-- Increment used_public_blocks when we allocate a new one.
--
-- Revision 1.95  2007/03/09 13:47:07  jsedwards
-- Fixed to use RESERVED_PUBLIC_BLOCKS to determine if an reference id is
-- public or private (this was broken unless total_public_blocks was exactly
-- equal to RESERVED_PUBLIC_BLOCKS.
--
-- Revision 1.94  2007/03/08 13:51:22  jsedwards
-- Change so output about indexing compressed file goes to stderr instead of
-- stdout.  This way if the standard output doesn't have junk in it.
--
-- Revision 1.93  2007/03/08 13:42:19  jsedwards
-- Changes to allow reading a public compressed file.
--
-- Revision 1.92  2007/03/08 13:04:58  jsedwards
-- Rearranged and added ifndefs to make it compile in public mode without
-- warnings.
--
-- Revision 1.91  2007/03/08 01:14:27  jsedwards
-- Fix hash_uint32 in public_mode to return correct value.
--
-- Revision 1.90  2007/03/02 14:27:31  jsedwards
-- Fixed generate_random_id to generate all 32 bits instead of just 31.
--
-- Revision 1.89  2007/02/27 12:24:30  jsedwards
-- Added test_bit_in_map() and made hash_uint32_ref(), write_block(),
-- set_bit_in_map(), clear_bit_in_map() external.
--
-- Revision 1.88  2007/02/27 03:29:08  jsedwards
-- Change the ID hash to disc block to skip over bit maps instead of leaving
-- holes in the available IDs.
--
-- Revision 1.87  2007/02/25 20:57:01  jsedwards
-- Changed bit map tests in generate new id functions to use the hashed value
-- for testing the bit map instead of the id itself (because the two are no
-- longer the same thing).
--
-- Revision 1.86  2007/02/25 20:53:09  jsedwards
-- Moved test for inside bit map from ref_to_offset into hash_uint32_ref, so
-- it is consistant for all three routines.
--
-- Revision 1.85  2007/02/25 20:48:45  jsedwards
-- Fixed so it doesn't generate a completely random id everytime id is out
-- of total blocks on disk range.
--
-- Revision 1.84  2007/02/24 15:56:03  jsedwards
-- Added clear_bit_in_map function and use it when removing object.
--
-- Revision 1.83  2007/02/24 15:53:37  jsedwards
-- Change reference id hash back to allowing all 32 bits instead of just ids
-- that map directly to a disk block.  This way when the size of the disk or
-- partition changes, it is much more graceful.
--
-- Revision 1.82  2007/02/23 13:27:04  jsedwards
-- Move the strlcpy and strlcat functions from objectify.c to log.c so that
-- log.o can be used without having to drag in the whole objecitfy library.
--
-- Revision 1.81  2007/02/11 16:17:56  jsedwards
-- Added "strlcat" function only for Linux, because it seems to be missing.
-- Also fixed bug in "strlcpy".
--
-- Revision 1.80  2007/02/11 14:28:47  jsedwards
-- Changed all the 'sprintf' calls to 'snprintf' so OpenBSD won't whine so much.
--
-- Revision 1.79  2007/02/11 14:23:01  jsedwards
-- Change all 'off64_t' and 'lseek64' references to 'off_t' and 'lseek',
-- because BSD doesn't dig the whole brain damaged 64 bit thing.
--
-- Revision 1.78  2007/01/27 01:52:16  jsedwards
-- Added global 'verbose' boolean.
--
-- Revision 1.77  2007/01/17 13:15:30  jsedwards
-- Change Encryption_Fast level name to Encryption_Minimal.
--
-- Revision 1.76  2007/01/14 03:58:30  jsedwards
-- Fix create_root in public mode.
--
-- Revision 1.75  2007/01/13 20:00:52  jsedwards
-- Changed so that the bit maps are used to determine if a block is used
-- instead of whether the block is all zeros.  Also set the bit when the
-- reference id is generated so that we don't have the problem when a block
-- isn't written right away.
--
-- Revision 1.74  2007/01/07 03:23:54  jsedwards
-- Added push and pop encryption level routines.  If'd out generate_in_range
-- routine and added generate_new_id_one_in_N_routine.
--
-- Revision 1.73  2007/01/04 17:35:04  jsedwards
-- Fix log message in terminate.  Add routines to compute the percentage of
-- private space used and percentage of chunk used.  Add routine for generating
-- block ids for low level encryption.
--
-- Revision 1.72  2007/01/02 11:18:52  jsedwards
-- Changed so that root object class is always the public class, I can't think
-- of any reason to have a private root object class.  Also changed for the
-- time being that you can't pass the public root in private mode.
--
-- Revision 1.71  2006/12/30 03:45:41  jsedwards
-- Moved NUM_PUBLIC_IDS and NUM_PRIVATE_IDS defines from objectify_private.h
-- to here, because they are only used for older versions (0014 for example).
--
-- Revision 1.70  2006/12/28 23:15:13  jsedwards
-- Added printing of public or private size to terminate when objects were
-- added.
--
-- Revision 1.69  2006/12/27 14:15:24  jsedwards
-- Move log functions out of objectify.c and into a new file log.c.
--
-- Revision 1.68  2006/12/27 12:25:06  jsedwards
-- Add function to put program arguments into log.
--
-- Revision 1.67  2006/12/25 12:04:52  jsedwards
-- Fixes to run in "public_mode".
--
-- Revision 1.66  2006/12/21 13:13:38  jsedwards
-- Change to call find_public_class_definition for getting reference list.
--
-- Revision 1.65  2006/12/20 12:35:13  jsedwards
-- Changed to have two class definition refs, public and private.
--
-- Revision 1.64  2006/12/19 13:38:33  jsedwards
-- Fixed to increment the used_private_blocks.
--
-- Revision 1.63  2006/12/15 14:59:11  jsedwards
-- Changed back to only having two disk areas (Public and Private).
--
-- Revision 1.62  2006/12/14 14:24:53  jsedwards
-- Removed creation of reference list for root object.
--
-- Revision 1.61  2006/12/14 12:19:21  jsedwards
-- Fixed bug so private id gets incremented everytime.
--
-- Revision 1.60  2006/12/13 14:23:38  jsedwards
-- Added encryption level stuff.
--
-- Revision 1.59  2006/12/12 03:11:13  jsedwards
-- Fixed generate_new_private_id function.
--
-- Revision 1.58  2006/12/11 14:40:58  jsedwards
-- Tried to repair some things but now needs more work.
--
-- Revision 1.57  2006/12/11 14:22:09  jsedwards
-- Fixed generate_private_id to use block maps. Incomplete, won't compile!
--
-- Revision 1.56  2006/12/09 01:42:40  jsedwards
-- Added some more "public_mode" ifdef statements.
--
-- Revision 1.55  2006/12/08 17:17:24  jsedwards
-- Added ifdef statements to handle "public_mode" that changes it to deal with
-- public objects.  Fixed bug in generate_new_public_id and added code to
-- assert that it incremented the id by one.  Moved read_class_definition to
-- class_definition.c.
--
-- Revision 1.54  2006/12/08 11:31:21  jsedwards
-- Change to use new disk_header structure.
--
-- Revision 1.53  2006/12/08 10:42:05  jsedwards
-- Change to allow security parameters to be null.
--
-- Revision 1.52  2006/12/05 13:55:33  jsedwards
-- Fix bug in write_public_object where it wasn't passing the clean block to
-- write_block, it was passing the object that wasn't the size of a block.
--
-- Revision 1.51  2006/12/05 04:20:00  jsedwards
-- More changes for new disk header layout.  Removed UNENCRYPTED_FLAG as now
-- unencrypted/encrypted is determined from the reference itself.
--
-- Revision 1.50  2006/12/04 14:58:17  jsedwards
-- First changes for new header, etc.  This version doesn't work!
--
-- Revision 1.49  2006/12/01 05:16:46  jsedwards
-- Added a test in get_object_class to make sure it is not a reference list
-- before trying to compute the header checksum.
--
-- Revision 1.48  2006/12/01 05:11:48  jsedwards
-- Add a strlcpy function only if compiling on Linux because it doesn't have
-- it in the library.
--
-- Revision 1.47  2006/11/27 14:28:26  jsedwards
-- Added test for unencrypted objects in read_and_decrypt and write_and_encrypt
-- functions and skip over encryption stuff if set.
--
-- Revision 1.46  2006/11/27 13:46:46  jsedwards
-- Added functions to encode and decode variable sized counts.
--
-- Revision 1.45  2006/11/19 13:44:30  jsedwards
-- Add time stamp to disk header so we can tell when it was last changed.
--
-- Revision 1.44  2006/11/18 15:09:10  jsedwards
-- Added "max_size" parameter to read_variable_sized_object_from_disk because
-- objects are no longer limited to one file block.
--
-- Revision 1.43  2006/11/18 14:26:47  jsedwards
-- Changed to read and write objects larger than FILE_BLOCK_SIZE (256 bytes).
--
-- Revision 1.42  2006/11/17 12:18:11  jsedwards
-- Added "read_only" flag to keep it from trying to write the header back when
-- read only.
--
-- Revision 1.41  2006/11/11 15:20:37  jsedwards
-- Moved all reference list code into a separate file: reference_list.c.
--
-- Revision 1.40  2006/11/11 14:24:37  jsedwards
-- Made nwos_malloc and nwos_free public (not static) and moved
-- find_class_definiton function to class_definition.c.
--
-- Revision 1.39  2006/11/11 13:58:00  jsedwards
-- Add new generate_new_public_id function.
--
-- Revision 1.38  2006/11/11 13:34:32  jsedwards
-- Made disk header a static global that is read in initialize(), updated with
-- next public reference and written back out in terminate().  Also added a
-- new global variable with the next public reference.
--
-- Revision 1.37  2006/11/11 12:01:05  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.36  2006/11/10 13:39:16  jsedwards
-- Uncommented write_block in write_public_object_to_disk and removed print
-- statements.
--
-- Revision 1.35  2006/11/10 13:32:05  jsedwards
-- Moved Ref_List_First_Block and Ref_List_Extra_Block definitions from
-- objectify.c to objectify_private.h so that import_public_csv can use
-- them also.
--
-- Revision 1.34  2006/11/10 04:11:02  jsedwards
-- Add "write_public_object_to_disk" function and fix hash to deal with
-- public references.
--
-- Revision 1.33  2006/11/04 18:51:07  jsedwards
-- Made a #define in the config.h file for the log file.
--
-- Revision 1.32  2006/11/02 11:49:28  jsedwards
-- Fixed all cases where 'z' was used as a format for 'off64_t' values because
-- the older compiler complains.
--
-- Revision 1.31  2006/10/26 01:22:51  jsedwards
-- Replace the main truck version (1.30) with the latest version from the
-- alpha_05_branch.
--
-- Revision 1.24.2.57  2006/10/25 12:22:29  jsedwards
-- Changed C_struct_class_definition to C_struct_Class_Definition so the case
-- is consistent with all the other C_struct objects.
--
-- Revision 1.24.2.56  2006/10/22 13:05:16  jsedwards
-- Changed so that blocks on disk and reserved public blocks is variable
-- based on values store in disk header.
--
-- Revision 1.24.2.55  2006/10/22 12:40:47  jsedwards
-- Corrected version string error message.
--
-- Revision 1.24.2.54  2006/10/22 00:16:43  jsedwards
-- More fixes for the changing to the separate next_block_ptr to the add to
-- reference list and write reference list.
--
-- Revision 1.24.2.53  2006/10/20 13:25:58  jsedwards
-- Change to have a separate next_block_ptr (for linked list) instead of
-- using the first 4 (unused) bytes of each reference list block as the
-- pointer to the next block.  This wasn't happy when pointers aren't 4 bytes.
--
-- Revision 1.24.2.52  2006/10/17 12:38:37  jsedwards
-- Changed formats in printf statementss to be more compatible with different
-- types (size_t, off64_t) being different sizes.  Also changed format for
-- uint32 to be unsigned instead of long unsigned (unsigned is 32 bits on
-- both 32 and 64 bit machines, whereas long unsigned is 64 on amd64).
--
-- Revision 1.24.2.51  2006/10/16 13:01:05  jsedwards
-- Add code to rewind disk after indexing a compressed file so reading the
-- header works correctly.
--
-- Revision 1.24.2.50  2006/10/14 13:13:45  jsedwards
-- Added code to check the disk header and make sure it is a nwos disk, the
-- version string matches, and the disk size matches what was compiled in.
--
-- Revision 1.24.2.49  2006/10/13 11:47:44  jsedwards
-- Comment out print statement of setting bits in block maps.
--
-- Revision 1.24.2.48  2006/10/12 12:12:22  jsedwards
-- Fixed bug in last ref for generating references in sequence.  Also added
-- function to flush dirty block maps back to disk.
--
-- Revision 1.24.2.47  2006/10/11 13:24:50  jsedwards
-- Add code to set the bits in the bit maps when a block is written.  Note:
-- this version does not use the bit maps for anything.
--
-- Revision 1.24.2.46  2006/10/10 07:30:35  jsedwards
-- Change to 8192 bytes per bit map instead of 256 bytes.
--
-- Revision 1.24.2.45  2006/10/07 22:27:02  jsedwards
-- Changed the generate id function so that it checks to see if we are
-- operating in the sequential mode and it calls the correct function.
--
-- Revision 1.24.2.44  2006/10/06 04:39:24  jsedwards
-- Changed the names of some of the public and private, blocks and id
-- definitions and added new function to generate ids that scan across
-- the disk drive, instead of totally random.
--
-- Revision 1.24.2.43  2006/10/03 12:50:16  jsedwards
-- Changed so that instead of calling a separate routine after initialize to
-- change the already opened storage, you call it now with a type of storage
-- parameter and a path to the storage.  The problem with the other way was
-- if you tried reading a compressed file on another machine it tried to open
-- the default file which didn't exist.
--
-- Revision 1.24.2.42  2006/10/02 14:02:45  jsedwards
-- Changed to just read the file while indexing, instead of doing the seeks.
--
-- Revision 1.24.2.41  2006/10/02 13:29:54  jsedwards
-- Changed to use a binary search for the indexes instead of the linear.
--
-- Revision 1.24.2.40  2006/10/02 12:33:44  jsedwards
-- Split out reference hash into a separate function and initialized next_ptr
-- so that gcc doesn't worry about it possibly being uninitialized.
--
-- Revision 1.24.2.39  2006/10/02 02:15:33  jsedwards
-- Added the capability of reading blocks from a compressed archive file
-- instead of the normal disk drive or partition.
--
-- Revision 1.24.2.38  2006/10/01 11:49:47  jsedwards
-- Increased the number of tries in finding a random id.  Made the code to
-- not access the hard drive for testing purposes ifdef'd so it can be enabled
-- or disabled with a -D option.
--
-- Revision 1.24.2.37  2006/09/29 04:12:39  jsedwards
-- Fixed "object_exists" and "block_used" functions again.  Added if'd out
-- code to write to memory instead of the disk (for testing).
--
-- Revision 1.24.2.36  2006/09/28 13:38:46  jsedwards
-- Re-arranged testing of reference in block to do object exists better.
-- Added printing of offset in lseek error statements.
--
-- Revision 1.24.2.35  2006/09/26 13:22:38  jsedwards
-- Changed to use a disk drive or partition for storage instead of a file.
-- This required hashing the id to fit in the disk or partition size.
--
-- Revision 1.24.2.34  2006/09/24 13:46:14  jsedwards
-- Previous change was a mistake, added a new function that checks to see if
-- the block is used and changed "object_exists" function back to the way it
-- was.
--
-- Revision 1.24.2.33  2006/09/24 13:38:06  jsedwards
-- Add test to "object_exists" function to verify it is not just a zero block.
--
-- Revision 1.24.2.32  2006/09/19 14:10:45  jsedwards
-- Fix bug where next block wasn't zeroed when reference list sidecar filled
-- up exactly.  Added printing of num_blocks in log.
--
-- Revision 1.24.2.31  2006/09/18 02:07:04  jsedwards
-- Add asserts to make sure the reference passed into routines is not void.
--
-- Revision 1.24.2.30  2006/09/18 01:32:52  jsedwards
-- Renamed read_file_and_decrypt and write_file with "nwos" prefix and removed
-- the static so that they can be accessed by other modules (like file.c).
--
-- Revision 1.24.2.29  2006/09/09 13:03:33  jsedwards
-- Moved "create_root_object" routine from security.c to objectify.c so that
-- the security module didn't have references to so many other parts of the
-- system.
--
-- Revision 1.24.2.28  2006/09/08 13:28:41  jsedwards
-- Changed to use a different sequence block for objects beyond the first for
-- objects larger than one block.
--
-- Revision 1.24.2.27  2006/09/08 11:07:34  jsedwards
-- Changed so that random_sequence table is a two dimentional array so we can
-- store different sequence tables for multiple block objects.
--
-- Revision 1.24.2.26  2006/09/08 11:01:23  jsedwards
-- Changed so that the sequence table is passed into "write_object_to_disk"
-- and "read_object_from_disk_and_decrypt" routines.
--
-- Revision 1.24.2.25  2006/09/07 12:59:46  jsedwards
-- Separated the sequence table generation code into a separate function.
--
-- Revision 1.24.2.24  2006/09/06 13:15:25  jsedwards
-- Removed nwos_seed_sequence function and instead pass pointers to the values
-- in the call to next_sequence function.
--
-- Revision 1.24.2.23  2006/09/05 12:59:34  jsedwards
-- Added checksums (crc32) to reference lists.
--
-- Revision 1.24.2.22  2006/09/05 01:26:41  jsedwards
-- Converted add_to_reference_list to use the new block structures.
--
-- Revision 1.24.2.21  2006/09/05 00:29:16  jsedwards
-- Converted the read_reference_list_from_disk routine to use the new block
-- structures.
--
-- Revision 1.24.2.20  2006/09/05 00:07:48  jsedwards
-- Converted the write_reference_list routine to use the new block structures.
--
-- Revision 1.24.2.19  2006/09/04 15:51:14  jsedwards
-- Change read_reference_list_into_cache routine to use new block structures.
--
-- Revision 1.24.2.18  2006/09/04 13:26:06  jsedwards
-- Added reference list block structures (for the blocks written to disk).
-- Changed cache to point to a reference list first block structure instead
-- of a reference list itself.  The code really doesn't use them yet.
--
-- Revision 1.24.2.17  2006/09/04 01:01:24  jsedwards
-- Split up the create_reference_list routine so it is possible to create a
-- reference list with a given id instead of generating a new one.  This is
-- helpful when doing the conversion from the old multiple file style (we
-- can just keep the old reference ids and not have to switch them around).
--
-- Revision 1.24.2.16  2006/09/03 13:56:35  jsedwards
-- Moved defintion of DEFAULT_FILE to objectify_private.h so the big_bang can
-- use it to create the file.
--
-- Revision 1.24.2.15  2006/09/03 13:14:55  jsedwards
-- Rearranged the order of functions in the file and added some comments to
-- mark the different sections.  NO code changes were made.
--
-- Revision 1.24.2.14  2006/09/03 12:20:40  jsedwards
-- Removed a couple more debugging print statements.
--
-- Revision 1.24.2.13  2006/09/03 12:13:57  jsedwards
-- Add code to check that all malloc'd blocks are freed during testing.
--
-- Revision 1.24.2.12  2006/09/03 11:09:14  jsedwards
-- Removed many of the debugging print statements, added a routine to allow
-- an object to be overwritted (instead of having to remove it and then write
-- it again.  Also rearranged the checksum checking code slightly.
--
-- Revision 1.24.2.11  2006/09/03 10:22:14  jsedwards
-- Initialize ivec in nwos_get_object_class function.
--
-- Revision 1.24.2.10  2006/09/02 15:08:16  jsedwards
-- Add reference list class reference to root object because now it has to
-- read the reference list to get it's size and we can't easily read it
-- without the read routine verifying it's class.
--
-- Fixed add reference routine to clean dirty flag before writing block.
--
-- Fixed remove object routine to do the seek before nuking the object.
--
-- Revision 1.24.2.9  2006/09/01 13:20:00  jsedwards
-- Fixed some bugs in new storing objects in one file.  Still NOT working!
--
-- Revision 1.24.2.8  2006/09/01 11:49:59  jsedwards
-- Merged version with file additions and version that writes objects into one
-- large file.  This vesion DOES NOT work correctly.
--
-- Revision 1.24.2.7  2006/08/25 13:06:54  jsedwards
-- Fixed daylight savings to work correctly when computing the end of time.
--
-- Revision 1.24.2.6  2006/08/25 12:43:37  jsedwards
-- Change to compute the end of time value in local time and save it.  This
-- way the time stamps on the file actually read 9/9/99...
--
-- Revision 1.24.2.5  2006/08/25 12:24:00  jsedwards
-- Added code to set the time stamps on all of the objects to 9/9/99 9:09:09.
--
-- Revision 1.24.2.4  2006/08/16 12:47:56  jsedwards
-- Changed the name of the static function "log" to "nwos_log" and added a
-- cast so that new versions of GCC don't complain.
-- doesn't complain about the type of a built in function being redefined
--
-- Revision 1.24.2.3  2006/08/13 16:36:43  jsedwards
-- Made a define for the block size of the file called FILE_BLOCK_SIZE, that
-- is the minimum size of the file for each object.  The amount of disk space
-- used for a one byte file.
--
-- Revision 1.24.2.2  2006/08/13 16:27:14  jsedwards
-- Change to compute the random sequence table only one time and save it.
--
-- Revision 1.24.2.1  2006/08/13 12:53:06  jsedwards
-- Added comments to encrypt and decrypt routines (NO code changes).
--
-- Revision 1.24  2006/01/12 02:57:28  jsedwards
-- Fixed "ask yes or no" routine to actually work.
--
-- Revision 1.23  2006/01/12 02:03:36  jsedwards
-- Added code to dump the object when the data checksum fails.
--
-- Revision 1.22  2006/01/08 15:27:28  jsedwards
-- Removed unused variable.
--
-- Revision 1.21  2006/01/03 03:21:38  jsedwards
-- Added "is compatible version" routine to determine if a particular version
-- of an object is still compatible with the current version.
--
-- Revision 1.20  2006/01/01 19:47:33  jsedwards
-- Added "is quit command" and "ask yes or no" routines.
--
-- Revision 1.19  2005/12/30 14:09:50  jsedwards
-- Commented out printing of blowfish key, was for debugging.
--
-- Revision 1.18  2005/12/29 19:08:00  jsedwards
-- Fixed some of the ifdef DISABLE_SECURITY_FEATURES that were accidentally
-- entered as #if DISABLE_SECURITY_FEATURES instead.  Also added a disable
-- security features to the unique id routine to make sure it finds a unique
-- one by incrementing (since we can punch the random number generator all
-- we want and it isn't going to fix that problem).
--
-- Revision 1.17  2005/12/29 18:30:42  jsedwards
-- Added ifdefs to disable/enable the security features.
--
-- Revision 1.16  2005/12/29 18:20:24  jsedwards
-- Split up routines, added read variable length objects and other changes to
-- make encryption work, HOWEVER, ENCRYPTION IS DISABLED IN THIS VERSION.
--
-- Revision 1.15  2005/12/28 12:53:06  jsedwards
-- First attempt at adding security.  Objects are encrypted before being
-- written to disk and decrypted when read from disk.  It is incomplete at
-- this point and doesn't work completely, for example, the read object
-- headers function won't work.  This version should only be used for testing.
--
-- Revision 1.14  2005/12/27 19:44:40  jsedwards
-- Added routine to set the root object.
--
-- Revision 1.13  2005/12/27 18:14:08  jsedwards
-- Changed ObjRefs to be 4 bytes instead of 8 bytes and made them random
-- instead of somehow based upon the contents.
--
-- Revision 1.12  2005/12/24 16:18:26  jsedwards
-- Removed "host" id from object references (ObjRef).  Host redirection will
-- be done using a "redirection" object in the future.
--
-- Revision 1.11  2005/12/21 23:25:57  jsedwards
-- Added better error messages when the size of an object doesn't match the
-- number of bytes read.
--
-- Revision 1.10  2005/12/11 16:52:56  jsedwards
-- Added a log message when an object is added to a reference list and fixed
-- the error messages printed when adding to a reference list fails.
--
-- Revision 1.9  2005/12/10 15:03:36  jsedwards
-- Fixed header to say the GPL is in the LICENSE file instead of COPYING.
--
-- Revision 1.8  2005/12/05 19:03:06  jsedwards
-- Moved local read_object_from_disk (not nwos_read_object_from_disk) function
-- earlier in the file so that get_object_class function can call it instead
-- of nwos_read_object_from_disk which wasn't happy about it just reading the
-- common header.
--
-- Revision 1.7  2005/12/05 05:18:53  jsedwards
-- Ifdefd out logging each time a file is read, too much spam into log file.
--
-- Revision 1.6  2005/12/05 05:16:22  jsedwards
-- Made a separate routine 'read_reference_list_from_disk' to read reference
-- lists, that doesn't do checksums.  Changed 'read_object_from_disk' to
-- check both the header and data checksums.  Also added a log routine to
-- log each time a file is written to and read from disk.
--
-- Revision 1.5  2005/12/03 22:15:38  jsedwards
-- Added get_object_class and add_to_references functions.
--
-- Revision 1.4  2005/12/02 20:30:11  jsedwards
-- Changed so that reference list id is generated from the object that the
-- reference list is for's id.
--
-- Revision 1.3  2005/11/30 13:53:31  jsedwards
-- Added routines to get object size and read class definition.  Also added
-- 'nwos' prefix to generate_new_id routine and made it global.
--
-- Revision 1.2  2005/11/26 15:36:59  jsedwards
-- Added 'nwos' prefix to functions and added 'static' to local functions.
--
-- Revision 1.1.1.1  2005/11/25 12:44:27  jsedwards
-- Copied from 'lab'.
--
-- Revision 1.5  2005/11/24 15:47:47  jsedwards
-- Changed to match new object header layouts.
--
-- Revision 1.4  2005/11/22 13:57:04  jsedwards
-- Made a common subroutine to fill in the common header.
--
-- Revision 1.3  2005/11/22 13:09:58  jsedwards
-- Added read object from disk and create simple object routines.
--
-- Revision 1.2  2005/11/12 23:02:58  jsedwards
-- Rearranged headers.
--
-- Revision 1.1  2005/11/12 14:55:12  jsedwards
-- Routines for creating objects.
--
*/


#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "bit_map.h"
#include "chunk_info.h"                /* define nwos_hash_ref */
#include "class_definition.h"
#include "crc32.h"
#include "disk_io.h"                   /* define nwos_archive_is_file and nwos_write_empty_chunk */
#include "header.h"
#include "objectify.h"
#include "security.h"
#include "storage.h"
#include "time_stamp.h"


#define MAX_ROOT_TRANSFORMATIONS 128      // the number of different possible root objects for a given id


/* Global variables... BAD!... need to fix */

bool verbose = false;
bool nwos_ready = false;



bool nwos_is_ready(void)
{
    return nwos_ready;
}

bool nwos_is_writable(void)
{
    return nwos_storage_is_read_write();
}


/***********************************/
/* Variable Length Count functions */
/***********************************/

uint32 nwos_decode_variable_sized_count(uint8 count[4])
{
    uint32 result;

    result = count[0];   /* get the first byte */

    if (result > 127)   /* two bytes */
    {
	assert((result & 0xc0) == 0x80);  /* for now upper two bits must be 10 */

	result = (((result & 0x3f) << 8) | count[1]) + 128;
    }
    else
    {
	/* this byte should always be zero if first bytes is < 128.  the original */
	/* plan was to not store the extra bytes, but the compiler did it anyway */
	assert(count[1] == 0);
    }

    return result;
}

void nwos_encode_variable_sized_count(uint32 count, uint8 result[4])
{
    int adjusted;

    assert(count < (16384 + 128));   /* for now we can only handle two bytes */

    if (count > 127)   /* two bytes */
    {
	adjusted  = count - 128;
	result[0] = (0x80 | (adjusted >> 8));
	result[1] = adjusted & 0xff;
    }
    else
    {
	result[0] = count;
	result[1] = 0;
    }

    result[2] = 0;
    result[3] = 0;

    assert(nwos_decode_variable_sized_count(result) == count);
}



/*********************************/
/* Root object ID transformation */
/*********************************/

static bool is_binary_number(uint n)
{
    uint u;

    for (u = 1; u != 0; u <<= 1)
    {
	if (u == n) return true;
    }

    return false;
}


static void nwos_transform_root(ObjRef* dst_ref, ObjRef* src_ref, int num)
{
    int shift_count;

    assert(16 <= MAX_ROOT_TRANSFORMATIONS && MAX_ROOT_TRANSFORMATIONS < 256 && is_binary_number(MAX_ROOT_TRANSFORMATIONS));
    assert(0 <= num && num < MAX_ROOT_TRANSFORMATIONS);

    shift_count = 1;
    while ((MAX_ROOT_TRANSFORMATIONS << shift_count) != 256) shift_count++;

    copy_reference(dst_ref, src_ref);

    dst_ref->id[0] = src_ref->id[0] + (num << shift_count);
}


/**********************************/
/* Initialization and Termination */
/**********************************/

void nwos_initialize_objectify(AccessType type, const char* path)
{
    ObjRef root_object_ref;

#ifdef PUBLIC_MODE
    assert(type == PUBLIC);
#else
    int i;
    int attempt;  /* number of pass phrase attempts */
    uint8 big_key[16 + 8 + 4];
    ObjRef test_object_ref;
    char* incorrect_messages[] = { "Incorrect, try again.", "Wrong again, one more try.", "Sorry, no go." };

#define NUM_ATTEMPTS (sizeof(incorrect_messages) / sizeof (char*))

#endif

    nwos_log("nwos_initialize_objectify():");

    nwos_crc32_initialize();
    nwos_initialize_storage(type, path);

    if (type == PUBLIC)
    {
	root_object_ref.id[0] = 0;
	root_object_ref.id[1] = 0;
	root_object_ref.id[2] = 0;
	root_object_ref.id[3] = 1;

	assert(nwos_set_root_object(&root_object_ref));
    }
#ifndef PUBLIC_MODE
    else
    {
	for (attempt = 0; attempt < NUM_ATTEMPTS; attempt++)
	{
	    nwos_get_key_from_password(big_key, sizeof(big_key));

	    nwos_setup_from_big_key(big_key, &root_object_ref);

	    for (i = 0; i < MAX_ROOT_TRANSFORMATIONS; i++)
	    {
		nwos_transform_root(&test_object_ref, &root_object_ref, i);

		if (nwos_is_private_reference(&test_object_ref) && nwos_set_root_object(&test_object_ref)) break;  /* we have a winner! */
	    }

	    if (i < MAX_ROOT_TRANSFORMATIONS) break;
	    
	    fprintf(stderr, "%s\n", incorrect_messages[attempt]);
	}

	if (attempt == NUM_ATTEMPTS)
	{
	    nwos_terminate_storage();
	    fprintf(stderr, "\n");
	    exit(1);
	}
    }
#endif
}


/* this is the same as the normal routine in objectify.c except it doesn't translate the reference for the disk */
static void set_public_root_object(ObjRef* ref)
{
    C_struct_Root root_obj;
    ObjRef verify_ref;

    assert(nwos_read_object_from_disk(ref, &root_obj, sizeof(root_obj)));
    copy_reference(&nwos_public_class_definition_class_ref, &root_obj.class_definition_class);
    copy_reference(&nwos_reference_list_class_ref, &root_obj.reference_list_class);

    assert(nwos_find_public_class_definition("REFERENCE LIST", &verify_ref));
    assert(is_same_object(&verify_ref, &nwos_reference_list_class_ref));
}

    
#ifndef PUBLIC_MODE
void nwos_create_root(void)
{
    uint8 big_key_1[16 + 8 + 4];
    uint8 big_key_2[16 + 8 + 4];
    uint32 hash;
    ObjRef public_root_obj_ref;
    ObjRef private_root_obj_ref;
    ObjRef public_root_class_ref;
    ObjRef test_object_ref;
    C_struct_Root root_obj;
    ObjRef root_class_ref;
    int i;
    int random_transform;


    nwos_log("nwos_create_root():");

    nwos_crc32_initialize();
    nwos_initialize_storage(READ_WRITE, DEFAULT_FILE);

    assert(nwos_archive_is_file() || nwos_total_private_chunks > nwos_used_private_chunks);

    public_root_obj_ref.id[0] = 0;
    public_root_obj_ref.id[1] = 0;
    public_root_obj_ref.id[2] = 0;
    public_root_obj_ref.id[3] = 1;

    set_public_root_object(&public_root_obj_ref);

    assert(nwos_find_public_class_definition("ROOT", &public_root_class_ref));


    while (true)
    {
	assert(sizeof(big_key_1) == sizeof(big_key_2));

	nwos_get_key_from_password(big_key_1, sizeof(big_key_1));

	nwos_setup_from_big_key(big_key_1, &test_object_ref);

	random_transform = random() % MAX_ROOT_TRANSFORMATIONS;

	for (i = 0; i < MAX_ROOT_TRANSFORMATIONS; i++)
	{
	    nwos_transform_root(&private_root_obj_ref, &test_object_ref, random_transform);

	    if (nwos_is_private_reference(&private_root_obj_ref))
	    {
		hash = nwos_hash_ref(&private_root_obj_ref);

		if (hash == 0 || !nwos_test_bit_in_map(hash)) break;   /* we have a winner! */
	    }

	    random_transform = (random_transform + 1) % MAX_ROOT_TRANSFORMATIONS;
	}

	if (i < MAX_ROOT_TRANSFORMATIONS)   /* found a good location */
	{
	    nwos_get_key_from_password(big_key_2, sizeof(big_key_2));

	    if (memcmp(big_key_1, big_key_2, sizeof(big_key_1)) == 0) break;

	    fprintf(stderr, "\nKeys don't match, try again\n\n");
	}
	else
	{
	    fprintf(stderr, "\nThat pass phrase cannot be used, try a different one.\n\n");
	}
    }

    /* create the private root object */

    if (nwos_archive_is_file())
    {
	nwos_write_empty_chunk(nwos_total_private_chunks);
    }

    nwos_allocate_new_chunk(nwos_ref_to_word(&private_root_obj_ref));

    nwos_check_blocks_available(3);

    hash = nwos_hash_ref(&private_root_obj_ref);

    assert(hash != 0 && !nwos_test_bit_in_map(hash));    /* make sure chunk is allocated, but block is not already used */

    nwos_set_bit_in_map(hash);

#ifdef CHANGE_SECURITY_TO_DENSITY
    nwos_set_security_level(Security_Extreme);
#endif

    nwos_clone_class_definition(&nwos_public_class_definition_class_ref, &nwos_private_class_definition_class_ref);


    /* currently I can't think of any reason to have a private root class, since there is no list of root objects */
    assert(nwos_find_public_class_definition("ROOT", &root_class_ref));

    memset(&root_obj, 0, sizeof(root_obj));  /* zero it out */

    nwos_fill_in_common_header(&root_obj.header.common, &private_root_obj_ref, &root_class_ref);

    memcpy(&root_obj.class_definition_class, &nwos_private_class_definition_class_ref, sizeof(root_obj.class_definition_class));

    memcpy(&root_obj.reference_list_class, &nwos_reference_list_class_ref, sizeof(root_obj.reference_list_class));

    nwos_crc32_calculate((uint8*) &root_obj.header.object, sizeof(ObjectHeader), root_obj.header.common.header_chksum);

    nwos_crc32_calculate((uint8*) &root_obj.class_definition_class, sizeof(root_obj) - sizeof(EveryObject), root_obj.header.common.data_chksum);

    nwos_write_object_to_disk(&private_root_obj_ref, &root_obj, sizeof(root_obj));

    nwos_terminate_objectify();
}
#endif


bool nwos_set_root_object(ObjRef* ref)
{
    C_struct_Root root_obj;
    ObjRef verify_ref;
    C_struct_Class_Definition class_def;

    assert(!nwos_ready);

    if (nwos_read_object_from_disk(ref, &root_obj, sizeof(root_obj)))
    {
	if (nwos_reference_type(ref) == Public_Reference)
	{
	    assert(nwos_storage_is_public_only());   /* only allow if no private objects are in play */

	    copy_reference(&nwos_public_class_definition_class_ref, &root_obj.class_definition_class);
	}
	else
	{
	    assert(!nwos_storage_is_public_only());   /* only allow if private objects are in play */

	    copy_reference(&nwos_private_class_definition_class_ref, &root_obj.class_definition_class);

	    nwos_read_class_definition(&nwos_private_class_definition_class_ref, &class_def);

	    copy_reference(&nwos_public_class_definition_class_ref, &class_def.header.object.clone_of);
	}

	copy_reference(&nwos_reference_list_class_ref, &root_obj.reference_list_class);

	assert(nwos_find_public_class_definition("REFERENCE LIST", &verify_ref));
	assert(is_same_object(&verify_ref, &nwos_reference_list_class_ref));

	nwos_ready = true;
    }

    return nwos_ready;
}


void nwos_flush_to_disk()
{
    nwos_flush_dirty_ref_lists();  /* flush any reference lists that are dirty out to disk */
    nwos_flush_storage();
}


void nwos_terminate_objectify()
{
    nwos_log("nwos_terminate_objectify():");

    nwos_ready = false;

    nwos_flush_dirty_ref_lists();  /* flush any reference lists that are dirty out to disk */

    nwos_terminate_storage();

#ifdef CHECK_MEMORY_LEAKS
    for (i = 0; i < MAX_MEM_ADDR_SAVED; i++)
    {
	if (save_malloc_addr[i] != NULL) printf("WARNING - memory block not freed: %p\n", save_malloc_addr[i]);
    }
#endif
}


bool nwos_in_public_mode()
{
    return is_void_reference(&nwos_private_class_definition_class_ref);
}


const char* nwos_archive_version()
{
    return nwos_version_string;
}


bool nwos_is_quit_command(char* command)
{
    if (strcasecmp(command, "quit") == 0) return true;
    if (strcasecmp(command, "quit now") == 0) return true;
    if (strcasecmp(command, "exit") == 0) return true;
    if (strcasecmp(command, "stop") == 0) return true;
    if (strcasecmp(command, "stop now") == 0) return true;
    if (strcasecmp(command, "done") == 0) return true;
    if (strcasecmp(command, "done now") == 0) return true;
    if (strcasecmp(command, "finish") == 0) return true;
    if (strcasecmp(command, "finish now") == 0) return true;
    if (strcasecmp(command, "finished") == 0) return true;
    if (strcasecmp(command, "terminate") == 0) return true;

    return false;
}


