/*
--             This file is part of the New World OS project
--                    Copyright (C) 2008  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: progress_bar.c,v $
-- Revision 1.2  2008/07/19 11:51:12  jsedwards
-- Fixed asserts so that calling with progress bar at 100 is okay.
--
-- Revision 1.1  2008/07/19 11:24:27  jsedwards
-- Moved progress bar functions from prep_disk.c and renamed with nwos_ prefix.
--
-- Revision 1.50  2008/01/17 15:07:22  jsedwards
-- Moved progress bar code into prep_disk.c from disk_io.c and made into
-- functions.  Added a function pointer parameter to the allocate_all_hack
-- function which is called with progress.
*/

#include <assert.h>
#include <stdio.h>

#include "types.h"


/***************************************/
/*  Functions to print a progress bar  */
/***************************************/

static uint progress_bar_percent;

void nwos_start_progress_bar()
{
    progress_bar_percent = 0;

    printf("Percent complete: ");
    fflush(stdout);
}


void nwos_update_progress_bar(float percent)  /* 0.0 <= percent < 1.0 */
{
    assert(progress_bar_percent <= 100);

    while (percent >= (float)progress_bar_percent / 100)
    {
	if (progress_bar_percent % 10 == 0)
	{
	    printf("%d", progress_bar_percent);
	}
	else
	{
	    printf(".");
	}
	fflush(stdout);

	progress_bar_percent += 2;
    }
}


void nwos_finish_progress_bar()
{
    assert(progress_bar_percent <= 100);

    while (progress_bar_percent <= 100)
    {
	if (progress_bar_percent % 10 == 0)
	{
	    printf("%d", progress_bar_percent);
	}
	else
	{
	    printf(".");
	}

	progress_bar_percent += 2;
    }

    printf("\n");
}


