--
--             This file is part of the New World OS project
--                    Copyright (C) 2008  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: reference_list.e,v $
-- Revision 1.1  2008/11/28 17:11:56  jsedwards
-- Initial experimental quick hack.
--
--


class REFERENCE_LIST

creation make

feature

   make(ref: REFERENCE) is
      do
         storage := nwos_malloc_reference_list(ref.to_external)
      end

   count: INTEGER is
      do
         Result := wrapper_ref_list_count(storage)
      end

   lower: INTEGER is 0

   upper: INTEGER is
      do
         Result := count - 1
      end

   item(index: INTEGER): REFERENCE is
      require
         lower <= index and then index <= upper
      do
         !!Result.make
         wrapper_ref_list_item(storage, index, Result.to_external)
      end

   storage: POINTER

   nwos_malloc_reference_list(ref: POINTER): POINTER is
      external "C"
      end

   wrapper_ref_list_count(pointer: POINTER): INTEGER is
      external "C"
      end

   wrapper_ref_list_item(pointer: POINTER; index: INTEGER; ref: POINTER) is
      external "C"
      end


end

