/*
--         This file is part of the New World OS and Objectify projects
--                    Copyright (C) 2007-2009  QRW Software
--              J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                         http://www.qrwsoftware.com
--                         http://nwos.sourceforge.com
--                      http://objectify.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: backup.h,v $
-- Revision 1.1  2009/03/14 22:40:04  jsedwards
-- Create with declarations moved from disk_io.h file.
--
*/

#ifndef BACKUP_H
#define BACKUP_H

#include "disk_io.h"   /* define Disk_Header */
#include "types.h"

extern bool  nwos_initialize_backup(const char* path, Disk_Header* disk_header);
extern void  nwos_terminate_backup(bool modified, Disk_Header* disk_header);
extern void  nwos_backup_write_block(uint8 block[FILE_BLOCK_SIZE]);

#endif
