# 
#              This file is part of the New World OS project
#                     Copyright (C) 2009 QRW Software
#            J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
#                       http://www.qrwsoftware.com
#                       http://nwos.sourceforge.com
# 
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program, in the file LICENSE.  If not, see 
#    <http://www.gnu.org/licenses/>.
# 
#    You can also contact me via paper mail at:
# 
#       QRW Software
#       P.O. Box 27511
#       Salt Lake City, UT 84127-0511, USA.
# 
# 
#  This script runs a quick test of file importing and exporting.
# 
#  $Log: test_import_levels.sh,v $
#  Revision 1.2  2009/03/07 13:30:40  jsedwards
#  Added imports of two files that I missed before.
#
#  Revision 1.1  2009/03/06 15:27:34  jsedwards
#  Initial version.
#


export OBJECTIFY_TEST_ONLY_DO_NOT_USE="Import Sizes Test"
export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private.obj
export OBJECTIFY_LOG_FILE_PATH=/tmp/objectify_test/objectify_log
export OBJECTIFY_BACKUP_PATH=

EXEC=$PWD

if ! rm -fr /tmp/objectify_test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi

if ! rm -fr /tmp/test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi

mkdir /tmp/test
cd /tmp/test

echo "----------------------"
echo " creating test files"
echo "----------------------"

#dd if=/dev/random of=x7 bs=7 count=1

echo "WARNING: NOT using random data!!!!!"
echo -n "1234567" > x7

cat          x7          x7 >        x14
cat         x14         x14 >        x28
cat         x28         x28 >        x56
cat         x56         x56 >       x112
cat        x112        x112 >       x224
cat        x224        x224 >       x448
cat        x448        x448 >       x896
cat        x896        x896 >      x1792
cat       x1792       x1792 >      x3584
cat       x3584       x3584 >      x7168
cat       x7168       x7168 >     x14336
cat      x14336      x14336 >     x28672
cat      x28672      x28672 >     x57344
cat      x57344      x57344 >    x114688
cat     x114688     x114688 >    x229376
cat     x229376     x229376 >    x458752
cat     x458752     x458752 >    x917504
cat     x917504     x917504 >   x1835008
cat    x1835008    x1835008 >   x3670016
cat    x3670016    x3670016 >   x7340032


echo "---------------"
echo " prep disk..."
echo "---------------"
if ! $EXEC/prep_disk; then
   echo ""
   echo "prep_disk failed"
   echo ""
   exit 1
fi

echo "---------------"
echo " import_files..."
echo "---------------"
if ! $EXEC/import_file --extreme-security x14 x917504 x112; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

echo "---------------"
echo " import_files..."
echo "---------------"
if ! $EXEC/import_file --minimal-security x7*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

echo "---------------"
echo " import_files..."
echo "---------------"
if ! $EXEC/import_file --low-security x114688; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

echo "---------------"
echo " import_files..."
echo "---------------"
if ! $EXEC/import_file --medium-security x4*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

echo "---------------"
echo " import_files..."
echo "---------------"
if ! $EXEC/import_file --very-low-security x3*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

echo "---------------"
echo " import_files..."
echo "---------------"
if ! $EXEC/import_file --high-security x2*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi


echo "---------------"
echo " import_files..."
echo "---------------"
if ! $EXEC/import_file --extreme-security x1792 x14336; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

echo "---------------"
echo " import_files..."
echo "---------------"
if ! $EXEC/import_file --low-security x5*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

echo "---------------"
echo " import_files..."
echo "---------------"
if ! $EXEC/import_file --high-security x896; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi


echo "---------------"
echo " import_files..."
echo "---------------"
if ! $EXEC/import_file --minimal-security x1835008; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

echo "-----------------"
echo " export_files..."
echo "-----------------"

mkdir test
cd test

if ! $EXEC/export_file "*"; then
   echo ""
   echo "export_file failed"
   echo ""
   exit 1
fi

for file in ../x*; do diff -s $file .; done
sleep 2

echo "---------------------"
echo " verify and remove..."
echo "---------------------"
if ! $EXEC/verify_file --remove-no-shred *; then
   echo ""
   echo "verify_file --remove-no-shred succeeded"
   echo ""
   exit 1
fi


echo "---------------------"
echo " compress..."
echo "---------------------"
if ! $EXEC/compress_sparse ../compressed; then
   echo ""
   echo "compress_sparse failed"
   echo ""
   exit 1
fi


echo "--------------------------"
echo " prep disk for restore..."
echo "--------------------------"
if ! $EXEC/prep_disk --no-private; then
   echo ""
   echo "prep_disk --no-private failed"
   echo ""
   exit 1
fi


echo "---------------------"
echo " expand..."
echo "---------------------"
if ! $EXEC/expand_sparse ../compressed; then
   echo ""
   echo "expand_sparse failed"
   echo ""
   exit 1
fi



if ! $EXEC/export_file "*"; then
   echo ""
   echo "export_file failed"
   echo ""
   exit 1
fi

for file in ../*.[ch]; do diff -s $file .; done


echo "---------------------"
echo " verify and remove..."
echo "---------------------"
if ! $EXEC/verify_file --remove-no-shred *; then
   echo ""
   echo "verify_file --remove-no-shred failed"
   echo ""
   exit 1
fi

echo ""
echo "All tests passed!"
echo ""

exit 0

