--
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: nwos_classes.e,v $
-- Revision 1.2  2007/07/01 19:44:13  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.1  2007/04/14 02:24:12  jsedwards
-- Move Fine (Eiffel) files to next_gen directory.
--
-- Revision 1.4  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.3  2006/02/25 04:44:36  jsedwards
-- Changed to cheezy approximation thing to use it's position in my dictionary.
--
-- Revision 1.2  2006/02/25 01:27:40  jsedwards
-- Added more classes and a cheezy way of creating the id.
--
-- Revision 1.1  2006/02/22 14:14:40  jsedwards
-- Incomplete version, extracted from nwos_predefined_references.e.
--

class NWOS_CLASSES  -- a list of all class defintions

feature

   Total_pages: FLOAT is 1459.4

   approximate(page: FLOAT): UNSIGNED is
         -- cheezy way of creating a class ID from approximately where the word falls in the dictionary 
      do
         Result := 0xC0000000 + ((page / Total_pages) * 268435456.0).rounded.to_unsigned
      end


   Class_class_definition_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, 0xC0000000)
      end

   Class_uint8_ref: NWOS_REFERENCE is  
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, 0xC0000001)
      end

   Class_string_ref: NWOS_REFERENCE is  
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, 0xC0000002)   -- built in type string
      end

   Class_abbreviation_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(2.4))
      end

   Class_acronym_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(12.1))
      end

   Class_address_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(14.95))
      end

   Class_adjective_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(16.24))
      end

   Class_adverb_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(19.06))
      end

   Class_alphabet_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(35.25))
      end

   Class_apartment_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(57.4))
      end

   Class_application_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(60.8))
      end

   Class_area_code_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(65.9))
      end

   Class_ascii_character_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(73.9))
      end

   Class_automobile_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(84.24))
      end

   Class_binary_code_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(122.5))
      end

   Class_brother_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(158.15))
      end

   Class_cd_drive_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(198.1))
      end

   Class_cd_r_drive_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(198.11))
      end

   Class_cd_rw_drive_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(198.12))
      end

   Class_character_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(207.6))
      end

   Class_city_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(226.48))
      end

   Class_compact_disc_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(252.42))
      end

   Class_computer_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(256.53))
      end

   Class_conjunction_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(263.76))
      end

   Class_consonant_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(266.8))
      end

   Class_country_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(286.42))
      end

   Class_county_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(286.52))
      end

   Class_date_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(317.05))
      end

   Class_daughter_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(317.38))
      end

   Class_day_of_month_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(317.61))
      end

   Class_day_of_week_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(317.62))
      end

   Class_day_of_year_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(317.63))
      end

   Class_declarative_sentence_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(323.02))
      end

   Class_digital_video_disc_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(349.76))
      end

   Class_dvd_drive_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(389.11))
      end

   Class_dvd_rw_drive_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(389.12))
      end

   Class_elapsed_time_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(399.9))
      end

   Class_exclamatory_sentence_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(436.01))
      end

   Class_father_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(456.45))
      end

   Class_first_name_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(472.44))
      end

   Class_gender_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(520.4))
      end

   Class_home_phone_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(595.02))
      end

   Class_hour_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(602.4))
      end

   Class_house_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(602.6))
      end

   Class_imperative_sentence_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(623.53))
      end

   Class_integer_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(650.3))
      end

   Class_interjection_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(653.2))
      end

   Class_interrogative_sentence_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(655.16))
      end

   Class_language_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(699.8))
      end

   Class_last_name_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(702.4))
      end

   Class_letter_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(713.95))
      end

   Class_lower_case_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(738.26))
      end

   Class_middle_name_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(786.6))
      end

   Class_minute_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(792.49))
      end

   Class_mobile_phone_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(797.45))
      end

   Class_month_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(806.04))
      end

   Class_mother_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(810.25))
      end

   Class_motherboard_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(810.36))
      end

   Class_network_interface_card_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(833.16))
      end

   Class_noun_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(849.02))
      end

   Class_number_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(851.37))
      end

   Class_object_grade_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(855.13))
      end

   Class_operating_system_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(869.75))
      end

   Class_person_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(924.48))
      end

   Class_phone_number_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(931.3))
      end

   Class_phrase_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(934.41))
      end

   Class_postal_code_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(969.07))
      end

   Class_preposition_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(981.2))
      end

   Class_procurement_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(990.82))
      end

   Class_pronoun_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(995.1))
      end

   Class_proper_noun_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(996.42))
      end

   Class_punctuation_mark_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1009.2))
      end

   Class_residence_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1060.1))
      end

   Class_root_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1082.4))
      end

   Class_second_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1121.5))
      end

   Class_sentence_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1134.25))
      end

   Class_session_log_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1138.6))
      end

   Class_sister_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1165.16))
      end

   Class_sometimes_vowel_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1189.07))
      end

   Class_son_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1189.4))
      end

   Class_source_file_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1193.22))
      end

   Class_spelling_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1199.93))
      end

   Class_spelling_index_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1199.95))
      end

   Class_statement_of_account_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1219.23))
      end

   Class_street_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1234.5))
      end

   Class_thing_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1299.2))
      end

   Class_time_of_day_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1309.76))
      end

   Class_upper_case_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1375.1))
      end

   Class_us_state_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1378.36))
      end

   Class_user_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1378.72))
      end

   Class_verb_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1389.12))
      end

   Class_video_card_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1394.52))
      end

   Class_video_monitor_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1394.63))
      end

   Class_vowel_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1403.67))
      end

   Class_word_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1442.3))
      end

   Class_work_phone_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1443.98))
      end

   Class_year_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1451.6))
      end

   Class_zip_code_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, approximate(1457.4))
      end

end

