--
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: print_spellings.e,v $
-- Revision 1.2  2007/07/01 19:44:14  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.1  2007/06/03 12:40:56  jsedwards
-- Moved from root directory.
--
-- Revision 1.9  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.8  2006/02/20 05:08:17  jsedwards
-- Uncommented getting English language object and printing it's name.
-- Changed to use the new get codes features of letter.
--
-- Revision 1.7  2006/02/19 18:48:49  jsedwards
-- Removed load calls on root object and alphabet, they are no longer required
-- because the objects will "load on demand".
--
-- Revision 1.6  2006/02/18 15:40:14  jsedwards
-- Changed so name and revision in class definition are strings instead of
-- NWOS_STRINGs.
--
-- Revision 1.5  2006/02/17 14:10:06  jsedwards
-- Changed to deal with letters being a symbol (more generic) class.
--
-- Revision 1.4  2006/02/11 22:19:47  jsedwards
-- Added a print separator line before each letter and commented out some
-- other debugging sentences.
--
-- Revision 1.3  2006/02/11 21:13:06  jsedwards
-- Implemented "print_spellings" routine to traverse the spelling indexes
-- and print the spellings it finds along the way.
--
-- Revision 1.2  2006/02/11 18:50:42  jsedwards
-- Added a loop to search for the Alphabet object and got the letters loop
-- printing out the letters.
--
-- Revision 1.1  2006/02/11 12:52:36  jsedwards
-- This is for testing purposes only!!  This version does NOT function!
--


class PRINT_SPELLINGS

inherit NWOS_PREDEFINED_REFERENCES

creation make

feature

   make is
      local
         alphabet_obj: NWOS_ALPHABET
         letter_obj: NWOS_LETTER
         i: INTEGER
         root_obj: NWOS_ROOT
         language_obj: NWOS_LANGUAGE
--         language_class_obj: NWOS_CLASS_DEFINITION
         class_def_obj: NWOS_CLASS_DEFINITION
      do
         root_obj ?= Root_ref.get_object(Class_root_ref)

         if root_obj = Void then  -- something went wrong
            std_output.put_string("Failed, root_obj is void%N")
         else
            std_output.put_string("Success, root_obj is not void%N")
         end

         from
            i := root_obj.class_definition_object.references.lower
         until
            alphabet_obj /= Void
               or else
            i > root_obj.class_definition_object.references.upper
         loop
            class_def_obj ?= root_obj.class_definition_object.references.item(i)

            if class_def_obj /= Void then  -- we have a class definition
               if class_def_obj.name.is_equal("NWOS_ALPHABET") then
                  std_output.put_string("Found alphabet class%N")
                  alphabet_obj ?= class_def_obj.references.item(1)  -- cheating, we shouldn't assume the first object
                  if alphabet_obj = Void then
                     std_error.put_string("alphabet_obj is void%N")
                     die_with_code(exit_failure_code)
                  end
               end
            end

            i := i + 1
         end

         language_obj ?= English_language_ref.get_object(Class_language_ref)

         if language_obj = Void then  -- something went wrong
            std_output.put_string("Failed, language_obj is void%N")
         else
            std_output.put_string("Success, language_obj is not void: ")
            std_output.put_string(language_obj.names.item(1).to_string(Class_ascii_character_ref))
            std_output.put_new_line
         end

         from
            i := alphabet_obj.letters.lower
         until
            i > alphabet_obj.letters.upper
         loop
            letter_obj ?= alphabet_obj.letters.item(i)

            check
               letter_obj /= Void
            end

            std_output.put_string("*****************%N")
            std_output.put_string("Letter: ")
            std_output.put_character(letter_obj.to_upper_case_codes(Class_ascii_character_ref).first)
            std_output.put_character('-')
            std_output.put_character(letter_obj.to_lower_case_codes(Class_ascii_character_ref).first)
            std_output.put_new_line

            print_spellings(letter_obj.spelling_index)

            -- need to do a recursive call thing to traverse all spelling indexes

            i := i + 1
         end
      end

   print_spellings(index: NWOS_SPELLING_INDEX) is
      local
         i: INTEGER
         spelling: NWOS_SPELLING
         letter_obj: NWOS_LETTER
      do
--std_output.put_string("spelling index: ")
--std_output.put_string(index.identifier.to_string)
--std_output.put_new_line

         if index.spelling /= Void then
            spelling := index.spelling
--std_output.put_string("spelling:  ")
--std_output.put_string(spelling.identifier.to_string)
--std_output.put_new_line
            from
               i := spelling.lower
--std_output.put_string("letters.count:  ")
--std_output.put_integer(spelling.letters.count)
--std_output.put_new_line
               letter_obj ?= spelling.item(i)
               check
                  letter_obj /= Void
               end
               std_output.put_character(letter_obj.to_upper_case_codes(Class_ascii_character_ref).first)
               i := i + 1
            until
               i > spelling.upper
            loop
               letter_obj ?= spelling.item(i)
               check
                  letter_obj /= Void
               end
               std_output.put_character(letter_obj.to_lower_case_codes(Class_ascii_character_ref).first)
               i := i + 1
            end
            std_output.put_new_line
         end

         from
            i := index.next_index.lower
         until
            i > index.next_index.upper
         loop
--std_output.put_string("next index ")
--std_output.put_integer(i)
--std_output.put_string(": ")
--std_output.put_boolean(index.next_index.item(i) /= Void)
--std_output.put_new_line
            if index.item(index.alphabet.item(i)) /= Void then
--std_output.put_string("found another index: ")
--std_output.put_string(index.next_index.item(i).identifier.to_string)
--std_output.put_new_line
               print_spellings(index.next_index.item(i))
            end
            i := i + 1
         end
      end

end


