/*
--             This file is part of the New World OS project
--                   Copyright (C) 2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: remove_file.c,v $
-- Revision 1.5  2007/09/16 15:52:55  jsedwards
-- Added warning and confirmation before removing file.
--
-- Revision 1.4  2007/09/16 15:15:57  jsedwards
-- Remove warning comment which is no longer pertinent and with functions and
-- variables that weren't used.
--
-- Revision 1.3  2007/09/15 21:16:15  jsedwards
-- Put SHA1 code back the way it was in the previous version (it was correct
-- in the first place) and added code to remove a SHA256 sum if it exists.
--
-- Revision 1.2  2007/09/15 21:00:17  jsedwards
-- Changed to handle the case where an old file doesn't have a SHA1 checksum.
--
-- Revision 1.1  2007/07/27 15:15:29  jsedwards
-- Initial version NOT fully functional.
--
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "objectify_private.h"


static size_t get_path_object_size(void* file_path_obj)
{
    assert(((C_struct_File_Path*)file_path_obj)->count > 0);

    return sizeof(C_struct_File_Path) + ((C_struct_File_Path*)file_path_obj)->count;
}


int main(int argc, char* argv[])
{
    ObjRef root_object_ref;
    uint8 big_key[16 + 8 + 4];
    uint8 bf_key[16];
    uint32 linear;
    uint32 serial;
    C_struct_Class_Definition class_def_obj;
    C_struct_Path_And_File_Association assoc_obj;
    C_struct_File file_obj;
    uint8 kludge[FILE_BLOCK_SIZE];
    C_struct_File_Path* ptr_path_obj = (C_struct_File_Path*)kludge;
    C_struct_MD5sum md5_obj;
    C_struct_SHA1sum sha1_obj;
    C_struct_SHA256sum sha256_obj;
    ObjRef path_class_ref;
    ObjRef object_class;
    ObjRef assoc_class_ref;
    ObjRef assoc_ref;
    ReferenceList* ref_list;
    int num_refs;
    int i;
    int j;
    char name[256];
    char answer[8];


    StorageType type = DEFAULT_TYPE_RW;
    char* path = DEFAULT_FILE;

    if (argc != 3 || strcmp(argv[1], "--all-traces") != 0 || *argv[2] == '-')
    {
	fprintf(stderr, "usage: %s --all-traces file\n", argv[0]);
	exit(1);
    }

    printf("\n");

#ifndef TEST_PASS_PHRASE
    printf("WARNING: while this program has been fairly thoroughly tested, it is possible\n");
    printf("that it could damage your archive in some way.  I highly recommend making a\n");
    printf("backup of your archive before using this program!\n\n");

    printf("Do you want to continue? (enter `yes' to remove %s) ", argv[2]);

    fflush(stdout);

    fgets(answer, sizeof(answer), stdin);

    printf("\n");

    if (strcmp(answer, "yes\n") != 0)
    {
	printf("No changes made!\n\n");
	exit(1);
    }
#endif

    nwos_get_key_from_password(big_key, sizeof(big_key));

    memcpy(bf_key, big_key, 16);
    linear = ((uint32)big_key[16] << 24) | ((uint32)big_key[17] << 16) | ((uint32)big_key[18] << 8) | (uint32)big_key[19];
    memcpy(root_object_ref.id, big_key+20, 4);
    serial = ((uint32)big_key[24] << 24) | ((uint32)big_key[25] << 16) | ((uint32)big_key[26] << 8) | (uint32)big_key[27];

    nwos_initialize_objectify(bf_key, linear, serial, type, path);

    nwos_set_root_object(&root_object_ref);


    assert(nwos_find_private_class_definition("FILE PATH", &path_class_ref));

    assert(nwos_find_private_class_definition("PATH AND FILE ASSOCIATION", &assoc_class_ref));


    nwos_read_class_definition(&assoc_class_ref, &class_def_obj);

    ref_list = nwos_malloc_reference_list(&class_def_obj.header.object.references);

    num_refs = ref_list->common_header.num_refs;

    printf("num_refs: %d\n", num_refs);

    for (i = 0; i < num_refs; i++)
    {
	nwos_get_object_class(&ref_list->references[i], &object_class);

	if (is_same_object(&object_class, &assoc_class_ref))
	{
	    nwos_read_object_from_disk(&ref_list->references[i], &assoc_obj, sizeof(assoc_obj));

	    nwos_read_variable_sized_object_from_disk(&assoc_obj.path, kludge, sizeof(kludge), &get_path_object_size);

	    /* remember ptr_path_obj points to the kludge buffer */

	    for (j = 0; j < ptr_path_obj->count; j++) name[j] = ptr_path_obj->storage[j];

	    name[j] = '\0';

	    if (strcmp(argv[2], name) == 0)
	    {
		copy_reference(&assoc_ref, &ref_list->references[i]);
		break;
	    }
	}
    }

    nwos_free_reference_list(ref_list);
    ref_list = NULL;

    if (i < num_refs)   /* found the file */
    {
	printf("path: %08x\n", nwos_ref_to_word(&assoc_obj.path));
	printf("association: %08x\n", nwos_ref_to_word(&assoc_ref));
	printf("file: %08x\n", nwos_ref_to_word(&assoc_obj.file));
	nwos_read_object_from_disk(&assoc_obj.file, &file_obj, sizeof(file_obj));
	printf("md5: %08x\n",  nwos_ref_to_word(&file_obj.md5sum));
	printf("sha1: %08x\n",  nwos_ref_to_word(&file_obj.sha1sum));
	printf("list: %08x\n", nwos_ref_to_word(&file_obj.block_list));


	/* check path object */

	ref_list = nwos_malloc_reference_list(&ptr_path_obj->header.object.references);
	num_refs = ref_list->common_header.num_refs;

	if (num_refs == 1 && is_same_object(&ref_list->references[0], &assoc_ref))
	{
	    printf("Path reference OK\n");
	    nwos_remove_object(&ptr_path_obj->header.object.references);
	    nwos_remove_object(&assoc_obj.path);
	    nwos_remove_from_references(&assoc_obj.path, &ptr_path_obj->header.common.class_definition);
	}
	else
	{
	    printf("Path reference count: %d\n", num_refs);
	}

	nwos_free_reference_list(ref_list);
	ref_list = NULL;


	/* check file object */

	ref_list = nwos_malloc_reference_list(&file_obj.header.object.references);
	num_refs = ref_list->common_header.num_refs;

	if (num_refs == 1 && is_same_object(&ref_list->references[0], &assoc_ref))
	{
	    printf("File reference OK\n");
	    nwos_remove_object(&file_obj.header.object.references);
	    nwos_remove_object(&assoc_obj.file);
	    nwos_remove_from_references(&assoc_obj.file, &file_obj.header.common.class_definition);
	}
	else
	{
	    printf("File reference count: %d\n", num_refs);
	}

	nwos_free_reference_list(ref_list);
	ref_list = NULL;

	/* check MD5 sum object */

	nwos_read_object_from_disk(&file_obj.md5sum, &md5_obj, sizeof(md5_obj));

	ref_list = nwos_malloc_reference_list(&md5_obj.header.object.references);
	num_refs = ref_list->common_header.num_refs;

	if (num_refs == 1 && is_same_object(&ref_list->references[0], &assoc_obj.file))
	{
	    printf("MD5 reference OK\n");
	    nwos_remove_object(&md5_obj.header.object.references);
	    nwos_remove_object(&file_obj.md5sum);
	    nwos_remove_from_references(&file_obj.md5sum, &md5_obj.header.common.class_definition);
	}
	else
	{
	    printf("MD5 reference count: %d\n", num_refs);
	}

	nwos_free_reference_list(ref_list);
	ref_list = NULL;


	/* check SHA1 sum object */

	nwos_read_object_from_disk(&file_obj.sha1sum, &sha1_obj, sizeof(sha1_obj));

	ref_list = nwos_malloc_reference_list(&sha1_obj.header.object.references);
	num_refs = ref_list->common_header.num_refs;

	if (num_refs == 1 && is_same_object(&ref_list->references[0], &assoc_obj.file))
	{
	    printf("SHA1 reference OK\n");
	    nwos_remove_object(&sha1_obj.header.object.references);
	    nwos_remove_object(&file_obj.sha1sum);
	    nwos_remove_from_references(&file_obj.sha1sum, &sha1_obj.header.common.class_definition);
	}
	else
	{
	    printf("SHA1 reference count: %d\n", num_refs);
	}

	nwos_free_reference_list(ref_list);
	ref_list = NULL;


	/* check SHA256 sum object */

	if (!is_void_reference(&file_obj.sha256sum))
	{
	    nwos_read_object_from_disk(&file_obj.sha256sum, &sha256_obj, sizeof(sha256_obj));

	    ref_list = nwos_malloc_reference_list(&sha256_obj.header.object.references);
	    num_refs = ref_list->common_header.num_refs;

	    if (num_refs == 1 && is_same_object(&ref_list->references[0], &assoc_obj.file))
	    {
		printf("SHA256 reference OK\n");
		nwos_remove_object(&sha256_obj.header.object.references);
		nwos_remove_object(&file_obj.sha256sum);
		nwos_remove_from_references(&file_obj.sha256sum, &sha256_obj.header.common.class_definition);
	    }
	    else
	    {
		printf("SHA256 reference count: %d\n", num_refs);
	    }

	    nwos_free_reference_list(ref_list);
	    ref_list = NULL;
	}

	/* do the block list */

	ref_list = nwos_malloc_reference_list(&file_obj.block_list);
	num_refs = ref_list->common_header.num_refs;

	printf("number of blocks: %d\n", num_refs);

	for (i = 0; i < num_refs; i++)
	{
	    nwos_remove_object(&ref_list->references[i]);
	}

	nwos_remove_object(&file_obj.block_list);

	nwos_free_reference_list(ref_list);
	ref_list = NULL;

	nwos_remove_object(&assoc_obj.header.object.references);
	nwos_remove_object(&assoc_ref);
	nwos_remove_from_references(&assoc_ref, &assoc_obj.header.common.class_definition);
    }
    else
    {
	printf("No file with the name: '%s' found in system\n", argv[2]);
    }

    nwos_terminate_objectify();

    return 0;
}


