/*
--             This file is part of the New World OS project
--                 Copyright (C) 2007-2008  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: verify_file.c,v $
-- Revision 1.12  2008/02/03 01:04:28  jsedwards
-- Changed DEFAULT_TYPE_RO to READ_ONLY and changed path variable to const char
-- instead of char.
--
-- Revision 1.11  2007/08/12 21:29:18  jsedwards
-- Remove call to set security level because this program doesn't create
-- objects there is no need for a security level.
--
-- Revision 1.10  2007/08/12 20:45:00  jsedwards
-- Change all of the "Encryption Level" stuff to "Security Level" because it
-- doesn't really change the encryption at all, all it does is change the
-- randomization of where objects are stored.
--
-- Revision 1.9  2007/07/21 14:57:01  jsedwards
-- Added 'match' parameter in call to nwos_file_is_identical so it will ignore
-- the time stamp on the file if desired.
--
-- Revision 1.8  2007/07/21 11:41:30  jsedwards
-- Added option to read compressed file instead of default storage.
--
-- Revision 1.7  2007/07/01 19:44:12  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.6  2007/06/13 21:20:58  jsedwards
-- Change to pass null to find_matching_path_and_file function for the
-- new directory parameter (which makes it work the same as before).
--
-- Revision 1.5  2007/06/05 23:50:16  jsedwards
-- Added option to ignore time stamp on files.
--
-- Revision 1.4  2007/03/18 19:55:53  jsedwards
-- Enabled verification for removal based on file having a backup copy on a disc.
--
-- Revision 1.3  2007/02/28 14:02:49  jsedwards
-- Added test to make sure file is stored in system before trying to compare it.
--
-- Revision 1.2  2007/02/11 16:58:26  jsedwards
-- Changed so DEFAULT_TYPE has to specify RO (Read-Only) or RW (Read-Write).
--
-- Revision 1.1  2007/01/27 17:37:00  jsedwards
-- Program to verify file if a file is stored in the system and if desired
-- delete it.
--
*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#include "objectify.h"


int main(int argc, char* argv[])
{
    ObjRef root_object_ref;
    uint8 big_key[16 + 8 + 4];
    uint8 bf_key[16];
    uint32 linear;
    uint32 serial;
    ObjRef ref;
    int i;
    bool do_remove = false;
    MatchCode match = MatchAll;
    char* path = DEFAULT_FILE;

    printf("\n");

    for (i = 1; i < argc && argv[i][0] == '-'; i++)
    {
	if (strcmp(argv[i], "--remove") == 0)
	{
	    do_remove = true;
	}
	else if (strcmp(argv[i], "--ignore-time") == 0)
	{
	    match = IgnoreTime;
	}
	else if (strcmp(argv[i], "--compressed") == 0)
	{
	    i++;
	    path = argv[i];
	}
	else
	{
	    fprintf(stderr, "Unknown option: %s\n", argv[i]);
	    exit(1);
	}
    }

    nwos_log_arguments(argc, argv);

    nwos_get_key_from_password(big_key, sizeof(big_key));

    memcpy(bf_key, big_key, 16);
    linear = ((uint32)big_key[16] << 24) | ((uint32)big_key[17] << 16) | ((uint32)big_key[18] << 8) | (uint32)big_key[19];
    memcpy(root_object_ref.id, big_key+20, 4);
    serial = ((uint32)big_key[24] << 24) | ((uint32)big_key[25] << 16) | ((uint32)big_key[26] << 8) | (uint32)big_key[27];

    nwos_initialize_objectify(bf_key, linear, serial, READ_ONLY, path);

    nwos_set_root_object(&root_object_ref);


    for (/* use i as left by loop above */; i < argc; i++)
    {
	printf("%s: ", argv[i]);
	fflush(stdout);

	if (nwos_find_matching_path_and_file_association(NULL, argv[i], &ref, match))
	{
	    if (do_remove)
	    {
		if (nwos_file_is_stored(&ref))
		{
		    assert(nwos_file_is_identical(&ref, argv[i], match));

		    if (unlink(argv[i]) != 0)
		    {
			perror(argv[i]);
			exit(1);
		    }

		    printf("removed\n");
		}
		else if (nwos_file_has_backup(&ref))
		{
		    if (unlink(argv[i]) != 0)
		    {
			perror(argv[i]);
			exit(1);
		    }

		    printf("removed\n");
		}
		else
		{
		    printf("no known backup, not removed\n");
		}
	    }
	    else
	    {
		printf("found: %02x%02x%02x%02x\n", ref.id[0], ref.id[1], ref.id[2], ref.id[3]);
	    }
	}
	else
	{
	    printf("NOT found\n");
	}
    }

    nwos_terminate_objectify();

    return 0;
}


