--
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: nwos_user.e,v $
-- Revision 1.2  2007/07/01 19:44:14  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.1  2007/04/14 02:24:23  jsedwards
-- Move Fine (Eiffel) files to next_gen directory.
--
-- Revision 1.15  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.14  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.13  2006/02/18 20:23:13  jsedwards
-- Changed attributes to routines that make sure the object is loaded before
-- returning the object.
--
-- Revision 1.12  2006/02/18 15:37:06  jsedwards
-- Changed name of "storage" in NWOS_STRING class to "to_string" so it makes
-- more sense in the clients.
--
-- Revision 1.11  2006/02/11 18:42:16  jsedwards
-- Changed call to reference "load" to "get_object".
--
-- Revision 1.10  2006/02/11 04:50:07  jsedwards
-- Filled in read_body_from_stream feature.
--
-- Revision 1.9  2006/02/10 13:52:26  jsedwards
-- Removed "load" from creation list.
--
-- Revision 1.8  2006/02/09 13:06:49  jsedwards
-- Added reference parameter to "initialize header" call and removed "next
-- identifier" feature that is now in nwos_header.  Changed to the new
-- method of doing the class defintion stuff, with the "class reference"
-- and "class revision".
--
-- Revision 1.7  2006/02/08 14:24:04  jsedwards
-- Added "load" to creation clause, a dummy read_body_from_stream routine,
-- and class reference to class definition "make" call.
--
-- Revision 1.6  2006/02/05 05:04:07  jsedwards
-- Added a void reference at the end to terminate the references.
--
-- Revision 1.5  2006/02/05 03:21:04  jsedwards
-- Changed to new format.
--
-- Revision 1.4  2006/02/04 15:00:36  jsedwards
-- Changed to the new way of having a deferred class_definition.
--
-- Revision 1.3  2006/02/03 13:34:20  jsedwards
-- Added references so can point to objects created (Big_Bang_02).
--
-- Revision 1.2  2006/01/31 19:29:36  jsedwards
-- Moved the kludgy class stuff to the end of the file instead of the
-- beginning, to be consistent with the other classes.
--
-- Revision 1.1  2006/01/31 14:12:25  jsedwards
-- Initial version.
--


class NWOS_USER

inherit NWOS_OBJECT

creation make, make_unresolved


feature

   name: STRING is
      do
         load_if_not_already
         Result := name_obj.to_string
      ensure
         Result /= Void
      end

   references: ARRAY[NWOS_OBJECT] is
      do
         load_if_not_already
         Result := references_obj
      ensure
         Result /= Void
      end


feature

   add_reference(ref: NWOS_OBJECT) is
      do
         references.add_last(ref)
      end


feature {NONE}

   make(nm: STRING) is
      do
         !!name_obj.copy_from_string(nm)
         !!references_obj.with_capacity(8, 1)
         initialize_header(next_nwos_identifier)
      end

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      local
         i: INTEGER
      do
         name_obj.write_to_stream(stream)

         from
            i := references_obj.lower
         until
            i > references_obj.upper
         loop
            references_obj.item(i).class_definition.identifier.write_to_stream(stream)
            references_obj.item(i).identifier.write_to_stream(stream)
            i := i + 1
         end

         Void_reference.write_to_stream(stream)
      end

   read_body_from_stream(stream: BINARY_INPUT_STREAM) is
      local
         obj: NWOS_OBJECT
         class_ref: NWOS_REFERENCE
         object_ref: NWOS_REFERENCE
      do
         !!name_obj.read_from_stream(stream)

std_output.put_string("NWOS_USER.read_body_from_stream")
std_output.put_string("%N  name: ")
std_output.put_string(name_obj.to_string)
std_output.put_new_line

         !!references_obj.with_capacity(8, 1)

         from
            !!class_ref.make_from_stream(stream)
         until
            class_ref.is_void
         loop
            !!object_ref.make_from_stream(stream)

std_output.put_string("NWOS_USER.read_body_from_stream")
std_output.put_string("%N  class: ")
std_output.put_string(class_ref.to_string)
std_output.put_string("%N  object: ")
std_output.put_string(object_ref.to_string)
std_output.put_new_line

            obj := object_ref.get_object(class_ref)
            references_obj.add_last(obj)

            !!class_ref.make_from_stream(stream)
         end
      end


feature {NONE}

   name_obj: NWOS_STRING

   references_obj: ARRAY[NWOS_OBJECT]


feature {NONE}  -- once again the kludgy class definition stuff

   class_revision: STRING is
      once
         !!Result.copy("$Revision: 1.2 $")
         Result.remove_prefix("$Revision: ")
         Result.remove_suffix(" $")
      end

   class_reference: NWOS_REFERENCE is
      do
         Result := Class_user_ref
      end

end

