/*             This file is part of the New World OS project
--                 Copyright (C) 2004-2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: config.h,v $
-- Revision 1.8  2007/06/22 14:14:57  jsedwards
-- Added DEFAULT_PUBLIC_PATH for location of public objects file.
--
-- Revision 1.7  2007/03/07 13:09:25  jsedwards
-- Added LOG_FILE_NAME so debug versions can change it and have a separate file.
--
-- Revision 1.6  2007/02/11 17:12:50  jsedwards
-- Change default device to something that should not exist.  Remove default
-- log file location, generate it dynamically from now on.
--
-- Revision 1.5  2007/02/11 17:04:57  jsedwards
-- Changed so DEFAULT_TYPE has to specify RO (Read-Only) or RW (Read-Write).
--
-- Revision 1.4  2006/11/11 12:01:01  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.3  2006/11/04 18:51:07  jsedwards
-- Made a #define in the config.h file for the log file.
--
-- Revision 1.2  2006/10/26 01:51:26  jsedwards
-- Merged alpha_05_branch back into main trunk.
--
-- Revision 1.1.2.6  2006/10/22 13:07:11  jsedwards
-- Removed BLOCKS_ON_DISK define, it is now a variable read from disk.
--
-- Revision 1.1.2.5  2006/10/03 12:51:57  jsedwards
-- Added enumeration of different storage types and a define for default type.
--
-- Revision 1.1.2.4  2006/10/02 01:23:39  jsedwards
-- Added definition of maximum blocks cached.
--
-- Revision 1.1.2.3  2006/09/26 13:18:22  jsedwards
-- Removed OBJECT_DIRECTORY and COMPATIBLE_VERSIONS definitions as they are
-- no longer used.  Added DEFAULT_FILE (which is now the disk drive or
-- partition) from objectify_private.h.  Also added the disk or partition
-- size definition.
--
-- Revision 1.1.2.2  2006/09/02 15:12:16  jsedwards
-- Moved FILE_BLOCK_SIZE back to objectify.h because now that we are storing
-- all the objects in one large, sparse file, it is no longer really the file
-- block size, it is now the size of each object written to the file.
--
-- Revision 1.1.2.1  2006/08/19 12:46:49  jsedwards
-- Moved configuration defines out of objectify.h and into a new file config.h.
--
*/


#ifndef CONFIG_H
#define CONFIG_H

typedef enum {
  Drive_Or_Partition_RO = 0,
  Drive_Or_Partition_RW,
  Sparse_File_RO,
  Sparse_File_RW,
  Compressed_File_RO,
  Compressed_File_RW
} StorageType;


#define HEADER_VERSION "\0\0\0\0"

#define DEFAULT_TYPE_RO Drive_Or_Partition_RO
#define DEFAULT_TYPE_RW (DEFAULT_TYPE_RO + 1)
#define DEFAULT_FILE "/dev/objectify"
#define DEFAULT_PUBLIC_PATH "/usr/share/objectify/public.obj"

#define LOG_FILE_NAME "objectify_log"

#define MAX_BLOCKS_CACHED 65536    // use up to 16 mb of ram for caching blocks


#endif
