/*             This file is part of the New World OS project
--                   Copyright (C) 2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- This is a simple program to list all public names in the system, this
-- includes names for people, cities, states, classes, manufacturers, etc.
--
-- $Log: list_public_names.c,v $
-- Revision 1.2  2007/06/23 11:55:37  jsedwards
-- Removed private file patch which is no longer needed because public objects
-- are separate now.
--
-- Revision 1.1  2007/06/03 17:17:22  jsedwards
-- Initial version, created from list_public_spellings.c.
--
*/


#include <assert.h>
#include <stdio.h>

#include "../crc32.h"
#include "../objectify_private.h"


int main(int argc, char* argv[])
{
    ObjRef root_ref;
    ObjRef name_class_ref;
    ObjRef class_ref;
    EveryObject header;
    ReferenceList* ref_list;
    int num_refs;
    int i;
    char name[64];

    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(NULL, 0, 0, 0, NULL);

    nwos_set_encryption_level(Encryption_None);

    root_ref.id[0] = 0;
    root_ref.id[1] = 0;
    root_ref.id[2] = 0;
    root_ref.id[3] = 1;

    nwos_set_root_object(&root_ref);

    assert(nwos_find_public_class_definition("NAME", &name_class_ref));

    printf("Name class reference: %02x%02x%02x%02x\n",
	   name_class_ref.id[0],
	   name_class_ref.id[1],
	   name_class_ref.id[2],
	   name_class_ref.id[3]);


    nwos_read_object_headers_from_disk(&name_class_ref, &header);

    ref_list = nwos_malloc_reference_list(&header.object.references);
    num_refs = ref_list->common_header.num_refs;

    printf("Number of names: %d\n", num_refs);

    for (i = 0; i < num_refs; i++)
    {
	nwos_get_object_class(&ref_list->references[i], &class_ref);

	if (is_same_object(&class_ref, &name_class_ref))
	{
	    nwos_name_to_string(&ref_list->references[i], name, sizeof(name));

	    printf("%s\n", name);
	}
    }

    nwos_free_reference_list(ref_list);
    ref_list = NULL;

    nwos_terminate_objectify();

    return 0;
}

