--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.sedwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- This program converts a file with a single column of names to multiple
-- strings per line wrapped in quotes and comma separated for C input.
--
-- $Log: names_to_strings.e,v $
-- Revision 1.1  2006/12/24 12:35:32  jsedwards
-- Program to convert a list of names (one per line) to strings for inclusion
-- in a C program.
--


class NAMES_TO_STRINGS

creation make

feature

   make is
      local
         name: STRING
         line: STRING
      do
         !!name.make(16);
         !!line.make(116);

         from
            std_input.read_line_in(name)
         until
            std_input.end_of_input
         loop
            name.remove_trailing_spaces

            if line.count + name.count + 4 > line.capacity then
               std_output.put_string(line)
               std_output.put_new_line
               line.clear
            end

            line.extend('%"')
            line.append(name)
            line.append("%", ")

            std_input.read_line_in(name)
         end

         
         std_output.put_string(line)
         std_output.put_new_line
      end

end

