--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.sedwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: globals.e,v $
-- Revision 1.14  2006/11/10 03:56:38  jsedwards
-- Added "count" to Feature_Defintion class.
--
-- Revision 1.13  2006/11/02 14:12:45  jsedwards
-- Added find_class_from_reference feature.
--
-- Revision 1.12  2006/11/02 13:52:47  jsedwards
-- Added features to find features, names, and spellings from their references.
-- Also added features to assist in creating an object from csv line.
--
-- Revision 1.11  2006/11/01 12:50:35  jsedwards
-- Add code to read ref_list_class_def when creation class_def_class_def so
-- that it exists before printing out (so it doesn't change count inside loop).
--
-- Revision 1.10  2006/10/31 23:14:17  jsedwards
-- Change to check for existing feature before creating a new one, when
-- creating the feature, name, and spelling class definitions.
--
-- Revision 1.9  2006/10/31 14:16:52  jsedwards
-- Uncommented and fixed find_class feature.
--
-- Revision 1.8  2006/10/31 14:07:01  jsedwards
-- Added reference_lists.
--
-- Revision 1.7  2006/10/31 13:31:15  jsedwards
-- Added "find_feature" feature and changed feature creation calls to have
-- the separate element count instead of [N] in the name.
--
-- Revision 1.6  2006/10/30 13:51:11  jsedwards
-- Change "find_spelling" to case insensitive match.
--
-- Revision 1.5  2006/10/30 13:36:53  jsedwards
-- Add "find_names" feature.
--
-- Revision 1.4  2006/10/30 13:15:00  jsedwards
-- Changed names of "classes", "features", "names", and "spellings" to
-- "all_classes", "all_features", "all_names", and "all_spellings".
-- Removed adding of classes and features to the "all_classes" and
-- "all_features" arrays because they now add themselves.
--
-- Revision 1.3  2006/10/30 12:26:41  jsedwards
-- Added "find_spelling" feature.
--
-- Revision 1.2  2006/10/29 17:28:47  jsedwards
-- Changed to create the four "chicken and egg" classes in the code.
--
-- Revision 1.1  2006/10/29 17:01:49  jsedwards
-- Initial version created from features removed from convert_c_structs_to_csv
-- class.
--


class GLOBALS

feature

   all_classes: FIXED_ARRAY[CLASS_DEFINITION] is
      once
         !!Result.with_capacity(64)
      end

   all_features: FIXED_ARRAY[FEATURE_DEFINITION] is
      once
         !!Result.with_capacity(64)
      end

   all_names: FIXED_ARRAY[NAME] is
      once
         !!Result.with_capacity(256)
      end

   all_spellings: FIXED_ARRAY[SPELLING] is
      once
         !!Result.with_capacity(256)
      end

   all_reference_lists: FIXED_ARRAY[REFERENCE_LIST] is
      once
         !!Result.with_capacity(512)
      end



   obj_ref_class_def: CLASS_DEFINITION is
      once
         !!Result.make
         Result.put_name("object_reference")
      end

   ref_list_class_def: CLASS_DEFINITION is
      once
         !!Result.make
         Result.put_name("reference_list")
      end

   byte_class_def: CLASS_DEFINITION is
      once
         !!Result.make
         Result.put_name("byte")
      end

   char_class_def: CLASS_DEFINITION is
      once
         !!Result.make
         Result.put_name("character")
      end

   time_stamp_class_def: CLASS_DEFINITION is
      once
         !!Result.make
         Result.put_name("time_stamp")
      end



   class_def_class_def: CLASS_DEFINITION is
      local
         feature_def: FEATURE_DEFINITION
         dummy: UNSIGNED
      once
         !!Result.make
         Result.put_name("class_definition")

         feature_def := find_feature(obj_ref_class_def.reference, "name", 1)
         if feature_def = Void then
            !!feature_def.make(obj_ref_class_def.reference, "name", 1)
         end
         Result.add_feature(feature_def)

         feature_def := find_feature(byte_class_def.reference, "count", 1)
         if feature_def = Void then
            !!feature_def.make(byte_class_def.reference, "count", 1)
         end
         Result.add_feature(feature_def)

         feature_def := find_feature(obj_ref_class_def.reference, "feature", 0)
         if feature_def = Void then
            !!feature_def.make(obj_ref_class_def.reference, "feature", 0)
         end
         Result.add_feature(feature_def)

         dummy := ref_list_class_def.reference     -- make sure this class is created
      end

   feat_def_class_def: CLASS_DEFINITION is
      local
         feature_def: FEATURE_DEFINITION
      once
         !!Result.make
         Result.put_name("feature_definition")

         feature_def := find_feature(obj_ref_class_def.reference, "inherit", 1)
         if feature_def = Void then
            !!feature_def.make(obj_ref_class_def.reference, "inherit", 1)
         end
         Result.add_feature(feature_def)

         feature_def := find_feature(obj_ref_class_def.reference, "class", 1)
         if feature_def = Void then
            !!feature_def.make(obj_ref_class_def.reference, "class", 1)
         end
         Result.add_feature(feature_def)

         feature_def := find_feature(obj_ref_class_def.reference, "label", 1)
         if feature_def = Void then
            !!feature_def.make(obj_ref_class_def.reference, "label", 1)
         end
         Result.add_feature(feature_def)

         feature_def := find_feature(byte_class_def.reference, "count", 1)
         if feature_def = Void then
            !!feature_def.make(byte_class_def.reference, "count", 1)
         end
         Result.add_feature(feature_def)
      end

   name_class_def: CLASS_DEFINITION is
      local
         feature_def: FEATURE_DEFINITION
      once
         !!Result.make
         Result.put_name("name")

         feature_def := find_feature(byte_class_def.reference, "count", 1)
         if feature_def = Void then
            !!feature_def.make(byte_class_def.reference, "count", 1)
         end
         Result.add_feature(feature_def)

         feature_def := find_feature(obj_ref_class_def.reference, "spelling", 0)
         if feature_def = Void then
            !!feature_def.make(obj_ref_class_def.reference, "spelling", 0)
         end
         Result.add_feature(feature_def)
      end

   spelling_class_def: CLASS_DEFINITION is
      local
         feature_def: FEATURE_DEFINITION
      once
         !!Result.make
         Result.put_name("spelling")

         feature_def := find_feature(obj_ref_class_def.reference, "character_set", 1)
         if feature_def = Void then
            !!feature_def.make(obj_ref_class_def.reference, "character_set", 1)
         end
         Result.add_feature(feature_def)

         feature_def := find_feature(byte_class_def.reference, "count", 1)
         if feature_def = Void then
            !!feature_def.make(byte_class_def.reference, "count", 1)
         end
         Result.add_feature(feature_def)

         feature_def := find_feature(char_class_def.reference, "storage", 0)
         if feature_def = Void then
            !!feature_def.make(char_class_def.reference, "storage", 0)
         end
         Result.add_feature(feature_def)
      end



   find_spelling(spell: STRING): SPELLING is
      local
         i: INTEGER
      do
         from
            i := all_spellings.lower
         variant
            all_spellings.upper - i
         until
            i > all_spellings.upper or else Result /= Void
         loop
            if all_spellings.item(i).spelling.same_as(spell) then
               Result := all_spellings.item(i)
            end

            i := i + 1
         end
      end

   find_spelling_from_reference(ref: UNSIGNED): SPELLING is
      local
         i: INTEGER
      do
         from
            i := all_spellings.lower
         variant
            all_spellings.upper - i
         until
            i > all_spellings.upper or else Result /= Void
         loop
            if all_spellings.item(i).reference = ref then
               Result := all_spellings.item(i)
            end

            i := i + 1
         end
      end

   find_name(name: STRING): NAME is
      local
         i: INTEGER
      do
         from
            i := all_names.lower
         variant
            all_names.upper - i
         until
            i > all_names.upper or else Result /= Void
         loop
            if all_names.item(i).name.same_as(name) then
               Result := all_names.item(i)
            end

            i := i + 1
         end
      end

   find_name_from_reference(ref: UNSIGNED): NAME is
      local
         i: INTEGER
      do
         from
            i := all_names.lower
         variant
            all_names.upper - i
         until
            i > all_names.upper or else Result /= Void
         loop
            if all_names.item(i).reference = ref then
               Result := all_names.item(i)
            end

            i := i + 1
         end
      end

   find_feature(type: UNSIGNED; name: STRING; num_of_elem: INTEGER): FEATURE_DEFINITION is
      require
         not name.has('[')
      local
         i: INTEGER
      do
         from
            i := all_features.lower
         variant
            all_features.upper - i
         until
            i > all_features.upper or else Result /= Void
         loop
            if name.same_as("storage") then
               std_output.put_unsigned_in_hexadecimal(all_features.item(i).type)
               std_output.put_string(" ")
               std_output.put_string(all_features.item(i).name.name)
               std_output.put_new_line
            end

            if all_features.item(i).type = type then
               if all_features.item(i).number = num_of_elem then
                  if all_features.item(i).name.name.same_as(name) then
                     Result := all_features.item(i)
                  end
               end
            end

            i := i + 1
         end
      end
      

   find_feature_from_reference(ref: UNSIGNED): FEATURE_DEFINITION is
      local
         i: INTEGER
      do
         from
            i := all_features.lower
         variant
            all_features.upper - i
         until
            i > all_features.upper or else Result /= Void
         loop
            if all_features.item(i).reference = ref then
               Result := all_features.item(i)
            end

            i := i + 1
         end
      end
      

   find_class(name: STRING): CLASS_DEFINITION is
      local
         i: INTEGER
      do
         from
            i := all_classes.lower
         variant
            all_classes.upper - i
         until
            i > all_classes.upper or else Result /= Void
         loop
            if all_classes.item(i).name /= Void and then all_classes.item(i).name.name.same_as(name) then
               Result := all_classes.item(i)
            end

            i := i + 1
         end
      end


   find_class_from_reference(ref: UNSIGNED): CLASS_DEFINITION is
      local
         i: INTEGER
      do
         from
            i := all_classes.lower
         variant
            all_classes.upper - i
         until
            i > all_classes.upper or else Result /= Void
         loop
            if all_classes.item(i).reference = ref then
               Result := all_classes.item(i)
            end

            i := i + 1
         end
      end


   scan_reference(line: STRING): UNSIGNED is
      local
         i: INTEGER
      do
         if line.count < 10 then
            std_error.put_string("scan_reference - line too short: ")
            std_error.put_string(line)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         if not line.has_prefix("0x") then
            std_error.put_string("scan_reference - missing 0x: ")
            std_error.put_string(line)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         from
            i := 3
         variant
            10 - i
         until
            i > 10
         loop
            if not line.item(i).is_hexadecimal_digit then
               std_error.put_string("scan_reference - invalid digit: ")
               std_error.put_string(line)
               std_error.put_new_line
               die_with_code(exit_failure_code)
            end

            i := i + 1
         end

         from
            i := 3
         variant
            10 - i
         until
            i > 10
         loop
            Result := Result * 16U + line.item(i).hexadecimal_value.to_unsigned
            i := i + 1
         end

         line.remove_first(10)
      end

   check_comma(line: STRING) is
      do
         if line.first = ',' then
            line.remove_first(1)
         else
            std_error.put_string("missing comma: ")
            std_error.put_string(line)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end
      end

   skip_time(line: STRING) is
      do
         if line.count < 32 then
            std_error.put_string("scan_reference - line too short: ")
            std_error.put_string(line)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         if line.item(1) /= '"' then
            std_error.put_string("scan_reference - missing beginning %": ")
            std_error.put_string(line)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         if line.item(32) /= '"' then
            std_error.put_string("scan_reference - missing ending %": ")
            std_error.put_string(line)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         -- for now ignore if it is valid or not

         line.remove_first(32)
      end

end

