/*             This file is part of the New World OS project
--                 Copyright (C) 2004-2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: c_structs_0014.h,v $
-- Revision 1.1  2007/04/04 23:26:46  jsedwards
-- Different C_structs for importing 0014 objects.
--
*/

/* This file just contains the C_structs that changed between 0014 and 0016  */


typedef struct {
    EveryObject header;
    ObjRef name;
    ObjRef date;
    ObjRef capital;
    ObjRef postal_code;
    uint8 number;
} C_struct_US_State_0014;

typedef struct {
    EveryObject header;
    uint8 count;
    char storage[0];
} C_struct_Year_0014;

typedef struct {
    EveryObject header;
    ObjRef definition;
    char storage[2];
    uint8 minimum_days;
    uint8 maximum_days;
} C_struct_Month_0014;

typedef struct {
    EveryObject header;
    ObjRef year;
    ObjRef month;
    uint8 day_of_month;
} C_struct_Date_0014;

typedef struct {
    EveryObject header;
    ObjRef file;
    uint8 count;
    char storage[0];
} C_struct_File_Path_0014;

typedef struct {
    EveryObject header;
    ObjRef gender;
    ObjRef title;
    ObjRef first_name;
    ObjRef middle_name;
    ObjRef last_name;
    ObjRef maiden_name;
    ObjRef preferred_name;
    ObjRef goes_by;
    ObjRef nickname;
    ObjRef birth_date;
    ObjRef birth_place;
    ObjRef death_date;
    ObjRef death_place;
    ObjRef height;
    ObjRef mailing_address;
} C_struct_Person_0014;


