/*             This file is part of the New World OS project
--                Copyright (C) 2005, 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: add_more_names.c,v $
-- Revision 1.4  2007/06/05 12:38:43  jsedwards
-- Changed to add a bunch more names.
--
-- Revision 1.3  2007/05/20 14:35:36  jsedwards
-- Added some V through Z names.
--
-- Revision 1.2  2007/05/05 14:07:10  jsedwards
-- Changed to add some other names.
--
-- Revision 1.1  2007/05/05 12:42:01  jsedwards
-- Initial version.
--
*/

/* This program adds names to the public objects. */


#include <stdio.h>

#include "../objectify_private.h"



static char* extra_names[] = 
{
"abramovitz", "abramowitz", "archibald", "cleveland", "coolidge", "dwight", "eastwood", "eisenhower", 
"ficher", "garfield", "grover", "harman", "harmon", "hartman", "hoover", "hunsaker", "huntington", 
"hunt", "hunter", "huntsman", "jefferson", "kissinger", "kline", "knowlton", "knox", "kowalski", 
"kowalsky", "little", "lyndon", "madge", "mae", "malachi", "mallory", "man", "manfred", "manley", 
"marcia", "marcy", "mariel", "marietta", "mario", "marleen", "marlene", "mckinley", "meng", "millard", 
"molly", "paige", "park", "pelosi", "pierce", "polk", "rajchel", "reagan", "regan", "rockwell", 
"rodham", "roosevelt", "rutherford", "singer", "sitzmann", "skeeter", "skelton", "skolnick", 
"slovenski", "sorensen", "sorenson", "soto", "spooner", "sproul", "stafford", "standteiner", 
"stankevitz", "stankovic", "stapleton", "steadman", "stenquist", "ulysses", "walt", "westley", 
"wolfgang", "yolanda", "yuck", "yue", "yuen", "yun", "yung", "yunk", "yul", "yuri", "yurth", "yusef", 
"zachary", "zak", "zelda", "zola" 
};

#define NUM_EXTRA_NAMES (sizeof(extra_names) / sizeof(char*))



int main(int argc, char* argv[])
{
    ObjRef root_obj_ref;
    int i;
    ObjRef ref;
    char msg[128];


    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(NULL, 0, 0, DEFAULT_TYPE_RW, DEFAULT_FILE);

    root_obj_ref.id[0] = 0;
    root_obj_ref.id[1] = 0;
    root_obj_ref.id[2] = 0;
    root_obj_ref.id[3] = 1;

    nwos_set_root_object(&root_obj_ref);

    for (i = 0; i < NUM_EXTRA_NAMES; i++)
    {
	snprintf(msg, sizeof(msg), "Creating name: %s", extra_names[i]);
	nwos_log(msg);

	nwos_create_name(extra_names[i], &ref);
    }

    nwos_terminate_objectify();

    return 0;
}

