--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: nwos_big_bang.e,v $
-- Revision 1.1  2007/04/14 02:24:09  jsedwards
-- Move Fine (Eiffel) files to next_gen directory.
--
-- Revision 1.24  2006/11/11 12:29:18  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.23  2006/02/25 04:49:24  jsedwards
-- Added the "thing" stuff for "word" and "noun".
--
-- Revision 1.22  2006/02/20 13:40:50  jsedwards
-- Removed the reading of words from a file and the procurement of the aspell
-- dictionary stuff.
--
-- Revision 1.21  2006/02/20 05:40:04  jsedwards
-- Changed English name to a proper noun instead of just a noun (so it will
-- be printed with the first character upper case).
--
-- Revision 1.20  2006/02/18 20:36:30  jsedwards
-- Removed "to_string" from source file name references because it is now a
-- string instead of a NWOS_STRING.
--
-- Revision 1.19  2006/02/18 15:37:06  jsedwards
-- Changed name of "storage" in NWOS_STRING class to "to_string" so it makes
-- more sense in the clients.
--
-- Revision 1.18  2006/02/16 19:16:20  jsedwards
-- Changed to let "it's" and "let's" be entered.
--
-- Revision 1.17  2006/02/16 13:46:54  jsedwards
-- Added check to see if a word starts with a lower case letter and then ends
-- with 's.  I am not sure that all of these really should be in here so I am
-- going to error on the side of leaving them out for now.
--
-- Revision 1.16  2006/02/16 02:56:45  jsedwards
-- Changed "name" and "names_file" to "word" and "words_file" because now it's
-- reading words and not just names (avoid confusion).  Moved creation of the
-- three nouns into reading loop so that it creates the words after the
-- spelling has been created and "make" word no longer creates the spelling.
--
-- Revision 1.15  2006/02/15 14:24:57  jsedwards
-- Added stuff to set up source file and procurement of those files.
-- Added loop to read it multiple word lists.
--
-- Revision 1.14  2006/02/13 14:13:17  jsedwards
-- Changed to accept hyphens and apostrophes in words.
--
-- Revision 1.13  2006/02/13 04:45:41  jsedwards
-- Changed to read in aspell en-common list instead of names list and added
-- creation of the hyphen and apostrophe punctuation marks.
--
-- Revision 1.12  2006/02/10 02:07:13  jsedwards
-- Changed to access the class_definition_object through the root object.
-- Made the "app revision" a regular Eiffel string instead of a nwos string.
--
-- Revision 1.11  2006/02/09 20:38:37  jsedwards
-- Removed the user and log objects because they need to be somewhere they
-- can be shared with the header.
--
-- Revision 1.10  2006/02/09 14:05:25  jsedwards
-- Changed to new application format where the application doesn't inherit
-- from "application", but just creates it.  That way there isn't a difficulty
-- when reloading an application object, because application objects aren't
-- deferred.
--
-- Revision 1.9  2006/02/06 14:06:18  jsedwards
-- Added creation of root object and a bunch of spellings.
--
-- Revision 1.8  2006/02/05 17:00:38  jsedwards
-- Changed to use the new "letter" feature of "alphabet" to find the letter
-- from the ascii character instead of the whole ugly convert ascii character
-- to an index.
-- Added creation of the word "english" and added it to the english language
-- object.
--
-- Revision 1.7  2006/02/05 05:02:25  jsedwards
-- Added code to create the English language, alphabet, and letters.
--
-- Revision 1.6  2006/02/05 03:25:07  jsedwards
-- Changed to inherit from "application" class and to set up the session log.
--
-- Revision 1.5  2006/02/04 15:04:28  jsedwards
-- Changed to call store_all on one object at the end (which stores all
-- objects) instead of calling store on every object, which wouldn't save
-- all of the class objects because the big_bang doesn't have references
-- to all classes.
--
-- Revision 1.4  2006/02/04 02:41:37  jsedwards
-- Changed to generate upper and lower case character objects.
--
-- Revision 1.3  2006/02/03 14:24:05  jsedwards
-- Added creation of an ascii character object, but with a dummy reference to
-- the character object.
--
-- Revision 1.2  2006/02/03 03:06:15  jsedwards
-- Changed to create the 256 binary code objects (Big_Bang_02)
--
-- Revision 1.1  2006/02/02 05:45:42  jsedwards
-- First version that just creates the class definition class (00000002).
--


class NWOS_BIG_BANG

inherit NWOS_SESSION
        NWOS_PREDEFINED_REFERENCES

creation make

feature

   alphabet_obj:    NWOS_ALPHABET
   apostrophe_obj:  NWOS_PUNCTUATION_MARK
   hyphen_obj:      NWOS_PUNCTUATION_MARK

   conjunctions: ARRAY[STRING] is 
      once
         Result := << "it's", "let's" >>
      end

   make is
      local
--         big_bang_obj: NWOS_APPLICATION
         ascii_obj:    NWOS_ASCII_CHARACTER
         char_obj:     NWOS_CHARACTER
         code_obj:     NWOS_BINARY_CODE
         english_obj:  NWOS_LANGUAGE
         letter_obj:   NWOS_LETTER
         lower_obj:    NWOS_LOWER_CASE_CHARACTER
         noun_obj:     NWOS_NOUN
         proper_obj:   NWOS_PROPER_NOUN
         root_obj:     NWOS_ROOT
         spelling_obj: NWOS_SPELLING
         thing_obj:    NWOS_THING
         upper_obj:    NWOS_UPPER_CASE_CHARACTER

         code:         INTEGER
         letter:       CHARACTER
         word:         STRING
      do

        -- the big bang is a special case because none of this infrastructure exists.  I.E. we can't create an
        -- application object in advance... or can we?

         session_log.make_app(generating_type, app_revision)
         session_log.make_user("jse")

         !!root_obj.make  -- make the root object (the entry point to the entire thing)

         ------------------------------------------------------
         -- create the english language, alphabet and letters
         ------------------------------------------------------

         !!english_obj.make

         !!alphabet_obj.make(english_obj, 26)

         from
            letter := 'A'
         until
            letter > 'Z'
         loop
            inspect
               letter
            when 'A', 'E', 'I', 'O', 'U' then
               !NWOS_VOWEL!letter_obj.make_with_alphabet(alphabet_obj)
            when 'Y' then
               !NWOS_SOMETIMES_VOWEL!letter_obj.make_with_alphabet(alphabet_obj)
            else
               !NWOS_CONSONANT!letter_obj.make_with_alphabet(alphabet_obj)
            end
  
            alphabet_obj.put(letter_obj, letter.code - ('A').code + 1)

            letter := letter.next
         end

         !!apostrophe_obj.make
std_output.put_string("Apostrophe ref: ")
std_output.put_string(apostrophe_obj.identifier.to_string)
std_output.put_new_line
         !!hyphen_obj.make
std_output.put_string("Hyphen ref: ")
std_output.put_string(hyphen_obj.identifier.to_string)
std_output.put_new_line

         from
            code := 0
         until
            code > 255
         loop
            !!code_obj.make_1_byte(code.to_character)

            inspect
               code.to_character
            when 'A'..'Z' then
               !!upper_obj.make(alphabet_obj.letter(code.to_character))
               alphabet_obj.letter(code.to_character).set_upper_case(upper_obj)
               !!ascii_obj.make(upper_obj, code_obj)
               upper_obj.add_character_set(ascii_obj)
            when 'a'..'z' then
               !!lower_obj.make(alphabet_obj.letter(code.to_character))
               alphabet_obj.letter(code.to_character).set_lower_case(lower_obj)
               !!ascii_obj.make(lower_obj, code_obj)
               lower_obj.add_character_set(ascii_obj)
            when '%'' then
               !!char_obj.make(apostrophe_obj)
               apostrophe_obj.set_character(char_obj)
               !!ascii_obj.make(char_obj, code_obj)
               char_obj.add_character_set(ascii_obj)
            when '-' then
               !!char_obj.make(hyphen_obj)
               hyphen_obj.set_character(char_obj)
               !!ascii_obj.make(char_obj, code_obj)
               char_obj.add_character_set(ascii_obj)
            else
               -- unused right now, ignore it
            end

            code := code + 1
         end


         ------------------------------------------------------------------
         -- create spelling for a bunch of names to basically test it out
         ------------------------------------------------------------------

         !!word.make(24)

         !!spelling_obj.make(alphabet_obj, "english", Void)
         !!proper_obj.make(alphabet_obj, spelling_obj)
         english_obj.add_name(proper_obj)

         !!spelling_obj.make(alphabet_obj, "apostrophe", Void)
         !!noun_obj.make(alphabet_obj, spelling_obj)
         apostrophe_obj.set_name(noun_obj)

         !!spelling_obj.make(alphabet_obj, "hyphen", Void)
         !!noun_obj.make(alphabet_obj, spelling_obj)
         hyphen_obj.set_name(noun_obj)

         !!spelling_obj.make(alphabet_obj, "word", Void)
         !!noun_obj.make(alphabet_obj, spelling_obj)
         thing_obj ?= Class_word_ref.get_object(Class_thing_ref)
         thing_obj.add_name(noun_obj)

--         !!spelling_obj.make(alphabet_obj, "noun", Void)
--         !!noun_obj.make(alphabet_obj, spelling_obj)
--         class_def_obj ?= Class_noun_ref.object(Class_class_definition_ref)
--         class_def_obj.add_name(noun_obj)

         -- write the whole kit and kaboodle to disk
         root_obj.class_definition_object.store_all(1)
      end

   is_all_valid(word: STRING): BOOLEAN is
      -- true if all the characters in "word" are letters, hyphen, or apostrophe
      local
         i: INTEGER
      do
         from
            i := word.lower
         until
            i > word.upper
               or else
            not valid_char(word.item(i))
         loop
            i := i + 1
         end

         Result := i > word.upper
      end

   valid_char(c: CHARACTER): BOOLEAN is
      do
         Result := c.is_letter or else c = '%'' or else c = '-'
      end

   already_have_spelling(word: STRING): BOOLEAN is
      -- true if we already have a spelling for this word
      local
         spindex: NWOS_SPELLING_INDEX
         symbol: NWOS_SYMBOL
         i: INTEGER
      do
         from
            spindex := alphabet_obj.letter(word.item(1)).spelling_index  -- get index for first letter
            i := 2
         until
            i > word.upper or spindex = Void
         loop
            inspect
               word.item(i)
            when 'A'..'Z', 'a'..'z' then
               symbol := alphabet_obj.letter(word.item(i))
            when '%'' then
               symbol := apostrophe_obj
            when '-' then
               symbol := hyphen_obj
            end

            spindex := spindex.item(symbol)

            i := i + 1
         end

         Result := spindex /= Void and then spindex.spelling /= Void
      end

feature {NONE}  -- kludgy application stuff

   app_revision: STRING is
      once
         !!Result.copy("$Revision: 1.1 $")
         Result.remove_prefix("$Revision: ")
         Result.remove_suffix(" $")
      end

end


