--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.sedwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: remove_time.e,v $
-- Revision 1.2  2006/11/05 13:40:41  jsedwards
-- Added GPL header (oops).
--
--
-- Program to remove time from .csv files so that they can be diff'd.
--


class REMOVE_TIME

creation make

feature

   make is
      local
         line: STRING
      do
         !!line.make(4096)

         from
            std_input.read_line_in(line)
         until
            std_input.end_of_input
         loop
            if line.count < 43 then
               std_error.put_string("Bad line: ")
               std_error.put_string(line)
               std_error.put_new_line
            else
               line.remove_between(13, 42)
               std_output.put_string(line)
               std_output.put_new_line
            end

            std_input.read_line_in(line)
         end
      end

end

