--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: nwos_string.e,v $
-- Revision 1.6  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.5  2006/02/18 15:35:14  jsedwards
-- Changed name of "storage" to "to_string" so it makes more sense in clients.
--
-- Revision 1.4  2006/02/10 20:15:47  jsedwards
-- Create the storage string in read_from_stream.
--
-- Revision 1.3  2006/02/10 05:03:31  jsedwards
-- Added read from stream feature.
--
-- Revision 1.2  2006/02/05 17:40:30  jsedwards
-- Added outputting a class definition reference before the string.
--
-- Revision 1.1  2006/02/04 15:11:06  jsedwards
-- String with write to stream capability.
--

class NWOS_STRING

inherit NWOS_PREDEFINED_REFERENCES

creation copy_from_string, read_from_stream

feature

   to_string: STRING

   copy_from_string(string: STRING) is
      require
         1 <= string.count and string.count <= 255
      do
         !!to_string.copy(string)
      end

   write_to_stream(stream: BINARY_OUTPUT_STREAM) is
      do
         Class_string_ref.write_to_stream(stream)
         stream.put_8_bit_unsigned(to_string.count.to_unsigned)
         stream.put_string(to_string)
      end

   read_from_stream(stream: BINARY_INPUT_STREAM) is
      do
         temp_ref.read_from_stream(stream)

         if not temp_ref.is_equal(Class_string_ref) then
            std_error.put_string("NWOS_STRING.read_from_stream class mismatch%N")
            std_error.put_string("  expected: ")
            std_error.put_string(Class_string_ref.to_string)
            std_error.put_new_line
            std_error.put_string("  received: ")
            std_error.put_string(temp_ref.to_string)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         from
            stream.read_8_bit_unsigned
            !!to_string.make(stream.last_unsigned.to_integer)  -- make the string the exact size
         until
            to_string.count = to_string.capacity
         loop
            stream.read_character
            to_string.extend(stream.last_character)
         end
      end

   temp_ref: NWOS_REFERENCE is
      once
         !!Result.make(0U, 0U, 0U, 0U)
      end

end

