--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: nwos_session_log.e,v $
-- Revision 1.17  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.16  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.15  2006/02/18 20:48:32  jsedwards
-- Changed attributes to routines that make sure the object is loaded before
-- returning the object.
--
-- Revision 1.14  2006/02/18 16:47:36  jsedwards
-- Removed "to_string" because application name and revision are now regular
-- strings.
--
-- Revision 1.13  2006/02/18 15:37:06  jsedwards
-- Changed name of "storage" in NWOS_STRING class to "to_string" so it makes
-- more sense in the clients.
--
-- Revision 1.12  2006/02/11 18:46:44  jsedwards
-- Changed reference "load" calls to "get_object".
--
-- Revision 1.11  2006/02/11 04:52:09  jsedwards
-- Removed "once" class_ref and object_ref features and use a local variable
-- so that we don't have problems with recursion.
--
-- Revision 1.10  2006/02/10 20:25:41  jsedwards
-- Added code to store object into the objects_created array when they are
-- read in read_body_from_stream.  Also added print statements for debugging.
--
-- Revision 1.9  2006/02/10 14:52:24  jsedwards
-- Finished filling in read_body_from_stream and commented out invariant,
-- since if we do a make_unresolved there is no objects_created array.
--
-- Revision 1.8  2006/02/10 14:24:55  jsedwards
-- Started filling in read_body_from_stream feature, incomplete.
--
-- Revision 1.7  2006/02/10 13:55:34  jsedwards
-- Changed "load" in creation clause to "make_unresolved".
--
-- Revision 1.6  2006/02/10 02:09:21  jsedwards
-- Changed back to the previous way of setting the user and app through a
-- separate routine instead of passing them to make.  This allows the object
-- to be made, without creating those objects first (for the Big_Bang).
--
-- Revision 1.5  2006/02/09 14:07:48  jsedwards
-- Changed so that make sets all the attributes instead of calling a feature
-- to set each one separately.
--
-- Revision 1.4  2006/02/09 13:06:49  jsedwards
-- Added reference parameter to "initialize header" call and removed "next
-- identifier" feature that is now in nwos_header.  Changed to the new
-- method of doing the class defintion stuff, with the "class reference"
-- and "class revision".
--
-- Revision 1.3  2006/02/08 14:24:04  jsedwards
-- Added "load" to creation clause, a dummy read_body_from_stream routine,
-- and class reference to class definition "make" call.
--
-- Revision 1.2  2006/02/05 03:28:11  jsedwards
-- Added a reference to "grade" because the object grade references the log.
--
-- Revision 1.1  2006/02/05 01:26:20  jsedwards
-- Initial version.
--

class NWOS_SESSION_LOG

inherit NWOS_OBJECT

creation make, make_unresolved


feature

   application: NWOS_APPLICATION is
      do
         load_if_not_already
         Result := application_obj
      ensure
         Result /= Void
      end

   user: NWOS_USER is
      do
         load_if_not_already
         Result := user_obj
      ensure
         Result /= Void
      end

-- do we need this?  since we point to the grade in the header?
--   reference: NWOS_OBJECT_GRADE  -- this needs to be fixed up some other way for real objects

   objects_created: ARRAY[NWOS_OBJECT] is
      do
         load_if_not_already
         Result := objs_created_obj
      ensure
         Result /= Void
      end

feature

   add_entry(ref: NWOS_OBJECT) is
      do
         objects_created.add_last(ref)
      ensure
         objs_created_obj.fast_has(ref)
      end


feature {NONE}

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      require
         user_obj /= Void
         application_obj /= Void   -- had to have set the application
      local
         i: INTEGER
      do
         application_obj.class_definition.identifier.write_to_stream(stream)
         application_obj.identifier.write_to_stream(stream)

         user_obj.class_definition.identifier.write_to_stream(stream)
         user_obj.identifier.write_to_stream(stream)

--         reference.class_definition.identifier.write_to_stream(stream)
--         reference.identifier.write_to_stream(stream)

--         Void_reference.write_to_stream(stream)

         from
            i := objs_created_obj.lower
         variant
            objs_created_obj.upper - i
         until
            i > objs_created_obj.upper
         loop
            objs_created_obj.item(i).class_definition.identifier.write_to_stream(stream)
            objs_created_obj.item(i).identifier.write_to_stream(stream)
            i := i + 1
         end

         Void_reference.write_to_stream(stream)
      end

   read_body_from_stream(stream: BINARY_INPUT_STREAM) is
      local
         obj: NWOS_OBJECT
         class_ref: NWOS_REFERENCE
         object_ref: NWOS_REFERENCE
      do
         !!class_ref.make_from_stream(stream)
         !!object_ref.make_from_stream(stream)
         application_obj ?= object_ref.get_object(class_ref)

std_output.put_string("NWOS_SESSION_LOG.read_body_from_stream")
std_output.put_string("%N  application: ")
std_output.put_string(application_obj.name)
std_output.put_string("%N  revision: ")
std_output.put_string(application_obj.revision)
std_output.put_new_line

         !!class_ref.make_from_stream(stream)
         !!object_ref.make_from_stream(stream)
         user_obj ?= object_ref.get_object(class_ref)

std_output.put_string("%N  user: ")
std_output.put_string(user_obj.name)
std_output.put_new_line

         -- we could try to figure out the size from the object file size on disk

         !!objs_created_obj.with_capacity(512, 1)

         from
            !!class_ref.make_from_stream(stream)
         until
            class_ref.is_void
         loop
            !!object_ref.make_from_stream(stream)
            obj := object_ref.get_object(class_ref)
            objs_created_obj.add_last(obj)

            !!class_ref.make_from_stream(stream)
         end
      end

   make is
         -- for the big bang this object is created without any of the other info because the header just needs to
         -- have the reference to it.  then later the big_bang can fill in the user and app objects
      do
         !!objs_created_obj.with_capacity(512, 1)
         initialize_header(next_nwos_identifier)  -- do this last because it's going to call this again recursively
      end


feature  -- allow big bang to create these the first time

   make_app(app_name, app_rev: STRING) is
      do
         !!application_obj.make(app_name, app_rev)
      end

   make_user(username: STRING) is
      do
         !!user_obj.make(username)
         user_obj.add_reference(Current)
      end


feature {NONE}  -- real storage

   application_obj: NWOS_APPLICATION

   user_obj: NWOS_USER

   objs_created_obj: ARRAY[NWOS_OBJECT]


feature {NONE}  -- once again the kludgy class definition stuff

   class_revision: STRING is
      once
         !!Result.copy("$Revision: 1.17 $")
         Result.remove_prefix("$Revision: ")
         Result.remove_suffix(" $")
      end

   class_reference: NWOS_REFERENCE is
      do
         Result := Class_session_log_ref
      end


--invariant

--   objs_created_obj /= Void

end

