--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: nwos_root.e,v $
-- Revision 1.12  2006/02/19 19:07:06  jsedwards
-- Wrapped debug print statement when object read in, in "debug" so they only
-- print when debug is passed to compiler.
--
-- Revision 1.11  2006/02/19 18:09:03  jsedwards
-- Changed attributes to routines that make sure this object is loaded before
-- returning any values.
--
-- Revision 1.10  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.9  2006/02/11 15:27:32  jsedwards
-- Changed to create reference objects and call reference "get_object"
-- instead of "load".
--
-- Revision 1.8  2006/02/10 13:55:34  jsedwards
-- Changed "load" in creation clause to "make_unresolved".
--
-- Revision 1.7  2006/02/10 05:02:45  jsedwards
-- Filled in read from stream routine.
--
-- Revision 1.6  2006/02/09 13:14:50  jsedwards
-- Removed code in "make" that tried to decide if we were going to "make"
-- the root object or if we were going to read it from disk.  Also changed
-- to the new method of doing the class defintion stuff, with the "class
-- reference" and "class revision".
--
-- Revision 1.5  2006/02/08 14:28:49  jsedwards
-- Removed class_definition_object stuff.
--
-- Revision 1.4  2006/02/07 14:48:24  jsedwards
-- Changed to pass reference to initialize_header and eliminated
-- next_identifier.
--
-- Revision 1.3  2006/02/07 14:24:25  jsedwards
-- Changed to get class definition from class definition object.
--
-- Revision 1.2  2006/02/07 14:18:42  jsedwards
-- Changed to adjust accordingly if root object already exists and load it in
-- if it does, otherwise create new.
--
-- Revision 1.1  2006/02/05 21:58:37  jsedwards
-- Initial version.
--


class NWOS_ROOT

    -- this object is the root that points to the entry point (for now just
    -- the class definition class).

inherit NWOS_OBJECT

creation make, make_unresolved


feature

   class_definition_object: NWOS_CLASS_DEFINITION is
      do
         load_if_not_already
         Result := class_def_object_obj
      ensure
         Result /= Void
      end


feature {NONE}

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      do
         class_def_object_obj.class_definition.identifier.write_to_stream(stream)
         class_def_object_obj.identifier.write_to_stream(stream)
      end

   read_body_from_stream(stream: BINARY_INPUT_STREAM) is
      local
         class_def_ref: NWOS_REFERENCE
         class_obj_ref: NWOS_REFERENCE
      do
debug
std_output.put_string("NWOS_ROOT.read_body_from_stream%N")
end
         !!class_def_ref.make_from_stream(stream)
debug
std_output.put_string("  class_def_ref: ")
std_output.put_string(class_def_ref.to_string)
std_output.put_new_line
end
         if not class_def_ref.is_equal(Class_class_definition_ref) then
            std_error.put_string("NWOS_STRING.read_from_stream class mismatch%N")
            std_error.put_string("  expected: ")
            std_error.put_string(Class_class_definition_ref.to_string)
            std_error.put_new_line
            std_error.put_string("  received: ")
            std_error.put_string(class_def_ref.to_string)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end
         
         !!class_obj_ref.make_from_stream(stream)
debug
std_output.put_string("  class_obj_ref: ")
std_output.put_string(class_obj_ref.to_string)
std_output.put_new_line
end
         class_def_object_obj ?= class_obj_ref.get_object(class_def_ref)

         if class_def_object_obj = Void then
            std_error.put_string("NWOS_STRING.read_from_stream: could not read class definition object%N")
            std_error.put_string("  class_definition: ")
            std_error.put_string(class_def_ref.to_string)
            std_error.put_new_line
            std_error.put_string("  class_def_object: ")
            std_error.put_string(class_obj_ref.to_string)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end
      end

   make is
      do
         initialize_header(Root_ref)
         class_def_object_obj ?= Class_class_definition_ref.object

         check
            class_def_object_obj /= Void
         end
      end


feature {NONE}  -- actual storage

   class_def_object_obj: like class_definition_object


--   class_definition_ref: NWOS_REFERENCE

feature {NONE}  -- once again the kludgy class definition stuff

   class_revision: STRING is
      once
         !!Result.copy("$Revision: 1.12 $")
         Result.remove_prefix("$Revision: ")
         Result.remove_suffix(" $")
      end

   class_reference: NWOS_REFERENCE is
      do
         Result := Class_root_ref
      end

end

