--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: nwos_procurement.e,v $
-- Revision 1.7  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.6  2006/02/19 18:16:55  jsedwards
-- Changed attributes to routines that make sure the current object is loaded
-- before returning anything.
--
-- Revision 1.5  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.4  2006/02/17 14:09:11  jsedwards
-- Fixed with_capacity calls for "array" instead of "fixed_array".
--
-- Revision 1.3  2006/02/16 02:58:37  jsedwards
-- Added code to put the command into the commands array.
--
-- Revision 1.2  2006/02/15 14:26:40  jsedwards
-- Filled in stuff for this class (eliminating stuff left over from copy).
--
-- Revision 1.1  2006/02/14 14:26:46  jsedwards
-- Initial vesion, incomplete.
--

class NWOS_PROCUREMENT

inherit NWOS_OBJECT

creation make, make_unresolved


feature

   commands: ARRAY[NWOS_STRING] is
      do
         load_if_not_already
         Result := commands_obj
      ensure
         Result /= Void
      end

   references: ARRAY[NWOS_OBJECT] is
      do
         load_if_not_already
         Result := references_obj
      ensure
         Result /= Void
      end


feature

   add_command(path: STRING) is
      local
         command: NWOS_STRING
      do
         !!command.copy_from_string(path)
         commands.add_last(command)
      end

   add_reference(ref: NWOS_OBJECT) is
      do
         references.add_last(ref)
      end


feature {NONE}

   make is
      do
         initialize_header(next_nwos_identifier)
         !!commands_obj.with_capacity(5, 1)
         !!references_obj.with_capacity(8, 1)
      end

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      local
         i: INTEGER
      do
         check
            commands_obj.count > 0
         end

         from
            i := commands_obj.lower
         until
            i > commands_obj.upper
         loop
            commands_obj.item(i).write_to_stream(stream)

            i := i + 1
         end

         from
            i := references_obj.lower
         until
            i > references_obj.upper
         loop
            references_obj.item(i).class_definition.identifier.write_to_stream(stream)
            references_obj.item(i).identifier.write_to_stream(stream)
            i := i + 1
         end

         Void_reference.write_to_stream(stream)
      end

   read_body_from_stream(stream: BINARY_INPUT_STREAM) is
      local
         obj: NWOS_OBJECT
         class_ref: NWOS_REFERENCE
         object_ref: NWOS_REFERENCE
         command: NWOS_STRING
      do
         !!commands_obj.with_capacity(5, 1)

         from
            !!class_ref.make_from_stream(stream)
         until
            not class_ref.is_equal(Class_string_ref)
         loop
            !!command.read_from_stream(stream)
            commands_obj.add_last(command)

            class_ref.read_from_stream(stream)
         end

         if commands_obj.count = 0 then
            std_error.put_string("NWOS_PROCUREMENT.read_body_from_stream no commands read%N")
            die_with_code(exit_failure_code)
         end

         !!references_obj.with_capacity(8, 1)

         from
            -- use the class_ref read in above that wasn't a string
         until
            class_ref.is_void
         loop
            !!object_ref.make_from_stream(stream)

std_output.put_string("NWOS_PROCUREMENT.read_body_from_stream")
std_output.put_string("%N  class: ")
std_output.put_string(class_ref.to_string)
std_output.put_string("%N  object: ")
std_output.put_string(object_ref.to_string)
std_output.put_new_line

            obj := object_ref.get_object(class_ref)
            references_obj.add_last(obj)

            !!class_ref.make_from_stream(stream)
         end
      end


feature {NONE}  -- actual storage

   commands_obj: like commands

   references_obj: like references


feature {NONE}  -- once again the kludgy class definition stuff

   class_revision: STRING is
      once
         !!Result.copy("$Revision: 1.7 $")
         Result.remove_prefix("$Revision: ")
         Result.remove_suffix(" $")
      end

   class_reference: NWOS_REFERENCE is
      do
         Result := Class_procurement_ref
      end

end

