#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2016    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF -s"\n\t|" old new > ./output/res1
$NUMDIFF -s"\n\t|" -P old new > ./output/res2
$NUMDIFF -s"\n\t|" -N old new > ./output/res3
$NUMDIFF -s"\n\t|" -a 2.0e-8 -r 2.0e-6 -P old new > ./output/res4
$NUMDIFF -s"\n\t|" -a 2.0e-8 -r 2.0e-6 -N old new > ./output/res5
$NUMDIFF -s"\n\t|" -a 2.0e-8 -r 2.0e-6 -2 -P old new > ./output/res6
$NUMDIFF -s"\n\t|" -a 2.0e-8 -r 2.0e-6 -2 -N old new > ./output/res7

LIST="res1 res2 res3 res4 res5 res6 res7"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done
