#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2016    Ivano Primi  <ivprimi@libero.it>    
#
#  Copying and distribution of this file, with or without modification,
#  are permitted in any medium without royalty provided the copyright
#  notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF -s '| \t\n' -O -z 2- original modified > ./output/O_z2  # Ok
$NUMDIFF -s '| \t\n' -f -O -z 2- original modified > ./output/f_O_z2  # Ok
$NUMDIFF -s '| \t\n' -O -f -z 2- original modified > ./output/O_f_z2  # Ok
$NUMDIFF -X 2:2 -O -z 1:2- -z 2:3- original modified > ./output/X2:2_O_z1:from2_z2:from3 #Ok
$NUMDIFF -V -X 2:2 -O -z 1:2- -z 2:3- original modified > ./output/V_X2:2_O_z1:from2_z2:from3 # Ok
$NUMDIFF -b -X 2:2 -O -z 1:2- -z 2:3- original modified > ./output/b_X2:2_O_z1:from2_z2:from3 # Ok
$NUMDIFF -X 2:2 -O -b -V -z 1:2- -z 2:3- original modified > ./output/X2:2_O_b_V_z1:from2_z2:from3 #Ok
$NUMDIFF -q -X 2:2 -O -z 1:2- -z 2:3- original modified > ./output/q_X2:2_O_z1:from2_z2:from3 # Ok
$NUMDIFF -S -X 2:2 -O -z 1:2- -z 2:3- original modified > ./output/S_X2:2_O_z1:from2_z2:from3 # Ok
$NUMDIFF -a 0.006 -X 2:2 -O -z 1:2- -z 2:3- original modified > ./output/a_X2:2_O_z1:from2_z2:from3 #Ok
$NUMDIFF -r 0.005 -X 2:2 -O -z 1:2- -z 2:3- original modified > ./output/r_X2:2_O_z1:from2_z2:from3 # Ok
$NUMDIFF -a 0.006 -r 0.005 -X 2:2 -O -z 1:2- -z 2:3- original modified > ./output/a_r_X2:2_O_z1:from2_z2:from3 # Ok
$NUMDIFF -2 -a 0.006 -r 0.005 -X 2:2 -O -z 1:2- -z 2:3- original modified > ./output/2_a_r_X2:2_O_z1:from2_z2:from3 #Ok

LIST="2_a_r_X2:2_O_z1:from2_z2:from3 a_r_X2:2_O_z1:from2_z2:from3 a_X2:2_O_z1:from2_z2:from3 b_X2:2_O_z1:from2_z2:from3 f_O_z2 O_f_z2 O_z2 q_X2:2_O_z1:from2_z2:from3 r_X2:2_O_z1:from2_z2:from3 S_X2:2_O_z1:from2_z2:from3 V_X2:2_O_z1:from2_z2:from3 X2:2_O_b_V_z1:from2_z2:from3 X2:2_O_z1:from2_z2:from3"


for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done
