#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2013    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3
#LESS=less
#DIFF=diff
#NUMDIFF=numdiff

$NUMDIFF -S file1 file2 > ./output/Res1
$NUMDIFF -S -a 0.5 file1 file2 > ./output/Res2
$NUMDIFF -S -r 2.5e-2 file1 file2 > ./output/Res3
$NUMDIFF -S -a 0.5 -r 2.5e-2 file1 file2 > ./output/Res4
$NUMDIFF -S -a 0.5 -r 2.5e-2 -2 file1 file2 > ./output/Res5

$NUMDIFF -S -V file1 file2 > ./output/Res1V
$NUMDIFF -S -V -a 0.5 file1 file2 > ./output/Res2V
$NUMDIFF -S -V -r 2.5e-2 file1 file2 > ./output/Res3V
$NUMDIFF -S -V -a 0.5 -r 2.5e-2 file1 file2 > ./output/Res4V
$NUMDIFF -S -V -a 0.5 -r 2.5e-2 -2 file1 file2 > ./output/Res5V

$NUMDIFF -S -U file1 file2 > ./output/Res1D
$NUMDIFF -S -U -a 0.5 file1 file2 > ./output/Res2D
$NUMDIFF -S -U -r 2.5e-2 file1 file2 > ./output/Res3D
$NUMDIFF -S -U -a 0.5 -r 2.5e-2 file1 file2 > ./output/Res4D
$NUMDIFF -S -U -a 0.5 -r 2.5e-2 -2 file1 file2 > ./output/Res5D

$NUMDIFF -S -E file1 file2 > ./output/Res1E
$NUMDIFF -S -E -a 0.5 file1 file2 > ./output/Res2E
$NUMDIFF -S -E -r 2.5e-2 file1 file2 > ./output/Res3E
$NUMDIFF -S -E -a 0.5 -r 2.5e-2 file1 file2 > ./output/Res4E
$NUMDIFF -S -E -a 0.5 -r 2.5e-2 -2 file1 file2 > ./output/Res5E

$NUMDIFF -S -P file1 file2 > ./output/Res1P
$NUMDIFF -S -P -a 0.5 file1 file2 > ./output/Res2P
$NUMDIFF -S -P -r 2.5e-2 file1 file2 > ./output/Res3P
$NUMDIFF -S -P -a 0.5 -r 2.5e-2 file1 file2 > ./output/Res4P
$NUMDIFF -S -P -a 0.5 -r 2.5e-2 -2 file1 file2 > ./output/Res5P

$NUMDIFF -S -N file1 file2 > ./output/Res1N
$NUMDIFF -S -N -a 0.5 file1 file2 > ./output/Res2N
$NUMDIFF -S -N -r 2.5e-2 file1 file2 > ./output/Res3N
$NUMDIFF -S -N -a 0.5 -r 2.5e-2 file1 file2 > ./output/Res4N
$NUMDIFF -S -N -a 0.5 -r 2.5e-2 -2 file1 file2 > ./output/Res5N

$NUMDIFF -S -I file1 file2 > ./output/Res1I
$NUMDIFF -S -I -a 0.5 file1 file2 > ./output/Res2I
$NUMDIFF -S -I -r 2.5e-2 file1 file2 > ./output/Res3I
$NUMDIFF -S -I -a 0.5 -r 2.5e-2 file1 file2 > ./output/Res4I
$NUMDIFF -S -I -a 0.5 -r 2.5e-2 -2 file1 file2 > ./output/Res5I

$NUMDIFF -S -U -I file1 file2 > ./output/Res1DI
$NUMDIFF -S -U -I -a 0.5 file1 file2 > ./output/Res2DI
$NUMDIFF -S -U -I -r 2.5e-2 file1 file2 > ./output/Res3DI
$NUMDIFF -S -U -I -a 0.5 -r 2.5e-2 file1 file2 > ./output/Res4DI
$NUMDIFF -S -U -I -a 0.5 -r 2.5e-2 -2 file1 file2 > ./output/Res5DI

$NUMDIFF -S -q file1 file2 > ./output/Res1q
$NUMDIFF -S -q -a 0.5 file1 file2 > ./output/Res2q
$NUMDIFF -S -q -r 2.5e-2 file1 file2 > ./output/Res3q
$NUMDIFF -S -q -a 0.5 -r 2.5e-2 file1 file2 > ./output/Res4q
$NUMDIFF -S -q -a 0.5 -r 2.5e-2 -2 file1 file2 > ./output/Res5q


LIST="Res1 Res2 Res3 Res4 Res5 Res1V Res2V Res3V Res4V Res5V Res1D Res2D Res3D Res4D Res5D Res1E Res2E Res3E Res4E Res5E Res1P Res2P Res3P Res4P Res5P Res1N Res2N Res3N Res4N Res5N Res1I Res2I Res3I Res4I Res5I Res1DI Res2DI Res3DI Res4DI Res5DI Res1q Res2q Res3q Res4q Res5q"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"

