#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2013    Ivano Primi  <ivprimi@libero.it>    
#
#  Copying and distribution of this file, with or without modification,
#  are permitted in any medium without royalty provided the copyright
#  notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF -V -c EUR currency1 currency2 > ./output/Vcmp1
$NUMDIFF -V -z @ -c EUR currency1 currency3 > ./output/Vcmp2
$NUMDIFF -O -z @ -c EUR currency1 currency3 > ./output/Ocmp2
$NUMDIFF -c € greece greece2 > ./output/cE_greece
$NUMDIFF -c € -V  greece greece2 > ./output/VcE_greece
$NUMDIFF -c 1:€ -c 2:EUR_ italy italy2 > ./output/c1E_2EUR__italy
$NUMDIFF -V -c 1:€ -c 2:EUR_ italy italy2 > ./output/Vc1E_2EUR__italy
$NUMDIFF -V -c 1:¥ -c "2:JPY " -s "2:_\n" -X 2:4 japan japan2 > ./output/outV_japan
$NUMDIFF -c 1:¥ -c "2:JPY " -s "2:_\n" -X 2:4 japan japan2 > ./output/out_japan
$NUMDIFF -V -z @ -X 2 -X 4 -X 6 -c 1:$ -c 2:USD usa usa2 > ./output/outV_usa
$NUMDIFF -z @ -X 2 -X 4 -X 6 -c 1:$ -c 2:USD usa usa2 > ./output/out_usa
$NUMDIFF -c € -V greece italy > ./output/greece_vs_italy
$NUMDIFF -c 1:$ -c 2:€ -V usa italy > ./output/usa_vs_italy
$NUMDIFF -c EUR -c € -V greece italy > ./output/greece_vs_italy_2
$NUMDIFF -c 1:USD -c 2:EUR -c 1:$ -c 2:€ -V usa italy > ./output/usa_vs_italy_2
$NUMDIFF -c "¥ " -s "_\n" -z @ -O japan3 big_confusion > ./output/Ofinal
$NUMDIFF -c "¥ " -s "_\n" -z @ -V japan3 big_confusion > ./output/Vfinal
$NUMDIFF -c "¥ " -s "_\n" -z @ -V -a 0.00999999 japan3 big_confusion > ./output/Vafinal
$NUMDIFF -c "¥ " -s "_\n" -z @ -V -a 0.01 japan3 big_confusion > ./output/Va_final
$NUMDIFF -c "¥ " -s "_\n" -z @ -V -a 0.00999999 -r 5.0e-6 japan3 big_confusion > ./output/Varfinal
$NUMDIFF -c "¥ " -s "_\n" -z @ -V -a 0.01 -r 5.0e-6 -2 japan3 big_confusion > ./output/Va_r2final
$NUMDIFF complex complex2 > ./output/no_issue
$NUMDIFF -c 1:$ complex complex2 > ./output/no_issue_2
$NUMDIFF -c 2:$ complex complex2 > ./output/known_issue
$NUMDIFF -c $ complex complex2 > ./output/known_issue_2

LIST="c1E_2EUR__italy cE_greece greece_vs_italy greece_vs_italy_2 known_issue known_issue_2 no_issue no_issue_2 Ocmp2 Ofinal out_japan out_usa outV_japan outV_usa usa_vs_italy usa_vs_italy_2 Vafinal Va_final Va_r2final Varfinal Vc1E_2EUR__italy VcE_greece Vcmp1 Vcmp2 Vfinal"

for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"
