#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2013    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF -f60 -z 2- -T short1 short2 > ./output/fz2_short12
$NUMDIFF -f60 -z 2- -T decimal scientific > ./output/fz2_decsci
$NUMDIFF -f60 -z 2- -T sc1 sc2 > ./output/fz2_sc12
$NUMDIFF -f60 -z 3- -T Scnot1 Scnot2 > ./output/fz3_Scnot12
$NUMDIFF -f60 -z 3- -T Scnot1 Scnot3 > ./output/fz3_Scnot13

LIST="fz2_short12 fz2_decsci fz2_sc12 fz3_Scnot12 fz3_Scnot13"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"

