#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2013    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -f list1 list2 > ./output/X1_58X2_37_f0list12
$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -V list1 list2 > ./output/X1_58X2_37_Vlist12
$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -f list3 list2 > ./output/X1_58X2_37_f0list32
$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -V list3 list2 > ./output/X1_58X2_37_Vlist32
$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -f list4 list2 > ./output/X1_58X2_37_f0list42
$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -V list4 list2 > ./output/X1_58X2_37_Vlist42
$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -f list4 list2corr > ./output/X1_58X2_37_f0list42c
$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -V list4 list2corr > ./output/X1_58X2_37_Vlist42c
$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -V -P -S list4 list2corr > ./output/X1_58X2_37_V_P_Slist42c
$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -V -N -S list4 list2corr > ./output/X1_58X2_37_V_N_Slist42c
$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -V -a 2.0e3 -S list4 list2corr  > ./output/X1_58X2_37_V_a_Slist42c
$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -V -r 5.0e-1 -S list4 list2corr  > ./output/X1_58X2_37_V_r_Slist42c
$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -V -a 2.0e3 -r 5.0e-1 -S list4 list2corr  > ./output/X1_58X2_37_V_a_r_Slist42c
$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -V -a 2.0e3 -r 5.0e-1 -2 -S list4 list2corr  > ./output/X1_58X2_37_V_a_r_2_Slist42c
$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -V -a 2.0e3 -r 5.0e-1 -2 -E -S list4 list2corr  > ./output/X1_58X2_37_V_a_r_2_E_Slist42c
$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -V -a 2.0e3 -r 5.0e-1 -2 -E -b -S list4 list2corr  > ./output/X1_58X2_37_V_a_r_2_E_b_Slist42c
$NUMDIFF -s ' $|\t\n' -n '<-' -p '>+' -d ._ -t ,: -g 32 -X 1:5 -X 1:8 -X 2:3 -X 2:7 -z 1:@ -z 2:@ -V -a 2.0e3 -r 5.0e-1 -2 -b -S list4 list2corr  > ./output/X1_58X2_37_V_a_r_2_b_Slist42c

LIST="X1_58X2_37_f0list12 X1_58X2_37_Vlist12 X1_58X2_37_f0list32 X1_58X2_37_Vlist32 X1_58X2_37_f0list42 X1_58X2_37_Vlist42 X1_58X2_37_f0list42c X1_58X2_37_Vlist42c X1_58X2_37_V_P_Slist42c X1_58X2_37_V_N_Slist42c X1_58X2_37_V_a_Slist42c X1_58X2_37_V_r_Slist42c X1_58X2_37_V_a_r_Slist42c X1_58X2_37_V_a_r_2_Slist42c X1_58X2_37_V_a_r_2_E_Slist42c X1_58X2_37_V_a_r_2_E_b_Slist42c X1_58X2_37_V_a_r_2_b_Slist42c"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"

