#include<stdio.h>
#include<stdlib.h>

#define FIRST_YEAR 1970
#define  LAST_YEAR 2030

enum month {
  Jan,   Feb,   Mar,   Apr,
  May,   Jun,   Jul,   Aug,
  Sep,   Oct,   Nov,   Dec
};

const char* mabbr[12] = {
  "Jan",   "Feb",   "Mar",   "Apr",
  "May",   "Jun",   "Jul",   "Aug",
  "Sep",   "Oct",   "Nov",   "Dec"
};

double nlist[12] = {
  -5000.00,   5500.00,   6000.00,   5000.00,
  4000.00,   3000.00,   5000.00,   7000.00,
  9000.00,   8000.00,   7000.00,   -6000.00
};

double pert[12] = {
  -0.20, -0.15, -0.10, -0.05, 
  0.00, 0.05, 0.10, 0.15,
  0.20, 0.25, 0.30, 0.35
};

void print_year (int year, double* pert)
{
  if (year < FIRST_YEAR || year > LAST_YEAR)
    {
      fprintf (stderr, "year must lie in the range %d - %d\n", FIRST_YEAR, LAST_YEAR);
      exit (EXIT_FAILURE);
    }
  else
    {
      int i, i0 = (year - FIRST_YEAR) % 12;

      printf ("%4d | \t", year); 
      if (!pert)
	{
	  for (i = Jan; i <= Dec;  i++)
	    printf ("%+9.2f  ", nlist[(i0 + i)%12]);
	}
      else
	{
	  for (i = Jan; i <= Dec;  i++)
	    printf ("%+9.2f  ", nlist[(i0 + i)%12] * (1.0+pert[(i0 + i)%12]));
	}
      putchar ('\n');
    }
}

void print_header (void)
{
  enum month M;
  int i;

  printf ("     | \t");
  for (M = Jan; M <= Dec; M++)
    printf ("   %s     ", mabbr[M]);
  printf ("\n-----+-------------");
  for (i = 0; i < 120; putchar('-'), i++);
  puts ("\n     |");
}

void print_register (double* pert)
{
  int year;

  print_header();
  for (year = FIRST_YEAR; year <= LAST_YEAR; print_year(year, pert), year++);
}

int main (void)
{
  print_register(NULL);
  puts ("\n\n");
  print_register(pert);
  return 0;
}

