/*
    Copyright (C) 2005,2006  Ivano Primi  <ivprimi@libero.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include<stdio.h>
#include"number.h"

extern void out_char(int ch);
extern int bc_a2num (bc_num *num, const char *str, char **endptr, int scale);
extern void bc_print_num (bc_num num, void (* out_char)(int), int prec);

int main (void)
{
  char buffer[1024];
  char *s;
  bc_num x;

  bc_init_numbers();
  bc_init_num (&x);
  do
    {
      printf ("Give me a number (Ctrl+D to terminate):\n");
      s = fgets (buffer, 1024, stdin);
      if ((s))
	{
	  for (s = buffer; *s != '\0' && *s != '\n'; s++);
	  *s = '\0';
	  bc_a2num (&x, buffer, &s, 50);
	  printf ("x = ");
	  bc_out_num (x, 10, out_char, 0);
	  printf (", i.e. ");
	  bc_print_num (x, out_char, 6);  
	  printf ("\ntail: \"%s\"\n\n", s);
	}
    } while ((s));
  bc_end();
  return 0;
}
