/*
    Numdiff - compare putatively similar files, 
    ignoring small numeric differences
    Copyright (C) 2005,2006  Ivano Primi  <ivprimi@libero.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include"numdiff.h"

#ifdef _DMALLOC_
#include <dmalloc.h> /* Useful only for the debugging */
#endif

int open_files (const char* file1, const char* file2, FILE** fpp1, FILE** fpp2)
{
  /* Open file1 and file2 */
  if ( strcmp (file1, file2) == 0 )
    {
      fputs (_("\n***  Cannot compare a file with itself\n\n"), stderr);
      return -1;
    }
  if ( strcmp (file1, "-") == 0 )
    *fpp1 = stdin;
  else
    {
      if ( !(*fpp1 = fopen (file1, "r")) )
	{
	  fprintf (stderr, _("\n***  Cannot open file \"%s\"\n"), file1);
	  return -1;
	}	
    }
  if ( strcmp (file2, "-") == 0 )
    *fpp2 = stdin;
  else
    {
      if ( !(*fpp2 = fopen (file2, "r")) )
	{
	  fprintf (stderr, _("\n***  Cannot open file \"%s\"\n"), file2);
	  return -1;
	}	
    }
  return 0;
} 

char* read_line (FILE* pf, int* errcode)
{
  char buffer[BUFF_SIZE];
  char *ptr, *line = NULL;
  size_t lline = 0;

  while ((ptr = fgets (buffer, BUFF_SIZE,pf)))
    {
      lline += strlen (buffer);
      if (!line)
	ptr = (char*) calloc (lline + 1, sizeof(char));
      else
	ptr = (char*) realloc ((void*)line, (lline + 1) * sizeof(char));
      if (!ptr)
	{
	  if ((line))
	    free ((void*)line);
	  *errcode = OUT_OF_MEMORY;
	  return NULL;
	}
      else
	{
	  line = ptr;
	  strcat (line, buffer);
	}
      if (lline > 0 && line[lline-1] == '\n')
	break;
    }
  if (!ptr)
    *errcode = (ferror(pf)) ? READING_ERROR : EOF_REACHED; 
  else
    *errcode = OK;
  return line;
} 

void print_head (const char* str, size_t length)
{
  const char* t;

  for (t = str; t - str < length; putchar(*t), t++);
}

void print_ws (unsigned n)
{
  while ((n--))
    putchar (' ');
}

#ifdef __DEBUG__

void Eprint_head (const char* str, size_t length)
{
  const char* t;

  for (t = str; t - str < length; fputc(*t, stderr), t++);
}

void Eprint_nonl (const char* str)
{
  const char* t;

  for (t = str; *t != '\0' && *t != '\n'; fputc(*t, stderr), t++);
}

#endif /* __DEBUG__ */

