<?php
/***************************************************************************
 *                                 ldap.php
 *                            -------------------
 *   begin                : Dec 12, 2005
 *   copyright            : (C) 2001 William Wong
 *
 *   Id: ldap.php,v 1.00 12/12/2005 Initial version
 *
 *
 ***************************************************************************/

/***************************************************************************
 *   Website: savannah.nongnu.org/projects/nukeldap
 *
 *   As always, make a backup before messing with anything. All code
 *   release by me is considered sample code only. It may be fully
 *   functual, but you use it at your own risk, if you break it,
 *   you get to fix it too. No waranty is given or implied.
 *
 *   All original header code and copyright messages will be maintained
 *   to give credit where credit is due. If you modify this, the only requirement is
 *   that you also maintain all original copyright messages. All my work is released
 *   under the GNU GENERAL PUBLIC LICENSE. Please see the README for more information.
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

$ldap_var_arrays=array('objectclass','default');
$ldap_vars=array('enable','host','port','version','binddn','password'
		,'base','ldapID','ldapPassword'
		,'useNuke','noAdd','noDel','noMod','createNew'
		,'exec','addscript','delscript','modscript');

function ldap_get_variables () {
  global $prefix,$db,$ldap_var_arrays;
  foreach ($db->sql_fetchrowset($db->sql_query("SELECT * FROM ".$prefix."_ldap")) as $row){
    $name=$row['name'];
    if(in_array($name,$ldap_var_arrays)) 
      $result[$row['name']][]=$row['value'];
    else
      $result[$name]=$row['value'];
  }
  return $result;
}

function ldap_insert_var($name,$value) {
  global $prefix,$db;
  $db->sql_query("INSERT INTO ".$prefix."_ldap (name,value) VALUES(\"$name\",\"$value\")");
}

function ldap_set_variables ($ldap) {
  global $prefix,$db,$ldap_var_arrays;
  $db->sql_query("DELETE FROM ".$prefix."_ldap");

  foreach ($ldap as $name => $value) {
    if(in_array($name,$ldap_var_arrays)){
      foreach($value as $v){
        if($v!="")
          ldap_insert_var($name,$v);    
      }
    } else {
      ldap_insert_var($name,$value);
    }
  }
}

function ldap_do_exec($ldap,$cmd){
	if(!$cmd OR $cmd=="") {
		return true;
	}

	passthru(escapeshellcmd($ldap['exec']." $cmd"),$result);
	return $result;
}

function ldap_do_script($ldap,$entry,$name,$password=""){
	return ldap_do_exec($ldap,ldap_preg_replace($ldap[$entry],$name,$password));
}

function ldap_do_connect($ldap){
	$ds=ldap_connect($ldap['host'],$ldap['port']);
	$version = $ldap['version'];
	if($ds && ($version!="")) {
		ldap_set_option($ds,LDAP_OPT_PROTOCOL_VERSION,$version);
	}
	return $ds;
}

function ldap_do_bind($ds,$ldap){
	return ldap_bind($ds,$ldap['binddn'],$ldap['password']);
}

function ldap_check_user($ldap,$name){
	$result=false; 
	$ds=ldap_do_connect($ldap);
	if($ds && ldap_do_bind($ds,$ldap)){
		$sr=ldap_search($ds,$ldap['base'],$ldap['ldapID'].'='.$name,array($ldap['ldapPassword']));
		if($sr && (ldap_count_entries($ds,$sr)==1)) {
			$result=true;
		}
		ldap_close($ds);
	}
	return $result;
}

function ldap_preg_replace($fields,$name,$password=""){
	return preg_replace("/{PASSWORD}/",$password,preg_replace("/{NAME}/",$name,$fields));
}

function ldap_create_user($ldap,$name,$password){
	if (count($ldap['objectclass'])==0) {
		return true; // user LDAP entry created by other means
	}
	$result=false; 
	$ds=ldap_do_connect($ldap);
	if($ds && ldap_do_bind($ds,$ldap)){
		$fields[$ldap['ldapID']]=$name;
		$fields[$ldap['ldapPassword']]=$password;

		foreach ($ldap['default'] as $def) {
			$split=preg_split("/:/",$def);
			if(count($split)==2) {
				$fields[$split[0]]=$split[1];
			}
		}

		//perform substitution
		$fields=ldap_preg_replace($fields,$name,$password);

		// acc objectclasses
		foreach ($ldap['objectclass'] as $oc) {
			$oc=preg_replace("/\s/","",$oc); // strip blanks
			if ($oc!=""){
				$fields['objectclass'][]=$oc;
			}
		}

		$dn=$ldap['ldapID'].'='.$name.','.$ldap['base'];
		$result=ldap_add($ds,$dn,$fields);
		ldap_close($ds);
	}
	return $result;
}

function ldap_delete_user($ldap,$name){
	$result=false; 
	$ds=ldap_do_connect($ldap);
	if($ds && ldap_do_bind($ds,$ldap)){
		$dn=$ldap['ldapID'].'='.$name.','.$ldap['base'];
		$result=ldap_delete($ds,$dn);
		ldap_close($ds);
	}
	return $result;
}


function ldap_fn_disabled($ldap){
	return $ldap['enable']!='on';
}


// Routines used in modules/Your_Account

function ldap_fn_update_password($name,$password) {
	$ldap=ldap_get_variables();

	if (ldap_fn_disabled($ldap))
		return false ;

	if ($ldap['noMod']=='on')
		return ldap_do_script($ldap,'modscript',$name,$password); 

	$result=false; 
	$ds=ldap_do_connect($ldap);
	if($ds && ldap_do_bind($ds,$ldap)){
		$dn=$ldap['ldapID'].'='.$name.','.$ldap['base'];
		$result=ldap_modify($ds,$dn,array($ldap['ldapPassword']=>$password));
		ldap_do_script($ldap,'modscript',$name,$password);
		ldap_close($ds);
	}
	return $result;
}

function ldap_fn_check_user($name){
	global $prefix,$db;

	$ldap=ldap_get_variables();
	if (ldap_fn_disabled($ldap))
		return true ;

	if(ldap_check_user($ldap,$name)) {
		// name in LDAP
		$result=$db->sql_query("SELECT * FROM ".$prefix."_users WHERE username='$name'");
		if($result && ($db->sql_numrows($result)==0)){
			// add new SQL entry with dummy password in case LDAP is disabled
			$db->sql_query("INSERT INTO ".$prefix
				."_users (username,user_password) VALUES ('$name','xa"
				.rand(10000000,99999999)."px".rand(10000000,999999999)."tna')");
		}
		return true;
	}
	return false;
}

function ldap_fn_add_user($name,$password){
	$ldap=ldap_get_variables();
	if (ldap_fn_disabled($ldap))
		return true ;

	$result = ldap_do_script($ldap,'addscript',$name,$password);
	return $ldap['noAdd']=='on'? $result : ldap_create_user($ldap,$name,$password);
}

function ldap_fn_delete_user($name){
	$ldap=ldap_get_variables();
	if (ldap_fn_disabled($ldap))
		return true ;

	$result = ldap_do_script($ldap,'delscript',$name);
	return $ldap['noDel']=='on'? $result : ldap_delete_user($ldap,$name);
}

function ldap_fn_check_password($name,$password) {
	global $prefix,$db;
	$ldap=ldap_get_variables();
	if (ldap_fn_disabled($ldap))
		return true ;

	$newpass=md5($password);
	$ds=ldap_do_connect($ldap);
	if ($ds) {
		if (ldap_bind($ds,$ldap['ldapID'].'='.$name.','.$ldap['base'],$password)) {
			// Password matchesi LDAP user, update SQL database
			$db->sql_query("UPDATE ".$prefix."_users set user_password='$newpass' WHERE usename='$name'");
			ldap_close($ds);
		} elseif ($ldap['useNuke']!='on') {
			// See if PHPNuke local users are allowed
			$result=$db->sql_query("SELECT * FROM ".$prefix."_users WHERE username='$name'");
			if($result && ($db->sql_numrows($result)==1)){
				// add new SQL entry with dummy password in case LDAP is disabled
				$db->sql_query("UPDATE "
					.$prefix."_users set user_password='xa"
					.rand(10000000,99999999)."px".rand(10000000,999999999)
					."tna' where ".$ldap['ldapID']."=$name");
			}
		}

		return true;
	}
	return false;
}


?>
