<?php
/***************************************************************************
 *                            synch-ldap-mail.php
 *                            -------------------
 *   begin                : December 10, 2004
 *   copyright            : (C) 2004 William Wong
 *   email                : bwong at voicenet.com
 *
 *   $Id: synch-ldap-posix.php,v 2.00 2004/12/10 $
 *
 ***************************************************************************/
/*                                                                      */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to the Free Software          */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */
/*                                                                         */
/***************************************************************************/

if (eregi("synch-ldap-mail.php",$_SERVER['PHP_SELF'])) {
    Header("Location: ../index.php");
    die();
}

// variables used in substitutions
synchSet('mailEnabled',"1");

// add and mod entries are processed after PHPNuke database has been updated
// These definitions are used when creating a new account
// The appropriate group of attributes or scripts is used if the $ldapconfig['var'][group] is non-zero.

$ldapconfig['add']['mail']['ldif']['objectclass'][]	="qmailuser";

/******* Qmail field definitions  ******
$ldapconfig['add']['mail']['mailMessageStore']		="";
$ldapconfig['add']['mail']['mailAlternateAddress']	="";
$ldapconfig['add']['mail']['qmailUID']			="";
$ldapconfig['add']['mail']['qmailGID']			="";
$ldapconfig['add']['mail']['mailHost']			="";
$ldapconfig['add']['mail']['mailForwardingAddress']	="";
$ldapconfig['add']['mail']['deliveryProgramPath']	="";
$ldapconfig['add']['mail']['qmailDotMode']		="";
$ldapconfig['add']['mail']['deliveryMode']		="";
$ldapconfig['add']['mail']['mailReplyText']		="";
$ldapconfig['add']['mail']['accountStatus']		="";
$ldapconfig['add']['mail']['qmailAccountPurge']		="";
$ldapconfig['add']['mail']['mailQuotaSize']		="";
$ldapconfig['add']['mail']['mailQuotaCount']		="";
$ldapconfig['add']['mail']['mailSizeMax']		="";
**************************************/


$ldapconfig['add']['mail']['script'][]			="{scriptPath}mailadd.sh {username}";


// Use these when deleting something from the ldap database
// scripts for each matching objectclass will be run after the user is deleted
$ldapconfig['del']['qmailuser']['script'][]		="{scriptPath}maildel.sh {username}";


// field definitions for edit form and substitutions
$ldapconfig['addAdminTop']['show'][]			='synchMailShowAdd';

$ldapconfig['addAdmin']['get'][]			='synchMailGet';

$ldapconfig['editAdminTop']['show'][]			='synchMailShowEdit';

$ldapconfig['editAdmin']['get'][]			='synchMailGet';

$ldapconfig['editUserTop']['show'][]			='synchMailShowEditUser';

$ldapconfig['load'][]					='synchMailLoad';

function synchMailLoad(){
	synchSet('mailEnabled',synchInArray(synchGet('ldap_objectclass'),'qmailuser'));
}

function synchMailShowAdd(){
	synchMailShow(true);
}

function synchMailShowEdit(){
	synchMailShow(false);
}

function synchMailShowEditUser(){
	synchMailShow(false, true);
}

function synchMailShow($enabled,$user=false){
	global $bgcolor2,$bgcolor3;
	if($user){	// user has color
		$bg1=" bgcolor='$bgcolor2'";
		$bg2=" bgcolor='$bgcolor3'";
		$bf="<b>";
		$bl="</b>";
	}else{		// admin does not
		$bg1="";
		$bg2="";
		$bf="";
		$bl="";
	}

	echo "<tr><td$bg1>{$bf}Mail User$bl</td><td$bg2><INPUT TYPE=CHECKBOX NAME=synchMail "
	    . (synchGet('mailEnabled')==1 ? "checked " : "")
	    . ($enabled ? "" : "disabled ")
	    . "</INPUT></td></tr>";
}

function synchMailGet(){
	synchSet('MailEnabled',$GLOBALS['synchMail']=='on');		// checkbox returns "on" or nothing
}


?>
