.TH SORTM %manext1% 2014-03-23 "%nmhversion%"
.
.\" %nmhwarning%
.
.SH NAME
sortm \- sort nmh messages
.SH SYNOPSIS
.HP 5
.na
.B sortm
.RB [ \-help ]
.RB [ \-version ]
.RI [ +folder ]
.RI [ msgs ]
.RB [ \-all " | " \-noall ]
.RB [ \-datefield
.IR field ]
.RB [ \-textfield
.IR field ]
.RB [ \-notextfield ]
.RB [ \-limit
.IR days ]
.RB [ \-nolimit ]
.RB [ \-check " | " \-nocheck ]
.RB [ \-verbose " | " \-noverbose ]
.ad
.SH DESCRIPTION
.B sortm
sorts the specified messages in the named folder according
to the chronological order of the \*(lqDate:\*(rq field of each message.
.PP
If no messages are specified, the default is all messages in the folder.
However, if no messages are specified and the
.B \-noall
switch is enabled, then
.B sortm
reports that as an error and exits with non-zero status.
.B \-noall
is most useful in the user's profile, to avoid inadvertent sorting of
an entire folder.  The
.B \-all
switch can then be used on the command line to disable it.  Of course,
a message specification of
.I all
can be used in any case.
.PP
The
.B \-verbose
switch directs
.B sortm
to tell the user the general
actions that it is taking to place the folder in sorted order.
.PP
The
.B \-datefield
.I field
switch tells
.B sortm
the name of the field to
use when making the date comparison.  If the user has a special field in
each message, such as \*(lqBB\-Posted:\*(rq or \*(lqDelivery\-Date:\*(rq,
then the
.B \-datefield
switch can be used to direct
.B sortm
which field to examine.
.PP
The
.B \-textfield
.I field
switch causes
.B sortm
to sort messages by the specified text field.  All characters except
letters and numbers are stripped and the resulting strings are sorted
datefield-major, textfield-minor, using a case insensitive
comparison.  If this field is \*(lqsubject\*(rq, any leading "re:" is
stripped off.
.PP
With
.B \-textfield
.IR field ,
if
.B \-limit
.I days
is specified, messages
with the same textfields that are dated within `days' of each other
appear together.  Specifying
.B \-nolimit
makes the limit infinity.
With
.B \-limit
.IR 0 ,
the sort is instead simply textfield-major.
.PP
For example, to order a folder by date-major, grouping messages with
the same subject on the same date together, use:
.PP
.RS 5
sortm -textfield subject +folder
.RE
.PP
.B sortm
always issues a warning for each message that is missing a
\*(lqDate:\*(rq field, has a \*(lqDate:\*(rq field that cannot be
parsed, or has a format error in any header field.  With the
.B \-check
switch,
.B sortm
inhibits all modifications to the folder if there are any such
messages, and exits with non-zero status.  With the default of
.BR \-nocheck ,
.B sortm
sorts messages with a missing or invalid
\*(lqDate:\*(rq field using their file modification times.
.PP
When ordering messages based on their dates, if they have the same
dates, their original message order is preserved.
.SH FILES
.fc ^ ~
.nf
.ta \w'%nmhetcdir%/ExtraBigFileName  'u
^$HOME/.mh_profile~^The user profile
.fi
.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Current\-Folder:~^To find the default current folder
.fi
.SH "SEE ALSO"
.IR folder (1)
.SH DEFAULTS
.nf
.RB ` +folder "' defaults to the current folder"
.RB ` msgs "' defaults to all without -noall, has no default with -noall"
.RB ` \-all '
.RB ` \-datefield "' defaults to date"
.RB ` \-notextfield '
.RB ` \-noverbose '
.RB ` \-nolimit '
.RB ` \-nocheck '
.fi
.SH CONTEXT
If a folder is given, it will become the current folder.  If the current
message is moved,
.B sortm
will preserve its status as current.
.SH HISTORY
Timezones used to be ignored when comparing dates: they aren't any more.
.PP
Messages which were in the folder, but not specified by `msgs', used to
be moved to the end of the folder; now such messages are left untouched.
.PP
.B sortm
sometimes did not preserve the message numbering in a folder
(e.g., messages 1, 3, and 5, might have been renumbered to 1, 2, 3 after
sorting).  This was a bug, and has been fixed.  To compress the message
numbering in a folder, use
.RB \*(lq "folder\ \-pack" \*(rq
as always.
.SH BUGS
When
.B sortm
complains about a message which it can't temporally
order, it complains about the message number
.I prior
to sorting.
It should indicate what the message number will be
.B after
sorting.
