.TH FOLDER %manext1% 2016-08-29 "%nmhversion%"
.
.\" %nmhwarning%
.
.SH NAME
folder, folders \- set/list current nmh folder/message
.SH SYNOPSIS
.HP 5
.na
.B folder
.RB [ \-help ]
.RB [ \-version ]
.RI [ +folder ]
.RI [ msg ]
.RB [ \-all " | " \-noall ]
.RB [ \-create " | " \-nocreate ]
.RB [ \-fast " | " \-nofast ]
.RB [ \-header " | " \-noheader ]
.RB [ \-recurse " | " \-norecurse ]
.RB [ \-total " | " \-nototal ]
.RB [ \-list " | " \-nolist ]
.RB [ \-push " | " \-pop ]
.RB [ \-pack " | " \-nopack ]
.RB [ \-print " | " \-noprint ]
.RB [ \-verbose " | " \-noverbose ]
.HP 5
.B folders
is equivalent to
.B folder
.B \-all
.ad
.SH DESCRIPTION
When
.B folder
is given the
.B \-print
switch (the default), it lists: the current folder, the number
of messages in it and their range (low-high), the folder's
current message, and an indication of extra files, if any.
For example:
.PP
.RS 5
.nf
.ta \w'/rnd/phyl/Mail/EP 'u +\w'has ddd messages 'u +\w'(ddd\-ddd); 'u
inbox+	has \016 messages	(\0\03\-\022);	cur=\0\05.
.fi
.RE
.PP
If a
.I +folder
and/or
.I msg
are specified, they will become the current folder and/or message.
(When a
.I +folder
argument is given, this corresponds to a \*(lqcd\*(rq operation
in the shell; when no
.I +folder
argument is given, this corresponds roughly to a \*(lqpwd\*(rq
operation in the shell.) If
.B \-noprint
is specified, a
.I +folder
and/or
.I msg
may still be specified to set the current folder and/or message,
but the folder summary will not be printed.
.PP
If the specified (or default) folder doesn't exist,
.B folder
will ask the user if the folder should be created; when
standard input is not a tty, the answer is assumed to be
\*(lqyes\*(rq.
The
.B \-create
switch tells
.B folder
to create new folders without query.
(This is an easy way to create an empty folder for later use.)
Specifying
.B \-nocreate
will cause
.B folder
to print an error message and exit without creating a folder.
.SS "Multiple Folders"
Specifying
.B \-all
will produce a summary line for each top-level folder in the user's
.B nmh
directory, sorted alphabetically.  (If
.B folder
is invoked by a name ending with \*(lqs\*(rq (e.g.
.BR folders ),
.B \-all
is assumed.)  Specifying
.B \-recurse
with
.B \-all
will include a line for all sub-folders.
These folders are all preceded by any read-only folders, which occur as
.RI \*(lq atr\-cur\- \*(rq
entries in the user's
.B nmh
context.  For example:
.PP
.RS 5
.nf
.ta \w'/rnd/phyl/Mail/EP 'u +\w'has ddd messages 'u +\w'(ddd\-ddd); 'u
FOLDER	\0\0\0\0\0\0# MESSAGES	RANGE	CUR     (OTHERS)
/var/work/folder	has \035 messages	(\01\-\035);	cur=23.
/usr/bugs/Mail	has \082 messages	(\01\-108);	cur=82.
ff	has \0no messages.
inbox+	has \016 messages	(\03\-\022);	cur=\05.
mh	has \076 messages	(15\-\076);	cur=70.
notes	has \0\02 messages	(\01\-\0\02);	cur=\01.
ucom	has 124 messages	(\01\-124);	cur=\06; (others).
.ta \w'/rnd/phyl/Mail/EP has 'u
TOTAL = 339 messages in 7 folders
.fi
.RE
.PP
The \*(lq+\*(rq after
.I inbox
indicates that it is the current folder.
The \*(lq(others)\*(rq indicates that the folder
.I ucom
contains files which aren't messages;
these may either be sub-folders, or files that
don't belong under the
.B nmh
file naming scheme.
.PP
The header is output if either the
.B \-all
or
.B \-header
switches are specified.  It is suppressed by
.BR \-noheader .
.PP
The folder and message totals are output if either the
.B \-all
or
.B \-total
switches are specified.  They are suppressed by
.BR \-nototal .
.PP
If
.B \-fast
is given, only the folder name (or names, in the case of
.BR \-all )
will be listed.
(This is faster because the folders need not be read.)
.PP
If a
.I +folder
is given with the
.B \-all
switch,
.B folder
will, in addition to setting the current folder, list the top-level
sub-folders for the current folder (with
.BR \-norecurse )
or list all sub-folders under the current folder recursively (with
.BR \-recurse ).
.PP
If
.I msg
is supplied, together with
.I +folder
or without
.BR \-all ,
it will become the current message of
.I +folder
(if it had been supplied)
or the current folder.
.PP
The
.B \-recurse
switch lists each folder recursively, so its use effectively
defeats the speed enhancement of
.BR \-fast ,
since each folder must be searched for sub-folders.
Nevertheless, the combination of these options is useful.
.SS "Compacting a Folder"
The
.B \-pack
switch will compress the message names in the designated folders,
removing holes in message numbering.  The
.B \-verbose
switch directs
.B folder
to tell the user the general actions it is taking to compress the folder.
.SS "The Folder Stack"
The
.B \-push
switch directs
.B folder
to push the current folder
onto the
.IR folder-stack ,
and make the
.I +folder
argument the current folder.  If
.I +folder
is not given, the current folder and the
top of the
.I folder-stack
are exchanged.  This corresponds to the
\*(lqpushd\*(rq operation in the shell.
.PP
The
.B \-pop
switch directs
.B folder
to discard the top of the
.IR folder-stack ,
after setting the current folder to that value.
No
.I +folder
argument is allowed.  This corresponds to the \*(lqpopd\*(rq
operation in the shell.  The
.B \-push
and
.B \-pop
switches are mutually exclusive: the last occurrence of either one
overrides any previous occurrence of the other.
The use of either of these switches also sets
.BR \-list ,
by default.
.PP
The
.B \-list
switch directs
.B folder
to list the
.IR folder-stack .
No
.I +folder
argument is allowed.  After a successful
.B \-push
or
.BR \-pop ,
the
.B \-list
action is taken, unless a
.B \-nolist
switch follows them on the command line.  This corresponds
to the \*(lqdirs\*(rq operation in the shell.  The
.BR \-push ,
.BR \-pop ,
and
.B \-list
switches disable the default
.B \-print
behavior.
.SH FILES
.TP 20
$HOME/.mh_profile
The user's profile.
.SH "PROFILE COMPONENTS"
.PD 0
.TP 20
Path:
To determine the user's nmh directory.
.TP
Current\-Folder:
To find the default current folder.
.TP
Folder\-Protect:
To set mode when creating a new folder.
.TP
Folder\-Stack:
To determine the folder stack.
.\" ^lsproc:~^Program to list the contents of a folder
.PD
.SH "SEE ALSO"
.IR mhpath (1),
.IR refile (1),
.IR rmf (1)
.SH DEFAULTS
.PD 0
.TP 20
+folder
The current folder.
.TP
msg
\*(lqnone\*(rq
.TP
\-nofast
.TP
\-noheader
.TP
\-nototal
.TP
\-nopack
.TP
\-norecurse
.TP
\-noverbose
.TP
\-print
is the default if none of
.BR -list ,
.BR \-push ,
or
.B \-pop
are specified.
.TP
\-list
is the default if
.BR \-push ,
or
.B \-pop
is specified.
.PD
.SH CONTEXT
If
.I +folder
and/or
.I msg
are given, they will become the current folder and/or message.
.SH BUGS
There is no way to restore the default behavior
(to ask the user whether to create a non-existent folder)
after
.B \-create
or
.B \-nocreate
is given.
