.TH MH-PROFILE %manext5% "February 16, 2014" "%nmhversion%"
.\"
.\" %nmhwarning%
.\"
.SH NAME
mh-profile \- user profile customization for nmh message handler
.SH DESCRIPTION
Each user of
.B nmh
is expected to have a file named
.I \&.mh\(ruprofile
in his or her home directory.  This file contains
a set of user parameters used by some or all of the
.B nmh
family of programs.  Each entry in the file is of the format
.PP
.RS 5
.IR profile\-component ": " value
.RE
.PP
If the text of profile entry is long, you may extend it across several
real lines by indenting the continuation lines with leading spaces or tabs.
Comments may be introduced by a line starting with `#:':
.PP
.RS 5
.IR # ": "
This is a comment.
.RE
.PP
Blank lines are not permitted in
.IR \&.mh\(ruprofile.
The shell quoting conventions are not available in the
.IR \&.mh\(ruprofile ;
each token is separated by whitespace.
.SS "Standard Profile Entries"
The possible profile components are exemplified below.  The only mandatory
entry is `Path:'.  The others are optional; some have default values if
they are not present.  In the notation used below, (profile, default)
indicates whether the information is kept in the user's
.B nmh
profile or
.B nmh
context, and indicates what the default value is.  Note that a profile
component can only appear once.  Multiple appearances with trigger a
warning that all appearances after the first are ignored.
.PP
.BR Path :
Mail
.RS 5
Locates
.B nmh
transactions in directory \*(lqMail\*(rq.  This is the
only mandatory profile entry.  (profile, no default)
.RE
.PP
.BR context :
context
.RS 5
Declares the location of the
.B nmh
context file.  This is overridden by the environment variable
.BR $MHCONTEXT .
See the
.B HISTORY
section below.
(profile, default: <nmh\-dir>/context)
.RE
.PP
.BR Current\-Folder :
inbox
.RS 5
Keeps track of the current open folder.
(context, default: folder specified by \*(lqInbox\*(rq)
.RE
.PP
.BR Inbox :
inbox
.RS 5
Defines the name of your default inbox.
(profile, default: inbox)
.RE
.PP
.BR Previous\-Sequence :
.I pseq
.RS 5
Names the sequence or sequences which should be defined as the `msgs' or
`msg' argument given to any
.B nmh
command.  If not present or empty,
no such sequences are defined.  Otherwise, for each name given, the
sequence is first zero'd and then each message is added to the sequence.
Read the
.IR mh\-sequence (5)
man page for the details about this sequence. (profile, no default)
.RE
.PP
.BR Sequence\-Negation :
not
.RS 5
Defines the string which, when prefixed to a sequence name, negates
that sequence.  Hence, \*(lqnotseen\*(rq means all those messages that
are not a member of the sequence \*(lqseen\*(rq.  Read the
.IR mh\-sequence (5)
man page for the details.  (profile, no default)
.RE
.PP
.BR Unseen\-Sequence :
unseen
.RS 5
Names the sequence or sequences which should be defined as those
messages which are unread.  The commands
.BR inc ,
.BR rcvstore ,
.BR mhshow ,
and
.B show
will add or remove messages from these
sequences when they are incorporated or read.  If not present or
empty, no such sequences are defined.  Otherwise, each message is
added to, or removed from, each sequence name given.  Read the
.IR mh\-sequence (5)
man page for the details about this sequence.
(profile, no default)
.RE
.PP
.BR mh\-sequences :
\&.mh\(rusequences
.RS 5
The name of the file in each folder which defines public sequences.
To disable the use of public sequences, leave the value portion of this
entry blank.  (profile, default: \&.mh\(rusequences)
.RE
.PP
.BI atr\- seq \- folder :
172\0178\-181\0212
.RS 5
Keeps track of the private sequence called \*(lqseq\*(rq in the specified
folder.  Private sequences are generally used for read\-only folders.
See the
.IR mh\-sequence (5)
man page for details about private sequences.
(context, no default)
.RE
.PP
.BR Editor :
vi
.RS 5
Defines the editor to be used by the commands
.BR comp ,
.BR dist ,
.BR forw ,
and
.BR repl .
If not set in profile the value will be taken from the VISUAL and
EDITOR environment variables.
(profile, default: vi)
.RE
.PP
.BR Msg\-Protect :
600
.RS 5
An octal number which defines the permission bits for new message files.
See
.IR chmod (1)
for an explanation of the octal number.  Note that some filesystems,
such as FAT32, do not support removal of read file permissions.
(profile, default: 0600)
.RE
.PP
.BR Folder\-Protect :
700
.RS 5
An octal number which defines the permission bits for new folder
directories.  See
.IR chmod (1)
for an explanation of the octal number.
(profile, default: 700)
.RE
.PP
.BR datalocking :
fcntl
.RS 5
The locking algorithm used to lock changes to any
.B nmh
data files, such as sequences or the context.  The locking algorithm is
any one of the following entries:
.PP
.RS 5
.nf
%supported_locks%
.fi
.RE
.PP
Available locking algorithms can vary depending on what is supported by
the operating system.  Note: currently transactional locking is only
supported on public sequences; see
.IR mh\-sequence (5)
for more information.
(profile, default: fcntl)
.RE
.PP
.IR program :
.I default switches
.RS 5
Sets default switches to be used whenever the mh program
.I program
is invoked.  For example, one could override the \*(lqEditor:\*(rq profile
component when replying to messages by adding a component such as:
.PP
.RS 5
repl: \-editor /bin/ed
.RE
.PP
(profile, no defaults)
.RE
.PP
.IB lasteditor "-next:"
.I nexteditor
.RS 5
Names \*(lqnexteditor\*(rq to be the default editor after using
\*(lqlasteditor\*(rq.  This takes effect at \*(lqWhat now?\*(rq prompt
in
.BR comp ,
.BR dist ,
.BR forw ,
and
.BR repl .
After editing
the draft with \*(lqlasteditor\*(rq, the default editor is set to be
\*(lqnexteditor\*(rq.  If the user types \*(lqedit\*(rq without any
arguments to \*(lqWhat now?\*(rq, then \*(lqnexteditor\*(rq is used.
(profile, no default)
.RE
.PP
.BR Folder\-Stack :
.I folders
.RS 5
The contents of the folder-stack for the
.B folder
command.
(context, no default)
.RE
.PP
.BR Local\-Mailbox :
Your Username <user@some.host>
.RS 5
Tells the various MH tools what your local mailbox is.  If set, will be used
by the default component files by tools like
.B comp
and
.B repl
to construct your default \*(lqFrom\*(rq header.  The text used here will
be copied exactly to your From: header, so it should already be RFC 822
compliant.  If this is set, the
.B Signature
profile entry is NOT used, so it should include a signature as well.  (profile,
default: userid@local.hostname)
.RE
.PP
.BR Alternate\-Mailboxes :
mh@uci\-750a, bug-mh*
.RS 5
Tells
.B repl
and
.B scan
which addresses are really yours.
In this way,
.B repl
knows which addresses should be included in the
reply, and
scan
knows if the message really originated from you.
Addresses must be separated by a comma, and the hostnames listed should
be the \*(lqofficial\*(rq hostnames for the mailboxes you indicate, as
local nicknames for hosts are not replaced with their official site names.
For each address, if a host is not given, then that address on any host is
considered to be you.  In addition, an asterisk (`*') may appear at either
or both ends of the mailbox and host to indicate wild-card matching.
(profile, default: your user-id)
.RE
.PP
.BR Aliasfile :
aliases
.I other-alias
.RS 5
Indicates aliases files for
.BR ali ,
.BR whom ,
and
.BR send .
This may be used instead of the
.B \-alias
.I file
switch.  (profile, no default)
.RE
.PP
.BR Draft\-Folder :
drafts
.RS 5
Indicates a default draft folder for
.BR comp ,
.BR dist ,
.BR forw ,
.BR refile ,
and
.BR repl .
Read the
.IR mh\-draft (5)
man page for details. (profile, no default)
.RE
.PP
.BI digest\-issue\- list :
1
.RS 5
Tells
.B forw
the last issue of the last volume sent for the digest
.IR list .
(context, no default)
.RE
.PP
.BI digest\-volume\- list :
1
.RS 5
Tells
.B forw
the last volume sent for the digest
.IR list .
(context, no default)
.RE
.PP
.BR MailDrop :
\&.mail
.RS 5
Tells
.B inc
your maildrop, if different from the default.  This is
superseded by the environment variable
.BR $MAILDROP .
(profile, default: %mailspool%/$USER)
.RE
.PP
.BR Signature :
RAND MH System (agent: Marshall Rose)
.RS 5
Tells front-end programs such as
.BR comp,
.BR forw,
and
.B repl
your mail signature.  This is superseded by the
environment variable
.BR $SIGNATURE .
If
.B $SIGNATURE
is not set and this profile entry is not present, the \*(lqgcos\*(rq field of
the \fI/etc/passwd\fP file will be used.
Your signature will be added to the address
.B send
puts in the \*(lqFrom:\*(rq header; do not include an address in the
signature text.  The \*(lqLocal\-Mailbox\*(rq profile component
supersedes all of this.  (profile, no default)
.RE
.PP
.BR credentials :
\&legacy
.RS 5
Indicates how the username and password credentials will be retrieved
for access to external servers, such as those that provide SMTP or POP
service.  The supported entry values are \*(lqlegacy\*(rq and
.RI \*(lqfile: netrc \*(rq.
With \*(lqlegacy\*(rq, or if there is no credentials entry, the
username is the first of:
.PP
.RS 5
1)
.B \-user
switch to
.BR send ,
.BR post ,
.BR whom ,
.BR inc ,
or
.B msgchk
program
.br
2) the login name on the local machine
.RE
.PP
The password for SMTP services is the first of:
.PP
.RS 5
1) password value from matching entry in file named \*(lq.netrc\*(rq
in the user's home directory
.br
2) password obtained by interactively prompting the user
.RE
.PP
The password for POP service when the
.B \-sasl
switch is used with one of these programs is the login name on the
local machine.
.PP
With a
.RI \*(lqfile: netrc \*(rq
.B credentials
entry, the username is the first of:
.PP
.RS 5
1)
.B \-user
switch to program
.br
2) login name from matching entry in
.I netrc
file
.br
3) value provided by user in response to interactive query
.RE
.PP
Similarly, the password is provided either in the
.I netrc
file or interactively.
.I netrc
can be any valid filename, either absolute or relative to Path or
$HOME.  The
.I netrc
file contains authentication information, for each server,
using a line of the following form.  Replace the words
.IR myserver ,
.IR mylogin ,
and
.I mypassword
with your own account information:
.PP
.RS 5
.B machine
.I myserver
.B login
.I mylogin
.B password
.I mypassword
.RE
.PP
This
.I netrc
file must be owned and readable only by you.
(profile, default: legacy)
.RE
.SS "Process Profile Entries"
The following profile elements are used whenever an
.B nmh
program invokes some other program such as
.BR more .
The
.I \&.mh\(ruprofile
can be used to select alternate programs if the
user wishes.  The default values are given in the examples.
.PP
If the profile element contains spaces, the element is split at spaces
into tokens and each token is given as a separate argument to the
.IR execvp (2)
system call.  If the element contains shell metacharacters then the entire
element is executed using
.BR /bin/sh .
.RE
.PP
.BR buildmimeproc :
%bindir%/mhbuild
.RS 5
This is the program used by
.B whatnow
to process drafts which are MIME composition files.
.RE
.PP
.BR fileproc :
%bindir%/refile
.RS 5
This program is used to refile or link a message to another folder.
It is used by
.B send
to file a copy of a message into a folder given
by a \*(lqFcc:\*(rq field.  It is used by the draft folder facility in
.BR comp ,
.BR dist ,
.BR forw ,
and
.B repl
to refile a draft
message into another folder.  It is used to refile a draft message in
response to the
.B refile
directive at the \*(lqWhat now?\*(rq prompt.
.RE
.PP
.BR formatproc :
.RS 5
Program called by
.B mhl
to filter a component when it is tagged with the \*(lqformat\*(rq variable
in the mhl filter.  See
.IR mhl (5)
for more information.
.RE
.PP
.BR incproc :
%bindir%/inc
.RS 5
Program called by
.B mhmail
to incorporate new mail when it
is invoked with no arguments.
.RE
.PP
.BR lproc :
more
.RS 5
This program is used to list the contents of a message in response
to the
.B list
directive at the \*(lqWhat now?\*(rq prompt.  It is
also used by the draft folder facility in
.BR comp ,
.BR dist ,
.BR forw ,
and
.B repl
to display the draft message.
(Note that
.B $PAGER
supersedes the default built-in pager command.)
.RE
.PP
.BR mailproc :
%bindir%/mhmail
.RS 5
This is the program used to automatically mail various messages
and notifications.  It is used by
.B conflict
when using the
.B \-mail
option.  It is used by
.B send
to post failure notices.
It is used to retrieve an external-body with access-type `mail-server'
(such as when storing the body with
.BR mhstore ).
.RE
.PP
.BR mhlproc :
%libdir%/mhl
.RS 5
This is the program used to filter messages in various ways.  It
is used by
.B mhshow
to filter and display the message headers
of MIME messages.  When the
.B \-format
or
.B \-filter
option is used
by
.B forw
or
.BR repl ,
the
.I mhlproc
is used to filter the
message that you are forwarding, or to which you are replying.
When the
.B \-filter
option is given to
.BR send ,
the
.I mhlproc
is used to filter the copy of the message
that is sent to \*(lqBcc:\*(rq recipients.
.RE
.PP
.BR moreproc :
more
.RS 5
This is the program used by
.B mhl
to page the
.B mhl
formatted message when displaying to a terminal.  It is also the default
program used by
.B mhshow
to display message bodies (or message parts) of type text/plain.
(Note that
.B $PAGER
supersedes the default built-in pager command.)
.RE
.PP
.BR mshproc :
%bindir%/msh
.RS 5
Currently not used.
.RE
.PP
.BR packproc :
%bindir%/packf
.RS 5
Currently not used.
.RE
.PP
.BR postproc :
%libdir%/post
.RS 5
This is the program used by
.BR send ,
.BR mhmail ,
.BR rcvdist ,
and
.B viamail
(used by the
.B sendfiles
shell script) to
post a message to the mail transport system.  It is also called by
.B whom
(called with the switches
.B \-whom
and
.BR \-library )
to do address verification.
.RE
.PP
.BR rmmproc :
none
.RS 5
This is the program used by
.BR rmm ,
.BR refile ,
and
.B mhfixmsg
to delete a message from a folder.
.RE
.PP
.BR sendproc :
%bindir%/send
.RS 5
This is the program to use by
.B whatnow
to actually send the message
.RE
.PP
.BR showmimeproc :
%bindir%/mhshow
.RS 5
This is the program used by
.B show
to process and display non-text (MIME) messages.
.RE
.PP
.BR showproc :
%libdir%/mhl
.RS 5
This is the program used by
.B show
to filter and display text (non-MIME) messages.
.RE
.PP
.BR whatnowproc :
%bindir%/whatnow
.RS 5
This is the program invoked by
.BR comp ,
.BR forw ,
.BR dist ,
and
.B repl
to query about the disposition of a composed draft message.
.RE
.PP
.BR whomproc :
%bindir%/whom
.RS 5
This is the program used by
.B whatnow
to determine to whom a message would be sent.
.RE
.SS "Profile Lookup"
Some
.B nmh
programs will look in more than just the user's 
.I \&.mh\(ruprofile
for profile entries.  In particular, 
.BR mhbuild ,
.BR mhshow ,
.BR mhstore ,
and
.BR mhn 
will also all look in a file specified by a program-specific
environment variable (see below), and after that in 
the system-installed profile (%etcdir%/mhn.defaults).  (The
.B mhfixmsg
program is similar, but doesn't consult an environment variable.)
The first match found for a particular component will be used,
allowing user-supplied entries to override those that are system-supplied.
A profile component with a blank value field will "hide" any later
occurrences of the component, and will make the entry appear to be
absent.
.SS "Environment Variables"
The operation of
.B nmh
and its commands it also controlled by the
presence of certain environment variables.
.PP
Many of these environment variables are used internally by the
\*(lqWhat now?\*(rq interface.  It's amazing all the information
that has to get passed via environment variables to make the
\*(lqWhat now?\*(rq interface look squeaky clean to the
.B nmh
user, isn't it?  The reason for all this is that the
.B nmh
user
can select
.B any
program as the
.IR whatnowproc ,
including
one of the standard shells.  As a result, it's not possible to pass
information via an argument list. The convention is that environment
variables whose names are all upper-case are user-settable; those
whose names are lower-case only are used internally by nmh and should
not generally be set by the user.
.PP
.B $MH
.RS 5
With this environment variable, you can specify a profile
other than
.I \&.mh\(ruprofile
to be read by the
.B nmh
programs
that you invoke.  If the value of
.B $MH
is not absolute, (i.e., does
not begin with a \*(lq/\*(rq), it will be presumed to start from the current
working directory.  This is one of the very few exceptions in
.B nmh
where non-absolute pathnames are not considered relative to the user's
.B nmh
directory.
.RE
.PP
.B $MHCONTEXT
.RS 5
With this environment variable, you can specify a
context other than the normal context file (as specified in
the
.B nmh
profile).  As always, unless the value of
.B $MHCONTEXT
is absolute, it will be presumed to start from your
.B nmh
directory.
.RE
.PP
.B $MHBUILD
.RS 5
With this environment variable, you can specify an
additional user profile (file) to be read by
.BR mhbuild ,
in addition to the mhn.defaults profile.
.RE
.PP
.B $MHN
.RS 5
With this environment variable, you can specify an
additional user profile (file) to be read by
.BR mhn ,
in addition to the mhn.defaults profile.
.B mhn
is deprecated, so this support for this variable will
be removed from a future nmh release.
.RE
.PP
.B $MHSHOW
.RS 5
With this environment variable, you can specify an
additional user profile (file) to be read by
.BR mhshow ,
in addition to the mhn.defaults profile.
.RE
.PP
.B $MHSTORE
.RS 5
With this environment variable, you can specify an
additional user profile (file) to be read by
.BR mhstore ,
in addition to the mhn.defaults profile.
.RE
.PP
.B $MAILDROP
.RS 5
This variable tells
.B inc
the default maildrop. This supersedes the \*(lqMailDrop\*(rq profile entry.
.RE
.PP
.B $MAILHOST
.RS 5
This variable tells
.B inc
the POP host to query for mail to incorporate.  See the
inc(1) man page for more information.
.RE
.PP
.B $USERNAME_EXTENSION
.RS 5
This variable is for use with username_extension masquerading.  See the
mh-tailor(5) man page.
.RE
.PP
.B $SIGNATURE
.RS 5
This variable tells
.B send
and
.B post
your mail signature. This supersedes the \*(lqSignature\*(rq profile entry,
and is not used when the \*(lqLocal\-Mailbox\*(rq profile component is set.
.RE
.PP
.B $USER
.RS 5
This variable tells
.B repl
your user name and
.B inc
your default maildrop:  see the \*(lqMailDrop\*(rq profile entry.
.RE
.PP
.B $HOME
.RS 5
This variable tells all
.B nmh
programs your home directory
.RE
.PP
.B $TERM
.RS 5
This variable tells
.B nmh
your terminal type.
.PP
The environment variable
.B $TERMCAP
is also consulted.  In particular,
these tell
.B scan
and
.B mhl
how to clear your terminal, and how
many columns wide your terminal is.  They also tell
.B mhl
how many
lines long your terminal screen is.
.RE
.PP
.B $MHMTSCONF
.RS 5
If this variable is set to a non-null value, it specifies the
name of the mail transport configuration file to use by
.BR post ,
.BR inc ,
and other programs that interact with the mail transport system,
instead of the default.  See mh-tailor(5).
.RE
.PP
.B $MHMTSUSERCONF
.RS 5
If this variable is set to a non-null value, it specifies the name of
a mail transport configuration file to be read in addition to the
default.  See mh-tailor(5).
.RE
.PP
.B $MHTMPDIR
.B $TMPDIR
.RS 5
These variables are searched, in order, for the directory in which to
create some temporary files.
.RE
.PP
.B $MHLDEBUG
.RS 5
If this variable is set to a non-null value,
.B mhl
will emit debugging information.
.RE
.PP
.B $MHPDEBUG
.RS 5
If this variable is set to a non-null value,
.B pick
will emit a representation of the search pattern.
.RE
.PP
.B $MHWDEBUG
.RS 5
If this variable is set to a non-null value,
.B nmh
commands that use the
.BR Alternate\-Mailboxes
profile entry will display debugging information
about the values in that entry.
.RE
.PP
.B $PAGER
.RS 5
If set to a non-null value, this supersedes the value of
the default built-in pager command.
.RE
.PP
.B $editalt
.RS 5
This is the alternate message.
.PP
This is set by
.B dist
and
.B repl
during edit sessions so you can
peruse the message being distributed or replied to.  The message is also
available, when the
.B \-atfile
switch is used,
through a link called \*(lq@\*(rq in the current directory if
your current working directory and the folder the message lives in are
on the same UNIX filesystem, and if your current working directory is
writable.
.RE
.PP
.B $mhdraft
.RS 5
This is the path to the working draft.
.PP
This is set by
.BR comp ,
.BR dist ,
.BR forw ,
and
.B repl
to tell the
.I whatnowproc
which file to ask \*(lqWhat now?\*(rq
questions about.
.RE
.PP
.B $mhaltmsg
.RS 5
.B dist
and
.B repl
set
.B $mhaltmsg
to tell the
.I whatnowproc
about an alternate message associated with the
draft (the message being distributed or replied to).
.RE
.PP
.B $mhfolder
.RS 5
This is the folder containing the alternate message.
.PP
This is set by
.B dist
and
.B repl
during edit sessions so you
can peruse other messages in the current folder besides the one being
distributed or replied to.  The environment variable
.B $mhfolder
is also set by
.BR show ,
.BR prev ,
and
.B next
for use by
.BR mhl .
.RE
.PP
.B $mhdist
.RS 5
.B dist
sets
.B $mhdist
to tell the
.I whatnowproc
that message re-distribution is occurring.
.RE
.PP
.B $mheditor
.RS 5
This is set by
.BR comp ,
.BR repl ,
.BR forw ,
and
.B dist
to tell the
.I whatnowproc
the user's choice of
editor (unless overridden by
.BR \-noedit ).
.RE
.PP
.B $mhuse
.RS 5
This may be set by
.BR comp .
.RE
.PP
.B $mhmessages
.RS 5
This is set by
.BR dist ,
.BR forw ,
and
.B repl
if annotations are to occur.
.RE
.PP
.B $mhannotate
.RS 5
This is set by
.BR dist ,
.BR forw ,
and
.B repl
if annotations are to occur.
.RE
.PP
.B $mhinplace
.RS 5
This is set by
.BR dist ,
.BR forw ,
and
.B repl
if annotations are to occur.
.RE
.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
^or $MH~^Rather than the standard profile
^<mh\-dir>/context~^The user context
^or $MHCONTEXT~^Rather than the standard context
^<folder>/\&.mh\(rusequences~^Public sequences for <folder>
.fi
.SH "SEE ALSO"
.IR environ (5),
.IR mh-sequence (5),
.IR nmh (7)
.SH HISTORY
The
.I \&.mh\(ruprofile
contains only static information, which
.B nmh
programs will
.B NOT
update.  Changes in context are made to the
.I context
file kept in the users
.B nmh
directory.
This includes, but is not limited to: the \*(lqCurrent\-Folder\*(rq entry
and all private sequence information.  Public sequence information is
kept in each folder in the file determined by the \*(lqmh\-sequences\*(rq
profile entry (default is
.IR \&.mh\(rusequences ).
.PP
The
.I \&.mh\(ruprofile
may override the path of the
.I context
file, by specifying a \*(lqcontext\*(rq entry (this must be in
lower-case).  If the entry is not absolute (does not start with a
\*(lq/\*(rq), then it is interpreted relative to the user's
.B nmh
directory.  As a result, you can actually have more than one set of
private sequences by using different context files.
.SH BUGS
There is some question as to what kind of arguments should be placed
in the profile as options.  In order to provide a clear answer, recall
command line semantics of all
.B nmh
programs: conflicting switches
(e.g.
.B \-header
and
.BR \-noheader )
may occur more than one time on the
command line, with the last switch taking effect.  Other arguments, such
as message sequences, filenames and folders, are always remembered on
the invocation line and are not superseded by following arguments of
the same type.  Hence, it is safe to place only switches (and their
arguments) in the profile.
.PP
If one finds that an
.B nmh
program is being invoked again and again
with the same arguments, and those arguments aren't switches, then there
are a few possible solutions to this problem.  The first is to create a
(soft) link in your
.I $HOME/bin
directory to the
.B nmh
program
of your choice.  By giving this link a different name, you can create
a new entry in your profile and use an alternate set of defaults for
the
.B nmh
command.  Similarly, you could create a small shell script
which called the
.B nmh
program of your choice with an alternate set
of invocation line switches (using links and an alternate profile entry
is preferable to this solution).
.PP
Finally, the
.B csh
user could create an alias for the command of the form:
.PP
.RS 5
alias cmd 'cmd arg1 arg2 ...'
.RE
.PP
In this way, the user can avoid lengthy type-in to the shell, and still
give
.B nmh
commands safely.  (Recall that some
.B nmh
commands
invoke others, and that in all cases, the profile is read, meaning that
aliases are disregarded beyond an initial command invocation)
