.\"
.\" %nmhwarning%
.\"
.TH MHSHOW %manext1% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
mhshow \- display MIME messages
.SH SYNOPSIS
.HP 5
.na
.B mhshow
.RI [ +folder ]
.RI [ msgs ]
.RB [ \-file
.IR file ]
.RB [ \-part
.IR number ]
\&...
.RB [ \-type
.IR content ]
\&...
.RB [ \-serialonly " | " \-noserialonly ]
.RB [ \-pause " | " \-nopause ]
.RB [ \-form
.IR formfile ]
.RB [ \-rcache
.IR policy ]
.RB [ \-wcache
.IR policy ]
.RB [ \-check " | " \-nocheck ]
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
The
.B mhshow
command display contents of a MIME (multi-media)
message or collection of messages.
.PP
.B mhshow
manipulates multi-media messages as specified in
RFC\-2045 thru RFC\-2049.  Currently
.B mhshow
only supports
encodings in message bodies, and does not support the encoding of
message headers as specified in RFC\-2047.
.PP
By default
.B mhshow
will display all parts of a multipart
message.  By using the
.B \-part
and
.B \-type
switches, you may
limit the scope of
.B mhshow
to particular subparts (of a
multipart content) and/or particular content types.
.PP
The option
.B \-file
.I file
directs
.B mhshow
to use the specified file as
the source message, rather than a message from a folder.  If you specify
this file as \*(lq-\*(rq, then
.B mhshow
will accept the source message
on the standard input.  Note that the file, or input from standard input
should be a validly formatted message, just like any other
.B nmh
message.  It should
.B NOT
be in mail drop format (to convert a file in
mail drop format to a folder of
.B nmh
messages, see
.BR inc (1)).
.PP
A part specification consists of a series of numbers separated by dots.
For example, in a multipart content containing three parts, these
would be named as 1, 2, and 3, respectively.  If part 2 was also a
multipart content containing two parts, these would be named as 2.1 and
2.2, respectively.  Note that the
.B \-part
switch is effective for only
messages containing a multipart content.  If a message has some other
kind of content, or if the part is itself another multipart content, the
.B \-part
switch will not prevent the content from being acted upon.
.PP
A content specification consists of a content type and a subtype.
The initial list of \*(lqstandard\*(rq content types and subtypes can
be found in RFC\-2046.
.PP
A list of commonly used contents is briefly reproduced here:
.PP
.RS 5
.nf
.ta \w'application  'u
Type	Subtypes
----	--------
text	plain, enriched
multipart	mixed, alternative, digest, parallel
message	rfc822, partial, external-body
application	octet-stream, postscript
image	jpeg, gif, png
audio	basic
video	mpeg
.fi
.RE
.PP
A legal MIME message must contain a subtype specification.
.PP
To specify a content, regardless of its subtype, just use the
name of the content, e.g., \*(lqaudio\*(rq.  To specify a specific
subtype, separate the two with a slash, e.g., \*(lqaudio/basic\*(rq.
Note that regardless of the values given to the `\-type' switch, a
multipart content (of any subtype listed above) is always acted upon.
Further note that if the `\-type' switch is used, and it is desirable to
act on a message/external-body content, then the `\-type' switch must
be used twice: once for message/external-body and once for the content
externally referenced.
.SS "Unseen Sequence"
If the profile entry \*(lqUnseen\-Sequence\*(rq is present and
non\-empty, then
.B mhshow
will remove each of the messages shown
from each sequence named by the profile entry.
.SS "Checking the Contents"
The
.B \-check
switch tells
.B mhshow
to check each content for an
integrity checksum.  If a content has such a checksum (specified as a
Content-MD5 header field), then
.B mhshow
will attempt to verify the
integrity of the content.
.SS "Showing the Contents"
The headers of each message are displayed with the
.I mhlproc
(usually
.BR mhl ),
using the standard format file
.IR mhl.headers .
You may specify an alternate format file with the
.B \-form
.I formfile
switch.  If the format file
.I mhl.null
is specified, then the display
of the message headers is suppressed.
.PP
Next, the contents are extracted from the message and are stored in
a temporary file.  Usually, the name of the temporary file is the
word \*(lqmhshow\*(rq followed by a string of characters.  Occasionally,
the method used to display a content (described next), requires that
the file end in a specific suffix.  For example, the
.B soffice
command (part of the StarOffice package) can be used to display
Microsoft Word content, but it uses the suffix to determine how to display
the file.  If no suffix is present, the file is not correctly loaded.
Similarily, older versions of the
.B gs
command append a \*(lq.ps\*(rq suffix to
the filename if one was missing.  As a result, these cannot be used to read
the default temporary file.
.PP
To get around this, your profile can contain lines of the form:
.PP
.RS 5
mhshow-suffix-<type>/<subtype>: <suffix>
.RE
.PP
or
.PP
.RS 5
mhshow-suffix-<type>: <suffix>
.RE
.PP
to specify a suffix which can be automatically added to the temporary
file created for a specific content type.  For example, the following
lines might appear in your profile:
.PP
.RS 5
.nf
mhshow-suffix-text: .txt
mhshow-suffix-application/msword: .doc
mhshow-suffix-application/PostScript: .ps
.fi
.RE
.PP
to automatically append a suffix to the temporary files.
.PP
The method used to display the different contents in the messages bodies
will be determined by a \*(lqdisplay string\*(rq.  To find the display
string,
.B mhshow
will first search your profile for an entry of the form:
.PP
.RS 5
mhshow-show-<type>/<subtype>
.RE
.PP
to determine the display string.  If this isn't found,
.B mhshow
will search for an entry of the form:
.PP
.RS 5
mhshow-show-<type>
.RE
.PP
to determine the display string.
.PP
If a display string is found, any escapes (given below) will be expanded.
The result will be executed under
\*(lq/bin/sh\*(rq, with the standard input
set to the content.
.PP
The display string may contain the following escapes:
.PP
.RS 5
.nf
.ta \w'%F  'u
%a	Insert parameters from Content-Type field
%e	exclusive execution
%f	Insert filename containing content
%F	%e, %f, and stdin is terminal not content
%l	display listing prior to displaying content
%p	%l, and ask for confirmation
%s	Insert content subtype
%d	Insert content description
%%	Insert the character %
.fi
.RE
.PP
For those display strings containing the e- or F-escape,
.B mhshow
will
execute at most one of these at any given time.  Although the F-escape
expands to be the filename containing the content, the e-escape has no
expansion as far as the shell is concerned.
.PP
When the p-escape prompts for confirmation, typing INTR (usually
control-C) will tell
.B mhshow
not to display that content.
The p-escape can be disabled by specifying the switch
.BR \-nopause .
Further, when
.B mhshow
is display a content, typing QUIT (usually
control-\\) will tell
.B mhshow
to wrap things up immediately.
.PP
Note that if the content being displayed is multipart, but not one of
the subtypes listed above, then the f- and F-escapes expand to multiple
filenames, one for each subordinate content.  Further, stdin is not
redirected from the terminal to the content.
.PP
If a display string is not found,
.B mhshow
has several default values:
.PP
.RS 5
.nf
mhshow-show-text/plain: %pmoreproc '%F'
mhshow-show-message/rfc822: %pshow -file '%F'
.fi
.RE
.PP
If a subtype of type text doesn't have a profile entry, it will be
treated as text/plain.
.PP
.B mhshow
has default methods for handling multipart messages of subtype
mixed, alternative, parallel, and digest.  Any unknown subtype of type
multipart (without a profile entry), will be treated as multipart/mixed.
.PP
If none of these apply, then
.B mhshow
will check to see if the message
has an application/octet-stream content with parameter \*(lqtype=tar\*(rq.
If so,
.B mhshow
will use an appropriate command.  If not,
.B mhshow
will complain.
.PP
Example entries might be:
.PP
.RS 5
.nf
mhshow-show-audio/basic: raw2audio 2>/dev/null | play
mhshow-show-image: xv '%f'
mhshow-show-application/PostScript: lpr -Pps
.fi
.RE
.PP
Note that when using the f- or F-escape, it's a good idea to use
single-quotes around the escape.  This prevents misinterpretation by
the shell of any funny characters that might be present in the filename.
.PP
Finally,
.B mhshow
will process each message serially\0--\0it won't start
showing the next message until all the commands executed to display the
current message have terminated.  In the case of a multipart content
(of any subtype listed above), the content contains advice indicating if
the parts should be displayed serially or in parallel.  Because this may
cause confusion, particularly on uni-window displays, the
.B \-serialonly
switch can be given to tell
.B mhshow
to never display parts in parallel.
.SS "Showing Alternate Character Sets"
Because a content of type text might be in a non-ASCII character
set, when
.B mhshow
encounters a \*(lqcharset\*(rq parameter for
this content, it checks if your terminal can display this character
set natively.
.B mhn
checks this by examining the the environment
variable
.BR $MM_CHARSET .
If the value of this environment variable is equal
to the value of the charset parameter, then
.B mhshow
assumes it can
display this content without any additional setup.  If this environment
variable is not set,
.B mhshow
will assume a value of \*(lqUS-ASCII\*(rq.
If the character set cannot be displayed natively, then
.B mhshow
will look for an entry of the form:
.PP
.RS 5
mhshow-charset-<charset>
.RE
.PP
which should contain a command creating an environment to render
the character set.  This command string should containing a single
\*(lq%s\*(rq, which will be filled-in with the command to display the
content.
.PP
Example entries might be:
.PP
.RS 5
mhshow-charset-iso-8859-1: xterm -fn '-*-*-medium-r-normal-*-*-120-*-*-c-*-iso8859-*' -e %s
.RE
.PP
or
.PP
.RS 5
mhshow-charset-iso-8859-1: '%s'
.RE
.PP
The first example tells
.B mhshow
to start
.B xterm
and load the
appropriate character set for that message content.  The second example
tells
.B mhshow
that your pager (or other program handling that content
type) can handle that character set, and that no special processing is
needed beforehand.
.PP
Note that many pagers strip off the high-order bit or have problems
displaying text with the high-order bit set.  However, the pager
.B less
has support for single-octet character sets.  The source
to
.B less
is available on many ftp sites carrying free software.
In order to view messages sent in the ISO-8859-1 character set using
.BR less ,
.PP
put these lines in your
.I \&.login
file:
.PP
.RS 5
.nf
setenv LESSCHARSET latin1
setenv LESS "-f"
.fi
.RE
.PP
The first line tells
.B less
to use the ISO-8859-1 definition for
determining whether a character is \*(lqnormal\*(rq, \*(lqcontrol\*(lq,
or \*(lqbinary\*(rq.  The second line tells
.B less
not to warn you
if it encounters a file that has non-ASCII characters.  Then, simply
set the
.I moreproc
profile entry to
.BR less ,
and it will get
called automatically.  (To handle other single-octet character sets,
look at the
.BR less (1)
manual entry for information about the
.B $LESSCHARDEF
environment variable.)
.SS "Messages of Type message/partial"
.B mhshow
cannot directly display messages of type partial.
You must reassemble them first into a normal message using
.BR mhstore .
Check the man page for
.BR mhstore (1)
for details.
.SS "External Access"
For contents of type message/external-body,
.B mhshow
supports these access-types:
.PP
.IP \(bu 4
afs
.IP \(bu 4
anon-ftp
.IP \(bu 4
ftp
.IP \(bu 4
local-file
.IP \(bu 4
mail-server
.PP
For the \*(lqanon-ftp\*(rq and \*(lqftp\*(rq access types,
.B mhshow
will look for the \*(lqnmh-access-ftp\*(rq
profile entry, e.g.,
.PP
.RS 5
nmh-access-ftp: myftp.sh
.RE
.PP
to determine the pathname of a program to perform the FTP retrieval.
.PP
This program is invoked with these arguments:
.PP
.RS 5
.nf
domain name of FTP-site
username
password
remote directory
remote filename
local filename
\*(lqascii\*(rq or \*(lqbinary\*(rq
.fi
.RE
.PP
The program should terminate with an exit status of zero if the
retrieval is successful, and a non-zero exit status otherwise.
.PP
If this entry is not provided, then
.B mhshow
will use a simple
built-in FTP client to perform the retrieval.
.SS "The Content Cache"
When
.B mhshow
encounters an external content containing a
\*(lqContent-ID:\*(rq field, and if the content allows caching, then
depending on the caching behavior of
.BR mhshow ,
the content might be read from or written to a cache.
.PP
The caching behavior of
.B mhshow
is controlled with the
.B \-rcache
and
.B \-wcache
switches, which define the policy for reading from,
and writing to, the cache, respectively.  One of four policies may be
specified: \*(lqpublic\*(rq, indicating that
.B mhshow
should make use
of a publically-accessible content cache; \*(lqprivate\*(rq, indicating
that
.B mhshow
should make use of the user's private content cache;
\*(lqnever\*(rq, indicating that
.B mhshow
should never make use of
caching; and, \*(lqask\*(rq, indicating that
.B mhshow
should ask the user.
.PP
There are two directories where contents may be cached: the profile entry
\*(lqnmh-cache\*(rq names a directory containing world-readable contents, and,
the profile entry \*(lqnmh-private-cache\*(rq names a directory containing
private contents.  The former should be an absolute (rooted) directory
name.
.PP
For example,
.PP
.RS 5
nmh-cache: /tmp
.RE
.PP
might be used if you didn't care that the cache got wiped after each
reboot of the system.  The latter is interpreted relative to the user's
nmh directory, if not rooted, e.g.,
.PP
.RS 5
nmh-private-cache: .cache
.RE
.PP
(which is the default value).
.SS "User Environment"
Because the display environment in which
.B mhshow
operates may vary for
different machines,
.B mhshow
will look for the environment variable
.BR $MHSHOW .
If present, this specifies the name of an additional
user profile which should be read.  Hence, when a user logs in on a
particular display device, this environment variable should be set to
refer to a file containing definitions useful for the given display device.
Normally, only entries that deal with the methods to display different
content type and subtypes
.PP
.RS 5
.nf
mhshow-show-<type>/<subtype>
mhshow-show-<type>
.fi
.RE
.PP
need be present in this additional profile. Finally,
.B mhshow
will attempt to consult one other additional user profile,
e.g.,
.PP
.RS 5
%etcdir%/mhn.defaults
.RE
.PP
which is created automatically during
.B nmh
installation.

.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
^$MHSHOW~^Additional profile entries
^%etcdir%/mhn.defaults~^System default MIME profile entries
^%etcdir%/mhl.headers~^The headers template
.fi

.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Current\-Folder:~^To find the default current folder
^Unseen\-Sequence:~^To name sequences denoting unseen messages
^mhlproc:~^Default program to display message headers
^nmh-access-ftp:~^Program to retrieve contents via FTP
^nmh-cache~^Public directory to store cached external contents
^nmh-private-cache~^Personal directory to store cached external contents
^mhshow-charset-<charset>~^Template for environment to render character sets
^mhshow-show-<type>*~^Template for displaying contents
^moreproc:~^Default program to display text/plain content
.fi

.SH "SEE ALSO"
mhbuild(1), mhl(1), mhlist(1), mhstore(1), sendfiles(1)

.SH DEFAULTS
.nf
.RB ` +folder "' defaults to the current folder"
.RB ` msgs "' defaults to cur"
.RB ` \-nocheck '
.RB ` \-form mhl.headers '
.RB ` \-pause '
.RB ` \-rcache ask '
.RB ` \-realsize '
.RB ` \-noserialonly '
.RB ` \-noverbose '
.RB ` \-wcache ask '
.fi

.SH CONTEXT
If a folder is given, it will become the current folder.  The last
message selected will become the current message.
