.\"
.\" %nmhwarning%
.\"
.TH MH-DRAFT %manext5% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
mh-draft \- draft folder facility for nmh message system
.SH SYNOPSIS
any
.B nmh
command
.SH DESCRIPTION
There are a number of interesting advanced facilities for the composition of
outgoing mail.
.PP
.SS "The Draft Folder"
The
.BR comp ,
.BR dist ,
.BR forw ,
and
.B repl
commands have two additional switches,
.B \-draftfolder
.I +folder
and
.B \-draftmessage
.I msg
which allow you to manipulate the various draft messages you are composing.
.PP
If
.B \-draftfolder
.I +folder
is used, these commands are
directed to construct a draft message in the indicated folder.
(The
.RI \*(lq Draft\-Folder \*(rq
profile entry may be used to declare a default draft folder for use with
.BR comp ,
.BR dist ,
.BR forw ,
and
.BR repl ).
.PP
If the swith
.B \-draftmessage
.I msg
is given, the specified draft is used to compose the message.  If
.B \-draftmessage
.I msg
is not used, then the
draft defaults to `new' (create a new draft) unless the user invokes
.B comp
with
.BR \-use ,
in which case the default is `cur'.
.PP
Hence, the user may have several message compositions in progress
simultaneously.  Now, all of the
.B nmh
tools are available on each of the user's message drafts (e.g.
.BR show ,
.BR scan ,
.BR pick ,
and so on).  If the folder does not exist, the user is asked if it should be
created (just like with
.BR refile ).
Also, the last draft message
the user was composing is known as `cur' in the draft folder.
.PP
Furthermore, the
.B send
command has these switches as well.  Hence,
from the shell, the user can send off whatever drafts desired using the
standard
.B nmh
`msgs' convention with
.B \-draftmessage
.IR msgs .
If no `msgs' are given, it defaults to `cur'.
.PP
In addition, all five programs have a
.B \-nodraftfolder
switch, which undoes the last occurrence of
.B \-draftfolder
.I folder
(useful if the latter occurs in the user's
.B nmh
profile).
.PP
If the user does not give the
.B \-draftfolder
.I +folder
switch, then all these commands act \*(lqnormally\*(rq.  Note that the
.B \-draft
switch to
.B send
and
.B show
still refers to the file called `draft' in the user's
.B nmh
directory.  In the interests of economy of expression, when using
.B comp
or
.BR send ,
the user needn't prefix the draft `msg' or `msgs' with
.BR \-draftmessage .
Both of these
commands accept a `file' or `files' argument, and they will, if given
.B \-draftfolder
.I +folder
treat these arguments as `msg' or `msgs'. (This may appear to be
inconsistent, at first, but it saves a lot of typing) Hence,
.PP
.RS
.nf
send -draftfolder +drafts first
.fi
.RE
.PP
is the same as
.PP
.RS
.nf
send -draftfolder +drafts -draftmessage first
.fi
.RE
.PP
To make all this a bit more clear, here are some examples.  Let's assume
that the following entries are in the
.B nmh
profile:
.PP
.RS 5
.nf
Draft\-Folder: +drafts
sendf: \-draftfolder +drafts
.fi
.RE
.PP
Furthermore, let's assume that the program
.B sendf
is a (symbolic) link in the user's
.I $HOME/bin/
directory to
.BR send .
Then, any of the commands
.PP
.RS 5
.nf
comp
dist
forw
repl
.fi
.RE
.PP
constructs the message draft in the `draft' folder using the `new'
message number.  Furthermore, they each define `cur' in this folder to
be that message draft.  If the user were to use the
.B quit
option at `What now?' level, then later on, if no other draft composition
was done, the draft could be sent with simply
.PP
.RS 5
.nf
sendf
.fi
.RE
.PP
Or, if more editing was required, the draft could be edited with
.PP
.RS 5
.nf
comp -use
.fi
.RE
.PP
Instead, if other drafts had been composed in the meantime, so that this
message draft was no longer known as `cur' in the `draft' folder, then
the user could
.B scan
the folder to see which message draft in the
folder should be used for editing or sending.  Clever users could even
employ a back-quoted
.B pick
to do the work:
.PP
.RS 5
.nf
comp -use `pick +drafts -to nmh-workers`
.fi
.RE
.PP
or
.PP
.RS 5
.nf
sendf `pick +drafts -to nmh-workers`
.fi
.RE
.PP
Note that in the
.B comp
example, the output from
.B pick
must resolve to a single message draft (it makes no sense to talk about
composing two or more drafts with one invocation of
.BR comp ).
In contrast, in the
.B send
example, as many message drafts as desired can appear, since
.B send
doesn't mind sending more than one draft at a time.
.PP
Note that the argument
.B \-draftfolder
.I +folder
is not included in the profile entry for
.BR send ,
since when
.BR comp ,
et. al., invoke
.B send
directly, they supply
.B send
with the UNIX pathname of the message draft, and
.B not
a
.B \-draftmessage
.I msg
argument. As far as
.B send
is concerned, a draft folder is not being used.
.PP
It is important to realize that
.B nmh
treats the draft folder like a standard
.B nmh
folder in nearly all respects.  There are two exceptions:
.PP
First, under no circumstancs will the
.B \-draftfolder
.I folder
switch cause the named folder to become the current folder.
.PP
Obviously, if the folder appeared in the context of a standard
.I +folder
argument to an
.B nmh
program, as in
.PP
.RS 5
.nf
scan +drafts
.fi
.RE
.PP
it might become the current folder, depending on the context changes of the
.B nmh
program in question.
.PP
Second, although conceptually
.B send
deletes the `msgs' named in the draft folder, it does not call
.I delete\-prog
to perform the deletion.

.SS "What Happens if the Draft Exists"
When the
.BR comp ,
.BR dist ,
.BR forw ,
and
.B repl
commands
are invoked and the draft you indicated already exists, these programs
will prompt the user for a reponse directing the program's action.
The prompt is
.PP
.RS 5
.nf
Draft ``/home/foobar/nmhbox/draft'' exists (xx bytes).
Disposition?
.fi
.RE
.PP
The appropriate responses and their meanings are:
.PP
.RS 5
.fc ^ ~
.nf
.ta \w'replace 'u
.BR ^replace~^ "- deletes the draft and starts afresh"
.BR ^list~^ "- lists the draft"
.BR ^refile~^ "- files the draft into a folder and starts afresh"
.BR ^quit~^ "- leaves the draft intact and exits"
.fi
.RE
.PP
In addition, if you specified
.B \-draftfolder
.I folder
to the command, then one other response will be accepted:
.PP
.RS 5
.fc ^ ~
.nf
.ta \w'replace 'u
.BR ^new~^ "- finds a new draft"
.fi
.RE
.PP
just as if
.B \-draftmessage
.I new
had been given.
Finally, the
.B comp
command will accept one more response:
.PP
.RS 5
.fc ^ ~
.nf
.ta \w'replace 'u
.BR ^use~^ "- re-uses the draft"
.fi
.RE
.PP
just as if
.B \-use
had been given.

.SH CONTEXT
None
