.\"
.\" %nmhwarning%
.\"
.TH MHPARAM %manext1% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
mhparam \- print nmh profile and context components
.SH SYNOPSIS
.na
.B mhparam
.RI [ components ]
.RB [ \-all ]
.RB [ \-component " | " \-nocomponent ]
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
.B mhparam
writes the value of the specified profile component to the
standard output separated by newlines.  If the profile component is not
present, the default value (or nothing if there is no default) is printed.
.PP
If the switch
.B \-component
is given, then the component name is displayed
along with the profile components value.  This can be disabled with the
switch
.BR \-nocomponent .
.PP
If more than one component is specified in the
.I components
list, then
the switch
.B \-component
is on by default.  If only one component is
specified, then the switch
.B \-nocomponent
is on by default.
.PP
If
.B \-all
is specified, then all components in the nmh profile are
displayed and other arguments are ignored.
.PP
Examples:
.PP
.RS 5
.nf
.ta \w'AliasFile:'u+2n
% mhparam path
Mail

% mhparam mhlproc
%libdir%/mhl

% mhparam \-component path
Path: Mail

% mhparam AliasFile rmmproc
AliasFile: aliases
rmmproc: rmmproc

% mhparam \-nocomponent AliasFile rmmproc
aliases
rmmproc

% mhparam path nonexistent context
Path: Mail
context: context
.fi
.RE
.PP
.B mhparam
is also useful in back\-quoted operations:
.PP
.RS 5
.nf
% fgrep cornell.edu `mhpath +`/`mhparam aliasfile`
.fi

.SH "EXIT STATUS"
.B mhparam
returns the number of components that were not found.

.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/.mh_profile~^The user profile
^or $MH~^Rather than the standard profile
^<mh-dir>/context~^The user context
^or $MHCONTEXT~^Rather than the standard context
.fi

.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^context:~^To determine the context file
.fi

.SH "SEE ALSO"
mh-profile(5)

.SH DEFAULTS
.nf
.RB ` \-nocomponent "' if only one component is specified"
.RB ` \-component "' if more than one component is specified"
.RB ` components "' defaults to none"
.fi

.SH CONTEXT
None
