.\"
.\" %nmhwarning%
.\"
.TH DIST %manext1% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
dist \- redistribute a message to additional addresses
.SH SYNOPSIS
.HP 5
.na
.B dist
.RI [ +folder ]
.RI [ msgs ]
.RB [ \-form
.IR formfile ]
.RB [ \-annotate " | " \-noannotate ] 
.RB [ \-inplace " | " \-noinplace ] 
.RB [ \-draftfolder
.IR +folder ]
.RB [ \-draftmessage
.IR msg ]
.RB [ \-nodraftfolder ]
.RB [ \-editor
.IR editor ]
.RB [ \-noedit ]
.RB [ \-whatnowproc
.IR program ]
.RB [ \-nowhatnowproc ]
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
.B Dist
is similar to
.BR forw .
It prepares the specified message
for redistribution to addresses that (presumably) are not on the original
address list.
.PP
The default message form contains the following elements:
.PP
.RS 5
.nf
%distcomps%
.fi
.RE
.PP
If a file named
.RI \*(lq distcomps \*(rq
exists in the user's nmh directory, it
will be used instead of this default form.  You may specify an alternate
forms file with the switch
.B \-form
.IR formfile .
The form used will be prepended to the message being resent.
.PP
If the draft already exists,
.B dist
will ask you as to the disposition of the draft.  A reply of
.B quit
will abort
.BR dist ,
leaving the draft intact;
.B replace
will replace the existing draft with a blank skeleton; and
.B list
will display the draft.
.PP
Only those addresses in
.RI \*(lq Resent\-To: \*(rq,
.RI \*(lq Resent\-cc: \*(rq,
and
.RI \*(lq Resent\-Bcc: \*(rq
will be sent.  Also, a
.RI \*(lq "Resent\-Fcc: folder" \*(rq
will be honored (see
.BR send (1)).
Note that with
.BR dist ,
the draft should contain only
.RI \*(lq Resent\-xxx: \*(rq
fields and no body.  The headers and the body of
the original message are copied to the draft when the message is sent.
Use care in constructing the headers for the redistribution.
.PP
If the
.B \-annotate
switch is given, the  message being distributed will
be annotated with the lines:

     Resent:\ date
     Resent:\ addrs

where each address list contains as many lines as required.  This
annotation will be done only if the message is sent directly from
.BR dist .
If the message is not sent immediately from
.BR dist ,
.RB \*(lq comp
.BR \-use \*(rq
may be used to re\-edit and send the constructed
message, but the annotations won't take place.  Normally annotations are
done inplace in order to preserve any links to the message.  You may use
the
.B \-noinplace
switch to change this.
.PP
See
.BR comp (1)
for a description of the
.B \-editor
and
.B \-noedit
switches.  Note that while in the editor, the message being resent
is available through a link named \*(lq@\*(rq (assuming the default
.IR whatnowproc ).
In addition, the actual pathname of the message is
stored in the environment variable
.BR $editalt ,
and the pathname of
the folder containing the message is stored in the environment variable
.BR $mhfolder .
.PP
The
.B \-draftfolder
.I +folder
and
.B \-draftmessage
.I msg
switches invoke the
.B nmh
draft folder facility.  This is an advanced (and highly
useful) feature.  Consult the
.BR mh-draft (5)
man page for more information.
.PP
Upon exiting from the editor,
.B dist
will invoke the
.B whatnow
program.  See
.BR whatnow (1)
for a discussion of available options.  The invocation of this
program can be inhibited by using the
.B \-nowhatnowproc
switch.  (In truth of fact, it is the
.B whatnow
program which starts the initial edit.  Hence,
.B \-nowhatnowproc
will prevent any edit from occurring.)

.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^%etcdir%/distcomps~^The standard message skeleton
^or <mh\-dir>/distcomps~^Rather than the standard skeleton
^$HOME/\&.mh\(ruprofile~^The user profile
^<mh\-dir>/draft~^The draft file
.fi

.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Current\-Folder:~^To find the default current folder
^Draft\-Folder:~^To find the default draft\-folder
^Editor:~^To override the default editor
^fileproc:~^Program to refile the message
^whatnowproc:~^Program to ask the \*(lqWhat now?\*(rq questions
.fi

.SH "SEE ALSO"
comp(1), forw(1), repl(1), send(1), whatnow(1)

.SH DEFAULTS
.nf
.RB ` +folder "' defaults to the current folder"
.RB ` msg "' defaults to cur"
.RB ` \-noannotate '
.RB ` \-nodraftfolder '
.RB ` \-inplace '
.fi

.SH CONTEXT
If a folder is given, it will become the current folder.  The message
distributed will become the current message.

.SH HISTORY
.B Dist
originally used headers of the form
.RI \*(lq Distribute\-xxx: \*(rq
instead of
.RI \*(lq Resent\-xxx: \*(rq.
In order to conform with the ARPA Internet standard, RFC\-822, the
.RI \*(lq Resent\-xxx: \*(rq
form is now used.
.B Dist
will recognize
.RI \*(lq Distribute\-xxx: \*(rq
type headers and automatically convert them to
.RI \*(lq Resent\-xxx: \*(rq.

.SH BUGS
.B Dist
does not rigorously check the message being distributed
for adherence to the transport standard, but
.B post
called by
.B send
does.  The
.B post
program will balk (and rightly so) at poorly formatted messages, and
.B dist
won't correct things for you.
.PP
If
.I whatnowproc
is
.BR whatnow ,
then
.B comp
uses a built\-in
.BR whatnow ,
it does not actually run the
.B whatnow
program.
Hence, if you define your own
.IR whatnowproc ,
don't call it
.B whatnow
since
.B comp
won't run it.
.PP
If your current working directory is not writable, the link named
\*(lq@\*(rq is not available.
