#!/data/local/bin/sh
#
# nitboot
#
# Launcher script to kickstart NIT's required proprietary software.
# Modified for NITdroid
#
# http://guug.org/nit/nitboot/
# Otto Solares Cabrera <solca@guug.org>

#
# nitboot configuration
#

PATH=/data/local/bin:$PATH
ROOTFS=/nokia
INITFS=/nokia/mnt/initfs
TRACE="/strace -ff -F -tt -s 200 -o /tmp/trace"

umask 0002
export PATH


#
# NITdroid specific
#

rm /system/etc/firmware
ln -s /nokia/mnt/initfs/usr/lib/hotplug/firmware /system/etc/firmware

boot_anim=`getprop ro.kernel.android.bootanim`
case "$boot_anim" in
    0)  setprop debug.sf.nobootanimation 1
    ;;
esac


#
# simulate native environment
#

if ! exists ${ROOTFS}; then
    mkdir ${ROOTFS}
fi
mount -t jffs2 -o ro /dev/block/mtdblock4 ${ROOTFS}
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to mount rootfs r/o."
    exit 1
fi

if ! exists ${INITFS}; then
    mkdir ${INITFS}
fi
mount -t jffs2 -o ro /dev/block/mtdblock3 ${INITFS}
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to mount initfs r/o."
    exit 1
fi

mount --bind /proc ${ROOTFS}/proc
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to mount /proc on rootfs."
    exit 1
fi

mount --bind /proc ${INITFS}/proc
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to mount /proc on initfs."
    exit 1
fi

mount --bind /sys ${ROOTFS}/sys
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to mount /sys on rootfs."
    exit 1
fi

mount --bind /sys ${INITFS}/sys
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to mount /sys on initfs."
    exit 1
fi

mount --bind ${INITFS}/dev ${ROOTFS}/dev
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to mount /dev on rootfs."
    exit 1
fi

mount -t tmpfs -o size=1M tmpfs ${ROOTFS}/tmp
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to mount /tmp on initfs."
    exit 1
fi

mount --bind ${ROOTFS}/tmp ${INITFS}/tmp
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to mount /tmp on rootfs."
    exit 1
fi

chroot ${INITFS} /bin/mkdir -p /tmp/dev
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to create /tmp/dev on initfs."
    exit 1
fi

chroot ${INITFS} /bin/mknod /tmp/dev/retu c 10 62
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to create /tmp/dev/retu node on initfs."
    exit 1
fi

chroot ${INITFS} /bin/mknod /tmp/dev/tahvo c 10 63
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to create /tmp/dev/tahvo node on initfs."
    exit 1
fi


#
# kickstart proprietary software
#

PRODUCT=$(chroot ${INITFS} /bin/sh -c "/bin/grep product /proc/component_version | /usr/bin/cut -c 13-")
if [ "${?}" -ne "0" ]; then
    unset PRODUCT
    echo "nitboot: fail to determine nit product."
    exit 1
fi

chroot ${INITFS} /sbin/dsme -d -v 4 -p /usr/lib/dsme/libstartup.so
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to launch dsme."
    exit 1
fi

chroot ${INITFS} /usr/sbin/waitfordsme
if [ "${?}" -ne "0" ]; then
    echo "nitboot: could not wait for dsme."
    exit 1
fi

chroot ${INITFS} /usr/bin/retutime -i
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to load the time from retu-rtc."
fi

if ! [ -z "${PRODUCT}" ]; then
    chroot ${INITFS} /usr/sbin/dsmetool -o /usr/bin/bme_${PRODUCT}
    if [ "${?}" -ne "0" ]; then
        echo "nitboot: fail to launch bme."
        exit 1
    fi
fi

chroot ${INITFS} /usr/sbin/dsmetool -o /usr/sbin/kicker
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to launch watchdog kicker."
    exit 1
fi

chroot ${INITFS} /usr/bin/bt-cal USER
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to calibrate bluetooth."
fi

chroot ${INITFS} /usr/sbin/dspctl kmem_reserve 360000
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to reserve mem for DSP."
fi

chroot ${ROOTFS} /usr/sbin/dsp_dld -p --enable-restart -c /lib/dsp/dsp_dld_avs.conf
if [ "${?}" -ne "0" ]; then
    echo "nitboot: fail to start the dynamic DSP task loader."
fi

exit 0
