/*
 * Decompiled with CFR 0.152.
 */
package se.kth.netzack;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.VolatileImage;
import javax.swing.Timer;
import se.kth.netzack.Config;

public class ZConsole
extends Canvas {
    private VolatileImage img;
    private Graphics g;
    int Y;
    int border;
    int line;
    Font font;
    private static int CAPACITY = 4;
    private Msg latest;

    private /* synthetic */ void finit$() {
        this.Y = 0;
        this.border = 0;
        this.line = 0;
        this.font = null;
        this.latest = new Msg(this);
    }

    ZConsole() {
        this.finit$();
        this.setVisible(true);
    }

    void init() {
        this.font = new Font(Config.FONT, 0, Config.FONT_SIZE);
        this.line = this.getGraphics().getFontMetrics(this.font).getHeight();
        this.Y = this.line * CAPACITY;
        this.border = (int)Math.round(0.3 * (double)this.line);
        this.setSize(this.getWidth(), this.Y);
        this.img = this.createVolatileImage(this.getWidth(), this.Y);
        if (this.img == null) {
            return;
        }
        this.g = this.img.getGraphics();
        this.update();
    }

    void print(String string) {
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) continue;
            this.latest = new Msg(this, this, this.latest, stringArray[i]);
        }
        this.update();
    }

    void update() {
        if (this.img == null) {
            return;
        }
        VolatileImage volatileImage = this.img;
        synchronized (volatileImage) {
            try {
                this.g.setColor(Color.black);
                this.g.fillRect(0, 0, this.getWidth(), this.Y);
                this.g.setFont(this.font);
                int n = 1;
                Msg msg = this.latest;
                while (msg != null) {
                    if (n > CAPACITY || msg.prune) {
                        msg.reset();
                        msg = null;
                        break;
                    }
                    if (msg.value != null) {
                        this.g.setColor(msg.color);
                        this.g.drawString(msg.value, this.border, this.Y - this.border - (n - 1) * Config.FONT_SIZE);
                    }
                    msg = msg.next;
                    ++n;
                }
                Object var2_3 = null;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                throw throwable;
            }
        }
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        VolatileImage volatileImage = this.img;
        synchronized (volatileImage) {
            try {
                graphics.drawImage(this.img, 0, 0, this);
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    private class Msg {
        private /* synthetic */ ZConsole this$0;
        public String value;
        public Msg next;
        public Color color;
        private ZConsole console;
        public boolean prune;
        ActionListener wait;
        ActionListener fade;
        Timer t;

        private /* synthetic */ void finit$() {
            this.next = null;
            this.color = Config.CONSOLE_COLOR;
            this.prune = false;
            this.wait = new ActionListener(this){
                private /* synthetic */ Msg this$1;
                {
                    this.this$1 = msg;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.t = new Timer(100, this.this$1.fade);
                    this.this$1.t.start();
                }
            };
            this.fade = new ActionListener(this){
                private /* synthetic */ Msg this$1;
                {
                    this.this$1 = msg;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.color = this.this$1.color.darker();
                    if (this.this$1.color.getRed() < 60) {
                        this.this$1.t.stop();
                        this.this$1.prune = true;
                    }
                    this.this$1.console.update();
                }
            };
            this.t = new Timer(Config.MSG_TIMEOUT, this.wait);
        }

        static /* synthetic */ ZConsole access$1(Msg msg, ZConsole zConsole) {
            msg.console = zConsole;
            return msg.console;
        }

        Msg(ZConsole zConsole) {
            this.this$0 = zConsole;
            this.finit$();
        }

        Msg(ZConsole zConsole, ZConsole zConsole2, Msg msg, String string) {
            this.this$0 = zConsole;
            this.finit$();
            this.console = zConsole2;
            this.value = string;
            this.next = msg;
            this.t.start();
        }

        void reset() {
            if (this.next != null) {
                this.next.reset();
            }
            this.next = null;
            this.t.stop();
        }
    }
}

