/*
 * Decompiled with CFR 0.152.
 */
package se.kth.netzack;

import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.VolatileImage;
import java.util.Iterator;
import java.util.Map;
import se.kth.netzack.Config;
import se.kth.netzack.DeadException;
import se.kth.netzack.Player;

public class ZCanvas
extends Canvas {
    private Map players;
    static final BasicStroke stroke = new BasicStroke(Config.wormWidth);
    private VolatileImage img;
    private short[][] hit;
    short n;
    Graphics2D g2;

    private /* synthetic */ void finit$() {
        this.hit = new short[Config.X][Config.Y];
        this.n = 0;
    }

    ZCanvas(Map map) {
        this.finit$();
        this.players = map;
        this.setBackground(Color.white);
        this.setSize(new Dimension(Config.X + 2 * Config.BORDER, Config.Y + 2 * Config.BORDER));
        this.setIgnoreRepaint(false);
        this.setVisible(true);
        this.clear();
    }

    public void initBuffers() {
    }

    public void clear() {
        this.img = null;
        for (int i = 0; i < Config.X; ++i) {
            for (int j = 0; j < Config.Y; ++j) {
                this.hit[i][j] = 0;
            }
        }
    }

    public int paintWorms(long l) {
        if (this.img == null || this.hit == null) {
            this.img = this.createVolatileImage(Config.X, Config.Y);
            this.g2 = (Graphics2D)this.img.getGraphics();
            this.g2.setColor(Color.black);
            this.g2.fillRect(0, 0, this.img.getWidth(), this.img.getHeight());
        }
        int n = 0;
        this.n = (short)(this.n + 1);
        if (this.n == 0) {
            this.n = 1;
        }
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Map map = this.players;
        synchronized (map) {
            try {
                Iterator iterator = this.players.values().iterator();
                while (iterator.hasNext()) {
                    Player player = (Player)iterator.next();
                    if (!player.isPlaying) continue;
                    try {
                        player.worm.paint(this.g2, this.hit, l, this.n);
                    }
                    catch (DeadException deadException) {
                        player.youDied();
                    }
                    ++n;
                }
                iterator = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        this.repaint();
        int n2 = n;
        return n2;
    }

    public void update(Graphics graphics) {
        if (this.img != null) {
            graphics.drawImage(this.img, Config.BORDER, Config.BORDER, this);
        }
    }

    public void paint(Graphics graphics) {
        int n;
        Color[] colorArray = new Color[Config.BORDER];
        colorArray[Config.BORDER - 1] = Color.white.darker();
        for (n = Config.BORDER - 2; n >= 0; --n) {
            colorArray[n] = colorArray[n + 1].darker();
        }
        for (n = 0; n < Config.BORDER; ++n) {
            graphics.setColor(colorArray[n]);
            graphics.drawRect(n, n, Config.X + 2 * (Config.BORDER - n) - 1, Config.Y + 2 * (Config.BORDER - n) - 1);
        }
        if (this.img != null) {
            graphics.drawImage(this.img, Config.BORDER, Config.BORDER, this);
        } else {
            graphics.setColor(Color.black);
            graphics.fillRect(Config.BORDER, Config.BORDER, Config.X, Config.Y);
        }
    }
}

