/*
 * Decompiled with CFR 0.152.
 */
package se.kth.netzack;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import se.kth.netzack.Config;
import se.kth.netzack.Message;
import se.kth.netzack.Netzack;
import se.kth.netzack.Packet;
import se.kth.netzack.PrivateChannel;
import se.kth.netzack.Server;

public class PublicChannel
extends Thread {
    MulticastSocket socket;
    Server server;
    PrivateChannel priv;
    Object lock;

    PublicChannel(Server server, Object object) {
        super("PublicChannel");
        Object object2;
        this.lock = object;
        try {
            this.socket = new MulticastSocket(Server.PUBLIC_PORT);
            this.socket.setTimeToLive(Config.TTL);
            this.socket.joinGroup(Server.GROUP);
        }
        catch (IOException iOException) {
            Netzack.error(iOException);
        }
        this.server = server;
        Object object3 = object2 = new Object();
        synchronized (object3) {
            try {
                this.priv = new PrivateChannel(this.server, object2);
                try {
                    object2.wait();
                }
                catch (InterruptedException interruptedException) {
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                throw throwable;
            }
        }
        this.start();
    }

    protected void finalize() throws Throwable {
        try {
            this.socket.leaveGroup(Server.GROUP);
            this.socket.close();
        }
        finally {
            Object var1_1 = null;
            super.finalize();
        }
    }

    public void run() {
        if (!this.socket.isBound()) {
            Netzack.debug("Premature exit: PublicChannel thread");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Packet packet;
            try {
                this.lock.notify();
            }
            finally {
                packet = null;
            }
            packet = new Packet();
            try {
                while (true) {
                    DatagramPacket datagramPacket = packet.receive(this.socket);
                    int n = packet.readInt();
                    if (n == this.server.id) continue;
                    Message message = packet.getMsg();
                    if (message.equals(Message.ECHO)) {
                        Packet packet2 = null;
                        packet2 = packet.readBoolean() ? Packet.echoPacket(this.server.getPort(), Server.localAddress.getAddress()) : Packet.echoPacket();
                        if (packet2 == null) continue;
                        this.priv.send(packet2, datagramPacket.getSocketAddress());
                        packet2.release();
                        continue;
                    }
                    if (!message.equals(Message.RECONNECT)) continue;
                    int n2 = packet.readInt();
                    int n3 = packet.readInt();
                    byte[] byArray = (byte[])packet.readObject();
                    InetAddress inetAddress = InetAddress.getByAddress(byArray);
                    this.server.reconnect(n2, inetAddress, n3);
                }
            }
            catch (IOException iOException) {
                Netzack.debug(iOException);
                packet.release();
                return;
            }
        }
    }

    public void send(Packet packet) {
        this.priv.send(packet);
        packet.release();
    }
}

