/**
 * WebAdmin
 * Copyright (C) 2006 Netwosix Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Linking WebAdmin statically or dynamically with other modules is making
 * a combined work based on WebAdmin. Thus, the terms and conditions of the 
 * GNU General Public License cover the whole combination.
 *
 * In addition, as a special exception, the copyright holders of
 * WebAdmin give you permission to combine WebAdmin with free software
 * programs or libraries that are released under the GNU LGPL and with
 * code included in the standard release of OpenSSL under the OpenSSL
 * License and SSLeay License (or modified versions of such code, with
 * unchanged licenses). You may copy and distribute such a system
 * following the terms of the GNU GPL for WebAdmin and the licenses of
 * the other code concerned, provided that you include the source code of
 * that other code when and as the GNU GPL requires distribution of
 * source code.
 *
 * Note that people who make modified versions of WebAdmin are not obligated
 * to grant this special exception for their modified versions; 
 * it is their choice whether to do so. The GNU General Public License 
 * gives permission to release a modified version without this exception; 
 * this exception also makes it possible to release a modified 
 * version which carries forward this exception.
 */

#include <agent.h>

#include <unistd.h>
#include <sys/utsname.h>



/**
 * This function is called automatically for every request recevide on stdin.
 * The XML data returned is automatically inserted in the response and the
 * written on stdout. 
 */
AlString * agent_info_response_create(const AgentRequest * request, const char * data)
{
	AlXmlList      * list = al_xml_list_new();
	AlXmlNode      * node;
	size_t           hostname_len = 100;
	char             hostname[hostname_len];
	struct utsname   buf;



	uname(&buf);
	gethostname(hostname, hostname_len);

	/*
	 * <info>
	 *	<uname sysname="" nodename="" release="" version="" machine=""/>
	 *	<network hostname=""/>
	 * </info>
	 */

	list->node = al_xml_node_new();
	al_xml_node_set_name(list->node, "info");

	node = al_xml_node_new();

	al_xml_node_set_name(node, "uname");
	al_xml_node_attribute_new(node, "sysname", buf.sysname);
	al_xml_node_attribute_new(node, "nodename", buf.nodename);
	al_xml_node_attribute_new(node, "release", buf.release);
	al_xml_node_attribute_new(node, "version", buf.version);
	al_xml_node_attribute_new(node, "machine", buf.machine);

	al_xml_list_node_add(list, node);

	node = al_xml_node_new();

	al_xml_node_set_name(node, "network");
	al_xml_node_attribute_new(node, "hostname", hostname);

	al_xml_list_node_add(list, node);

	return (list) ? al_xml_list_to_string(list, NULL, NULL) : NULL;
}


AGENT_DEFAULT_MAIN("agent-info", agent_info_response_create);
