/**
 * WebAdmin
 * Copyright (C) 2006 Netwosix Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Linking WebAdmin statically or dynamically with other modules is making
 * a combined work based on WebAdmin. Thus, the terms and conditions of the 
 * GNU General Public License cover the whole combination.
 *
 * In addition, as a special exception, the copyright holders of
 * WebAdmin give you permission to combine WebAdmin with free software
 * programs or libraries that are released under the GNU LGPL and with
 * code included in the standard release of OpenSSL under the OpenSSL
 * License and SSLeay License (or modified versions of such code, with
 * unchanged licenses). You may copy and distribute such a system
 * following the terms of the GNU GPL for WebAdmin and the licenses of
 * the other code concerned, provided that you include the source code of
 * that other code when and as the GNU GPL requires distribution of
 * source code.
 *
 * Note that people who make modified versions of WebAdmin are not obligated
 * to grant this special exception for their modified versions; 
 * it is their choice whether to do so. The GNU General Public License 
 * gives permission to release a modified version without this exception; 
 * this exception also makes it possible to release a modified 
 * version which carries forward this exception.
 */

#ifndef UTIL_H_
#define UTIL_H_


/**
 */
#define al_new(type)                     (type*)malloc(sizeof(type))


/**
 */
#define al_new_n(type,n)                 (type*)malloc(sizeof(type) * n)


/**
 */
#define al_new0(type)                    (type*)calloc(1, sizeof(type))


/**
 */
#define al_new_n0(type,n)                (type*)calloc(n, sizeof(type))


/**
 */
#define al_strdup(s)                     ((s) ? strdup(s) : NULL)


/**
 */
#define al_delete(p)                     do { if (p) free(p); p = NULL; } while(0)


/**
 */
#define al_return_if_fail(cnd)           if (!(cnd)) return;


/**
 */
#define al_return_val_if_fail(cnd,val)   if (!(cnd)) return val;


/**
 */
#ifdef AL_LOG
	#define al_log(args)                     do { printf args ; } while (0)
#else
	#define al_log(args)                     do {  } while (0)
#endif


/**
 * Read the content of a file.
 *
 * @param file_name filename
 *
 * @return the content of file or NULL if not found
 */
AlString * al_read_file_by_name(const char * file_name);


/**
 * Read the content of a file.
 *
 * @param file file
 *
 * @return the content of file or NULL if not found
 */
AlString * al_read_file(FILE * file);


/**
 * Print error on stderr and exit.
 *
 * @param ret ret value
 * @param fmt error msg
 */
void al_exit(int ret, const char * fmt, ...);


#endif /* UTIL_H_ */
