/**
 * WebAdmin
 * Copyright (C) 2006 Netwosix Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Linking WebAdmin statically or dynamically with other modules is making
 * a combined work based on WebAdmin. Thus, the terms and conditions of the 
 * GNU General Public License cover the whole combination.
 *
 * In addition, as a special exception, the copyright holders of
 * WebAdmin give you permission to combine WebAdmin with free software
 * programs or libraries that are released under the GNU LGPL and with
 * code included in the standard release of OpenSSL under the OpenSSL
 * License and SSLeay License (or modified versions of such code, with
 * unchanged licenses). You may copy and distribute such a system
 * following the terms of the GNU GPL for WebAdmin and the licenses of
 * the other code concerned, provided that you include the source code of
 * that other code when and as the GNU GPL requires distribution of
 * source code.
 *
 * Note that people who make modified versions of WebAdmin are not obligated
 * to grant this special exception for their modified versions; 
 * it is their choice whether to do so. The GNU General Public License 
 * gives permission to release a modified version without this exception; 
 * this exception also makes it possible to release a modified 
 * version which carries forward this exception.
 */

#ifndef AL_STRING_H_
#define AL_STRING_H_



/**
 * Structure with a string
 */
struct _AlString
{

	char * s;
	int    len;
	int    allocated;

};

typedef struct _AlString AlString;


/**
 * Return the string
 *
 * @param string string
 *
 * @return the string
 */
#define al_string_get(string)                       (string)->s


/**
 */
#define al_string_len(string)                       (string)->len

/**
 * Create a new string.
 *
 * @return a new empty string
 */
AlString * al_string_new(void);


/**
 * Delete a string.
 *
 * @param string strind to delete
 */
void al_string_delete(AlString * string);


/**
 * Append a char to string
 *
 * @param string string
 * @param c char to append
 */
void al_string_append_char(AlString * string, char c);


/**
 * Delete last char of string
 *
 * @param string string
 */
void al_string_delete_last_char(AlString * string);


/**
 * Set the string
 *
 * @param string string 
 * @param s new string
 */
void al_string_set(AlString * string, const char * s);


#endif /* AL_STRING_H_ */
