/**
 * WebAdmin
 * Copyright (C) 2006 Netwosix Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Linking WebAdmin statically or dynamically with other modules is making
 * a combined work based on WebAdmin. Thus, the terms and conditions of the 
 * GNU General Public License cover the whole combination.
 *
 * In addition, as a special exception, the copyright holders of
 * WebAdmin give you permission to combine WebAdmin with free software
 * programs or libraries that are released under the GNU LGPL and with
 * code included in the standard release of OpenSSL under the OpenSSL
 * License and SSLeay License (or modified versions of such code, with
 * unchanged licenses). You may copy and distribute such a system
 * following the terms of the GNU GPL for WebAdmin and the licenses of
 * the other code concerned, provided that you include the source code of
 * that other code when and as the GNU GPL requires distribution of
 * source code.
 *
 * Note that people who make modified versions of WebAdmin are not obligated
 * to grant this special exception for their modified versions; 
 * it is their choice whether to do so. The GNU General Public License 
 * gives permission to release a modified version without this exception; 
 * this exception also makes it possible to release a modified 
 * version which carries forward this exception.
 */

#include "al.h"



/**
 * Wait for a new connection. There is a new connection when a EOF is find on stdio.
 *
 * @param connection_manager connection manager
 *
 * @return the new connection or NULL if not found.
 */
AlConnection * al_stdio_connection_manager_wait(AlConnectionManager * connection_manager);


/**
 * Do nothing.
 *
 * @param connection connection to close
 */
void al_stdio_connection_close(AlConnection * connection);


/**
 * Read a request from stdio.
 *
 * @param connection_manager connection manager
 *
 * @return the read paket NULL if not found.
 */
AlString * al_stdio_connection_read(AlConnection * connection);


/**
 * Send a packet to stdio.
 *
 * @param connection_manager connection manager
 * @param packet packet to send
 */
void al_stdio_connection_send(AlConnection * connection, const AlString * packet);


/**
 * Do nothing
 */
AlConnection * al_stdio_connection_manager_connect(AlConnectionManager * connection_manager, const char * server);


/**
 */
AlConnectionManager * al_stdio_connection_manager_new(void)
{
	AlConnectionManager * connection = al_connection_manager_new(al_stdio_connection_manager_wait,
								     NULL,
								     al_stdio_connection_manager_connect,
								     0, 
								     NULL);

	return connection;
}


/**
 */
AlConnection * al_stdio_connection_manager_wait(AlConnectionManager * connection_manager)
{
	static AlConnection * ret = NULL;


	al_return_val_if_fail(connection_manager, NULL);

	if (ret == NULL)
		ret = al_connection_new(connection_manager,
					al_stdio_connection_read,
					al_stdio_connection_send,
					al_stdio_connection_close,
					NULL,
					NULL);
	else
		ret = NULL;

	return ret;
}


/**
 */
void al_stdio_connection_close(AlConnection * connection)
{
}


/**
 */
AlString * al_stdio_connection_read(AlConnection * connection)
{
	AlString    * s = NULL;
	static char   first = 0;


	al_return_val_if_fail(connection, NULL);

	if (!first)
	{
		first = 1;
		s = al_read_file(stdin);
	}

	return s;
}


/**
 */
void al_stdio_connection_send(AlConnection * connection, const AlString * packet)
{
	al_return_if_fail(connection && packet);


	printf("%s", al_string_get(packet));

}


/**
 */
AlConnection * al_stdio_connection_manager_connect(AlConnectionManager * connection_manager, const char * server)
{
	return NULL;
}
