/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.rewire;

import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.rewire.AbstractRewire;
import org.nongnu.multigraph.rewire.EdgeLabeler;
import org.nongnu.multigraph.rewire.RandomRewire;

public class LatticeRewire<N, E>
extends AbstractRewire<N, E> {
    int cols;

    public LatticeRewire(Graph<N, E> graph, EdgeLabeler<N, E> edgeLabeler, int n) {
        super(graph, edgeLabeler);
        this.cols = n > 0 ? n : (int)Math.sqrt(graph.size());
    }

    public LatticeRewire(Graph<N, E> graph, EdgeLabeler<N, E> edgeLabeler) {
        super(graph, edgeLabeler);
        this.cols = (int)Math.sqrt(graph.size());
    }

    @Override
    public void rewire() {
        Object[] objectArray = new Object[this.cols];
        Object var2_2 = null;
        int n = 0;
        RandomRewire.clear(this.graph);
        for (Object e : this.graph) {
            Object l;
            if (var2_2 != null && (l = this.el.getLabel(var2_2, e)) != null) {
                this.graph.set(var2_2, e, l);
            }
            if (objectArray[n] != null && (l = this.el.getLabel(objectArray[n], e)) != null) {
                this.graph.set(objectArray[n], e, l);
            }
            objectArray[n] = e;
            var2_2 = e;
            ++n;
            if ((n %= this.cols) != 0) continue;
            var2_2 = null;
        }
    }
}

